/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.jdbc.logging;

import com.ibatis.common.beans.ClassInfo;
import com.ibatis.common.jdbc.logging.BaseLogProxy;
import com.ibatis.common.jdbc.logging.PreparedStatementLogProxy;
import com.ibatis.common.jdbc.logging.StatementLogProxy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConnectionLogProxy
extends BaseLogProxy
implements InvocationHandler {
    private static final Log log = LogFactory.getLog((Class)(class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionLogProxy.class$("java.sql.Connection")) : class$java$sql$Connection));
    private Connection connection;
    static /* synthetic */ Class class$java$sql$Connection;

    private ConnectionLogProxy(Connection conn) {
        this.connection = conn;
        if (log.isDebugEnabled()) {
            log.debug((Object)("{conn-" + this.id + "} Connection"));
        }
    }

    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if ("prepareStatement".equals(method.getName())) {
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogProxy.newInstance(stmt, (String)params[0]);
                return stmt;
            }
            if ("prepareCall".equals(method.getName())) {
                PreparedStatement stmt = (PreparedStatement)method.invoke((Object)this.connection, params);
                stmt = PreparedStatementLogProxy.newInstance(stmt, (String)params[0]);
                return stmt;
            }
            if ("createStatement".equals(method.getName())) {
                Statement stmt = (Statement)method.invoke((Object)this.connection, params);
                stmt = StatementLogProxy.newInstance(stmt);
                return stmt;
            }
            return method.invoke((Object)this.connection, params);
        }
        catch (Throwable t) {
            throw ClassInfo.unwrapThrowable(t);
        }
    }

    public static Connection newInstance(Connection conn) {
        ConnectionLogProxy handler = new ConnectionLogProxy(conn);
        ClassLoader cl = (class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionLogProxy.class$("java.sql.Connection")) : class$java$sql$Connection).getClassLoader();
        return (Connection)Proxy.newProxyInstance(cl, new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionLogProxy.class$("java.sql.Connection")) : class$java$sql$Connection}, (InvocationHandler)handler);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

