/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.selector;

import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import com.mongodb.selector.ServerSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyMinimizingServerSelector
implements ServerSelector {
    private final long acceptableLatencyDifferenceNanos;

    public LatencyMinimizingServerSelector(long acceptableLatencyDifference, TimeUnit timeUnit) {
        this.acceptableLatencyDifferenceNanos = TimeUnit.NANOSECONDS.convert(acceptableLatencyDifference, timeUnit);
    }

    public long getAcceptableLatencyDifference(TimeUnit timeUnit) {
        return timeUnit.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() != ClusterConnectionMode.MULTIPLE) {
            return clusterDescription.getAny();
        }
        return this.getServersWithAcceptableLatencyDifference(clusterDescription.getAny(), this.getFastestRoundTripTimeNanos(clusterDescription.getAll()));
    }

    public String toString() {
        return "LatencyMinimizingServerSelector{acceptableLatencyDifference=" + TimeUnit.MILLISECONDS.convert(this.acceptableLatencyDifferenceNanos, TimeUnit.NANOSECONDS) + " ms" + '}';
    }

    private long getFastestRoundTripTimeNanos(Set<ServerDescription> members) {
        long fastestRoundTripTime = Long.MAX_VALUE;
        for (ServerDescription cur : members) {
            if (!cur.isOk() || cur.getRoundTripTimeNanos() >= fastestRoundTripTime) continue;
            fastestRoundTripTime = cur.getRoundTripTimeNanos();
        }
        return fastestRoundTripTime;
    }

    private List<ServerDescription> getServersWithAcceptableLatencyDifference(List<ServerDescription> servers, long bestPingTime) {
        ArrayList<ServerDescription> goodSecondaries = new ArrayList<ServerDescription>(servers.size());
        for (ServerDescription cur : servers) {
            if (!cur.isOk() || cur.getRoundTripTimeNanos() - this.acceptableLatencyDifferenceNanos > bestPingTime) continue;
            goodSecondaries.add(cur);
        }
        return goodSecondaries;
    }
}

