/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.operation.BaseWriteOperation;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperation
extends BaseWriteOperation {
    private final List<DeleteRequest> deleteRequests;

    public DeleteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deleteRequests) {
        super(namespace, ordered, writeConcern);
        this.deleteRequests = Assertions.notNull("removes", deleteRequests);
    }

    public List<DeleteRequest> getDeleteRequests() {
        return this.deleteRequests;
    }

    @Override
    protected WriteConcernResult executeProtocol(Connection connection) {
        return connection.delete(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests);
    }

    @Override
    protected void executeProtocolAsync(AsyncConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        connection.deleteAsync(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests, callback);
    }

    @Override
    protected BulkWriteResult executeCommandProtocol(Connection connection) {
        return connection.deleteCommand(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests);
    }

    @Override
    protected void executeCommandProtocolAsync(AsyncConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        connection.deleteCommandAsync(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests, callback);
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.DELETE;
    }

    @Override
    protected int getCount(BulkWriteResult bulkWriteResult) {
        return bulkWriteResult.getDeletedCount();
    }
}

