/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoCredential;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.UserOperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.Arrays;
import org.bson.BsonDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateUserOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoCredential credential;
    private final boolean readOnly;

    public CreateUserOperation(MongoCredential credential, boolean readOnly) {
        this.credential = Assertions.notNull("credential", credential);
        this.readOnly = readOnly;
    }

    public MongoCredential getCredential() {
        return this.credential;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Void execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                    CommandOperationHelper.executeWrappedCommandProtocol(binding, CreateUserOperation.this.getCredential().getSource(), CreateUserOperation.this.getCommand(), connection);
                } else {
                    connection.insert(CreateUserOperation.this.getNamespace(), true, WriteConcern.ACKNOWLEDGED, Arrays.asList(CreateUserOperation.this.getInsertRequest()));
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection);
                    if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, CreateUserOperation.this.credential.getSource(), CreateUserOperation.this.getCommand(), connection, new OperationHelper.VoidTransformer<BsonDocument>(), wrappedCallback);
                    } else {
                        connection.insertAsync(CreateUserOperation.this.getNamespace(), true, WriteConcern.ACKNOWLEDGED, Arrays.asList(CreateUserOperation.this.getInsertRequest()), new SingleResultCallback<WriteConcernResult>(){

                            @Override
                            public void onResult(WriteConcernResult result, Throwable t) {
                                wrappedCallback.onResult(null, t);
                            }
                        });
                    }
                }
            }
        });
    }

    private InsertRequest getInsertRequest() {
        return new InsertRequest(UserOperationHelper.asCollectionInsertDocument(this.credential, this.readOnly));
    }

    private MongoNamespace getNamespace() {
        return new MongoNamespace(this.credential.getSource(), "system.users");
    }

    private BsonDocument getCommand() {
        return UserOperationHelper.asCommandDocument(this.credential, this.readOnly, "createUser");
    }
}

