/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.annotations.Beta;
import com.mongodb.event.ConnectionEvent;
import com.mongodb.event.ConnectionPoolEvent;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.event.ConnectionPoolOpenedEvent;
import com.mongodb.event.ConnectionPoolWaitQueueEvent;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Beta
public class ConnectionPoolEventMulticaster
implements ConnectionPoolListener {
    private final Set<ConnectionPoolListener> connectionPoolListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void add(ConnectionPoolListener connectionPoolListener) {
        this.connectionPoolListeners.add(connectionPoolListener);
    }

    public void remove(ConnectionPoolListener connectionPoolListener) {
        this.connectionPoolListeners.remove(connectionPoolListener);
    }

    public void connectionPoolOpened(ConnectionPoolOpenedEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.connectionPoolOpened(event);
        }
    }

    public void connectionPoolClosed(ConnectionPoolEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.connectionPoolClosed(event);
        }
    }

    public void connectionCheckedOut(ConnectionEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.connectionCheckedOut(event);
        }
    }

    public void connectionCheckedIn(ConnectionEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.connectionCheckedIn(event);
        }
    }

    public void waitQueueEntered(ConnectionPoolWaitQueueEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.waitQueueEntered(event);
        }
    }

    public void waitQueueExited(ConnectionPoolWaitQueueEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.waitQueueExited(event);
        }
    }

    public void connectionAdded(ConnectionEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.connectionAdded(event);
        }
    }

    public void connectionRemoved(ConnectionEvent event) {
        for (ConnectionPoolListener cur : this.connectionPoolListeners) {
            cur.connectionRemoved(event);
        }
    }
}

