/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.event;

import com.mongodb.annotations.Beta;
import com.mongodb.event.ClusterDescriptionChangedEvent;
import com.mongodb.event.ClusterEvent;
import com.mongodb.event.ClusterListener;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Beta
public class ClusterEventMulticaster
implements ClusterListener {
    private final Set<ClusterListener> clusterListeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public void add(ClusterListener clusterListener) {
        this.clusterListeners.add(clusterListener);
    }

    public void remove(ClusterListener clusterListener) {
        this.clusterListeners.remove(clusterListener);
    }

    public void clusterOpened(ClusterEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            cur.clusterOpened(event);
        }
    }

    public void clusterClosed(ClusterEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            cur.clusterClosed(event);
        }
    }

    public void clusterDescriptionChanged(ClusterDescriptionChangedEvent event) {
        for (ClusterListener cur : this.clusterListeners) {
            cur.clusterDescriptionChanged(event);
        }
    }
}

