/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.connection.Base64Codec;
import com.mongodb.connection.SaslAuthenticator;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

class ScramSha1Authenticator
extends SaslAuthenticator {
    private final RandomStringGenerator randomStringGenerator;

    ScramSha1Authenticator(MongoCredential credential) {
        this(credential, new DefaultRandomStringGenerator());
    }

    ScramSha1Authenticator(MongoCredential credential, RandomStringGenerator randomStringGenerator) {
        super(credential);
        this.randomStringGenerator = randomStringGenerator;
    }

    public String getMechanismName() {
        return AuthenticationMechanism.SCRAM_SHA_1.getMechanismName();
    }

    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        return new ScramSha1SaslClient(this.getCredential(), this.randomStringGenerator);
    }

    public static class DefaultRandomStringGenerator
    implements RandomStringGenerator {
        public String generate(int length) {
            int comma = 44;
            int low = 33;
            int high = 126;
            int range = high - low;
            SecureRandom random = new SecureRandom();
            char[] text = new char[length];
            for (int i = 0; i < length; ++i) {
                int next = random.nextInt(range) + low;
                while (next == comma) {
                    next = random.nextInt(range) + low;
                }
                text[i] = (char)next;
            }
            return new String(text);
        }
    }

    public static interface RandomStringGenerator {
        public String generate(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScramSha1SaslClient
    implements SaslClient {
        private static final String GS2_HEADER = "n,,";
        private static final int RANDOM_LENGTH = 24;
        private final Base64Codec base64Codec;
        private final MongoCredential credential;
        private String clientFirstMessageBare;
        private final RandomStringGenerator randomStringGenerator;
        private String rPrefix;
        private byte[] serverSignature;
        private int step;

        ScramSha1SaslClient(MongoCredential credential, RandomStringGenerator randomStringGenerator) {
            this.credential = credential;
            this.base64Codec = new Base64Codec();
            this.randomStringGenerator = randomStringGenerator;
        }

        @Override
        public String getMechanismName() {
            return AuthenticationMechanism.SCRAM_SHA_1.getMechanismName();
        }

        @Override
        public boolean hasInitialResponse() {
            return true;
        }

        @Override
        public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
            if (this.step == 0) {
                ++this.step;
                return this.computeClientFirstMessage();
            }
            if (this.step == 1) {
                ++this.step;
                return this.computeClientFinalMessage(challenge);
            }
            if (this.step == 2) {
                ++this.step;
                String serverResponse = this.encodeUTF8(challenge);
                HashMap<String, String> map = this.parseServerResponse(serverResponse);
                if (!MessageDigest.isEqual(this.decodeBase64(map.get("v")), this.serverSignature)) {
                    throw new SaslException("Server signature was invalid.");
                }
                return challenge;
            }
            throw new SaslException("Too many steps involved in the SCRAM-SHA-1 negotiation.");
        }

        @Override
        public boolean isComplete() {
            return this.step > 2;
        }

        @Override
        public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public Object getNegotiatedProperty(String propName) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        @Override
        public void dispose() throws SaslException {
        }

        private byte[] computeClientFirstMessage() throws SaslException {
            String userName = "n=" + this.prepUserName(this.credential.getUserName());
            this.rPrefix = this.randomStringGenerator.generate(24);
            String nonce = "r=" + this.rPrefix;
            this.clientFirstMessageBare = userName + "," + nonce;
            String clientFirstMessage = GS2_HEADER + this.clientFirstMessageBare;
            return this.decodeUTF8(clientFirstMessage);
        }

        private byte[] computeClientFinalMessage(byte[] challenge) throws SaslException {
            String serverFirstMessage = this.encodeUTF8(challenge);
            HashMap<String, String> map = this.parseServerResponse(serverFirstMessage);
            String r = map.get("r");
            if (!r.startsWith(this.rPrefix)) {
                throw new SaslException("Server sent an invalid nonce.");
            }
            String s = map.get("s");
            String i = map.get("i");
            String channelBinding = "c=" + this.encodeBase64(this.decodeUTF8(GS2_HEADER));
            String nonce = "r=" + r;
            String clientFinalMessageWithoutProof = channelBinding + "," + nonce;
            byte[] saltedPassword = this.hi(NativeAuthenticationHelper.createAuthenticationHash(this.credential.getUserName(), this.credential.getPassword()), this.decodeBase64(s), Integer.parseInt(i));
            byte[] clientKey = this.hmac(saltedPassword, "Client Key");
            byte[] storedKey = this.h(clientKey);
            String authMessage = this.clientFirstMessageBare + "," + serverFirstMessage + "," + clientFinalMessageWithoutProof;
            byte[] clientSignature = this.hmac(storedKey, authMessage);
            byte[] clientProof = this.xor(clientKey, clientSignature);
            byte[] serverKey = this.hmac(saltedPassword, "Server Key");
            this.serverSignature = this.hmac(serverKey, authMessage);
            String proof = "p=" + this.encodeBase64(clientProof);
            String clientFinalMessage = clientFinalMessageWithoutProof + "," + proof;
            return this.decodeUTF8(clientFinalMessage);
        }

        private byte[] decodeBase64(String str) {
            return this.base64Codec.decode(str);
        }

        private byte[] decodeUTF8(String str) throws SaslException {
            try {
                return str.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private String encodeBase64(byte[] bytes) {
            return this.base64Codec.encode(bytes);
        }

        private String encodeUTF8(byte[] bytes) throws SaslException {
            try {
                return new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new SaslException("UTF-8 is not a supported encoding.", e);
            }
        }

        private byte[] h(byte[] data) throws SaslException {
            try {
                return MessageDigest.getInstance("SHA-1").digest(data);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("SHA-1 could not be found.", e);
            }
        }

        private byte[] hi(String password, byte[] salt, int iterations) throws SaslException {
            SecretKeyFactory keyFactory;
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterations, 160);
            try {
                keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Unable to find PBKDF2WithHmacSHA1.", e);
            }
            try {
                return keyFactory.generateSecret(spec).getEncoded();
            }
            catch (InvalidKeySpecException e) {
                throw new SaslException("Invalid key spec for PBKDC2WithHmacSHA1.", e);
            }
        }

        private byte[] hmac(byte[] bytes, String key) throws SaslException {
            Mac mac;
            SecretKeySpec signingKey = new SecretKeySpec(bytes, "HmacSHA1");
            try {
                mac = Mac.getInstance("HmacSHA1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SaslException("Could not find HmacSHA1.", e);
            }
            try {
                mac.init(signingKey);
            }
            catch (InvalidKeyException e) {
                throw new SaslException("Could not initialize mac.", e);
            }
            return mac.doFinal(this.decodeUTF8(key));
        }

        private HashMap<String, String> parseServerResponse(String response) {
            String[] pairs;
            HashMap<String, String> map = new HashMap<String, String>();
            for (String pair : pairs = response.split(",")) {
                String[] parts = pair.split("=", 2);
                map.put(parts[0], parts[1]);
            }
            return map;
        }

        private String prepUserName(String userName) {
            return userName.replace("=", "=3D").replace(",", "=2D");
        }

        private byte[] xor(byte[] a, byte[] b) {
            byte[] result = new byte[a.length];
            for (int i = 0; i < a.length; ++i) {
                result[i] = (byte)(a[i] ^ b[i]);
            }
            return result;
        }
    }
}

