/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.ResponseCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import org.bson.BsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class QueryResultCallback<T>
extends ResponseCallback {
    public static final Logger LOGGER = Loggers.getLogger("protocol.query");
    private final MongoNamespace namespace;
    private final SingleResultCallback<QueryResult<T>> callback;
    private final Decoder<T> decoder;

    public QueryResultCallback(MongoNamespace namespace, SingleResultCallback<QueryResult<T>> callback, Decoder<T> decoder, int requestId, ServerAddress serverAddress) {
        super(requestId, serverAddress);
        this.namespace = namespace;
        this.callback = callback;
        this.decoder = decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void callCallback(ResponseBuffers responseBuffers, Throwable t) {
        try {
            if (t != null) {
                this.callback.onResult(null, t);
            } else if (responseBuffers.getReplyHeader().isQueryFailure()) {
                BsonDocument errorDocument = new ReplyMessage<BsonDocument>(responseBuffers, new BsonDocumentCodec(), this.getRequestId()).getDocuments().get(0);
                this.callback.onResult(null, ProtocolHelper.getQueryFailureException(errorDocument, this.getServerAddress()));
            } else {
                QueryResult<T> result = new QueryResult<T>(this.namespace, new ReplyMessage<T>(responseBuffers, this.decoder, this.getRequestId()), this.getServerAddress());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Query results received %s documents with cursor %s", result.getResults().size(), result.getCursor()));
                }
                this.callback.onResult(result, null);
            }
        }
        catch (Throwable t1) {
            this.callback.onResult(null, t1);
        }
        finally {
            try {
                if (responseBuffers != null) {
                    responseBuffers.close();
                }
            }
            catch (Throwable t1) {
                LOGGER.debug("GetMore ResponseBuffer close exception", t1);
            }
        }
    }
}

