/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.ResponseCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import org.bson.codecs.Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetMoreResultCallback<T>
extends ResponseCallback {
    public static final Logger LOGGER = Loggers.getLogger("protocol.getmore");
    private final MongoNamespace namespace;
    private final SingleResultCallback<QueryResult<T>> callback;
    private final Decoder<T> decoder;
    private final long cursorId;

    public GetMoreResultCallback(MongoNamespace namespace, SingleResultCallback<QueryResult<T>> callback, Decoder<T> decoder, long cursorId, long requestId, ServerAddress serverAddress) {
        super(requestId, serverAddress);
        this.namespace = namespace;
        this.callback = callback;
        this.decoder = decoder;
        this.cursorId = cursorId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void callCallback(ResponseBuffers responseBuffers, Throwable t) {
        try {
            if (t != null) {
                this.callback.onResult(null, t);
            } else if (responseBuffers.getReplyHeader().isCursorNotFound()) {
                this.callback.onResult(null, new MongoCursorNotFoundException(this.cursorId, this.getServerAddress()));
            } else {
                QueryResult<T> result = new QueryResult<T>(this.namespace, new ReplyMessage<T>(responseBuffers, this.decoder, this.getRequestId()), this.getServerAddress());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("GetMore results received %s documents with cursor %s", result.getResults().size(), result.getCursor()));
                }
                this.callback.onResult(result, null);
            }
        }
        catch (Throwable t1) {
            this.callback.onResult(null, t1);
        }
        finally {
            try {
                if (responseBuffers != null) {
                    responseBuffers.close();
                }
            }
            catch (Throwable t1) {
                LOGGER.debug("GetMore ResponseBuffer close exception", t1);
            }
        }
    }
}

