/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.binding.ReferenceCounted;
import java.util.concurrent.atomic.AtomicInteger;

abstract class AbstractReferenceCounted
implements ReferenceCounted {
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    AbstractReferenceCounted() {
    }

    public int getCount() {
        return this.referenceCount.get();
    }

    public ReferenceCounted retain() {
        if (this.referenceCount.incrementAndGet() == 1) {
            throw new IllegalStateException("Attempted to increment the reference count when it is already 0");
        }
        return this;
    }

    public void release() {
        if (this.referenceCount.decrementAndGet() < 0) {
            throw new IllegalStateException("Attempted to decrement the reference count below 0");
        }
    }
}

