/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public Document runCommand(Bson var1);

    public Document runCommand(Bson var1, ReadPreference var2);

    public <TResult> TResult runCommand(Bson var1, Class<TResult> var2);

    public <TResult> TResult runCommand(Bson var1, ReadPreference var2, Class<TResult> var3);

    public void drop();

    public MongoIterable<String> listCollectionNames();

    public ListCollectionsIterable<Document> listCollections();

    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> var1);

    public void createCollection(String var1);

    public void createCollection(String var1, CreateCollectionOptions var2);
}

