/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.annotations.Immutable;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ServerDescription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class TaggableReadPreference
extends ReadPreference {
    private final List<TagSet> tagSetList = new ArrayList<TagSet>();

    TaggableReadPreference() {
    }

    TaggableReadPreference(TagSet tagSet) {
        this.tagSetList.add(tagSet);
    }

    TaggableReadPreference(List<TagSet> tagSetList) {
        Assertions.notNull("tagSetList", tagSetList);
        for (TagSet tagSet : tagSetList) {
            this.tagSetList.add(tagSet);
        }
    }

    @Override
    public boolean isSlaveOk() {
        return true;
    }

    @Override
    public BsonDocument toDocument() {
        BsonDocument readPrefObject = new BsonDocument("mode", new BsonString(this.getName()));
        if (!this.tagSetList.isEmpty()) {
            readPrefObject.put("tags", this.tagsListToBsonArray());
        }
        return readPrefObject;
    }

    public List<TagSet> getTagSetList() {
        return Collections.unmodifiableList(this.tagSetList);
    }

    public String toString() {
        return this.getName() + (this.tagSetList.isEmpty() ? "" : ": " + this.tagSetList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggableReadPreference that = (TaggableReadPreference)o;
        return this.tagSetList.equals(that.tagSetList);
    }

    public int hashCode() {
        int result = this.tagSetList.hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    private BsonArray tagsListToBsonArray() {
        BsonArray bsonArray = new BsonArray();
        for (TagSet tagSet : this.tagSetList) {
            bsonArray.add(this.toDocument(tagSet));
        }
        return bsonArray;
    }

    private BsonDocument toDocument(TagSet tagSet) {
        BsonDocument document = new BsonDocument();
        for (Tag tag : tagSet) {
            document.put(tag.getName(), new BsonString(tag.getValue()));
        }
        return document;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PrimaryPreferredReadPreference
    extends SecondaryReadPreference {
        PrimaryPreferredReadPreference() {
        }

        PrimaryPreferredReadPreference(TagSet tagSet) {
            super(tagSet);
        }

        PrimaryPreferredReadPreference(List<TagSet> tagSetList) {
            super(tagSetList);
        }

        @Override
        public String getName() {
            return "primaryPreferred";
        }

        @Override
        public List<ServerDescription> choose(ClusterDescription clusterDescription) {
            List<ServerDescription> servers = clusterDescription.getPrimaries();
            return !servers.isEmpty() ? servers : super.choose(clusterDescription);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NearestReadPreference
    extends TaggableReadPreference {
        NearestReadPreference() {
        }

        NearestReadPreference(TagSet tagSet) {
            super(tagSet);
        }

        NearestReadPreference(List<TagSet> tagSetList) {
            super(tagSetList);
        }

        @Override
        public String getName() {
            return "nearest";
        }

        @Override
        public List<ServerDescription> choose(ClusterDescription clusterDescription) {
            if (this.getTagSetList().isEmpty()) {
                return clusterDescription.getAnyPrimaryOrSecondary();
            }
            for (TagSet tagSet : this.getTagSetList()) {
                List<ServerDescription> servers = clusterDescription.getAnyPrimaryOrSecondary(tagSet);
                if (servers.isEmpty()) continue;
                return servers;
            }
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecondaryPreferredReadPreference
    extends SecondaryReadPreference {
        SecondaryPreferredReadPreference() {
        }

        SecondaryPreferredReadPreference(TagSet tagSet) {
            super(tagSet);
        }

        SecondaryPreferredReadPreference(List<TagSet> tagSetList) {
            super(tagSetList);
        }

        @Override
        public String getName() {
            return "secondaryPreferred";
        }

        @Override
        public List<ServerDescription> choose(ClusterDescription clusterDescription) {
            List<ServerDescription> servers = super.choose(clusterDescription);
            return !servers.isEmpty() ? servers : clusterDescription.getPrimaries();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SecondaryReadPreference
    extends TaggableReadPreference {
        SecondaryReadPreference() {
        }

        SecondaryReadPreference(TagSet tagSet) {
            super(tagSet);
        }

        SecondaryReadPreference(List<TagSet> tagSetList) {
            super(tagSetList);
        }

        @Override
        public String getName() {
            return "secondary";
        }

        @Override
        public List<ServerDescription> choose(ClusterDescription clusterDescription) {
            if (this.getTagSetList().isEmpty()) {
                return clusterDescription.getSecondaries();
            }
            for (TagSet tagSet : this.getTagSetList()) {
                List<ServerDescription> servers = clusterDescription.getSecondaries(tagSet);
                if (servers.isEmpty()) continue;
                return servers;
            }
            return Collections.emptyList();
        }
    }
}

