/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2pdf;

import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PDFColumn {
    private String colName;
    private String type;
    private String align;
    private int colspan;
    private int rowspan;
    private double width = 0.0;
    private int height = 1;
    private boolean is_footer = false;

    public void parse(Element parent) {
        String rowspan_string;
        this.is_footer = parent.getParentNode().getParentNode().getNodeName().equals("foot");
        Node text_node = parent.getFirstChild();
        this.colName = text_node != null ? text_node.getNodeValue() : "";
        String width_string = parent.getAttribute("width");
        if (width_string.length() > 0) {
            this.width = Integer.parseInt(width_string);
        }
        this.type = parent.getAttribute("type");
        this.align = parent.getAttribute("align");
        String colspan_string = parent.getAttribute("colspan");
        if (colspan_string.length() > 0) {
            this.colspan = Integer.parseInt(colspan_string);
        }
        if ((rowspan_string = parent.getAttribute("rowspan")).length() > 0) {
            this.rowspan = Integer.parseInt(rowspan_string);
        }
    }

    public boolean isFooter() {
        return this.is_footer;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public int getColspan() {
        return this.colspan;
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getName() {
        return this.colName;
    }

    public String getAlign() {
        return this.align;
    }

    public String getType() {
        return this.type;
    }
}

