package com.dhtmlx.xml2pdf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.pdfjet.Font;



@SuppressWarnings("serial")
public class PDFGenerator extends HttpServlet {

    /**
     * 日志对象。
     */
    private static Logger logger = LoggerFactory.getLogger(PDFGenerator.class);

    /**
     * 内嵌字体资源URI。
     */
    private String m_embedFontUri;

    public void doPost(HttpServletRequest req, HttpServletResponse resp)
    throws IOException {
        String xml;
        xml = req.getParameter("grid_xml");
        xml = URLDecoder.decode(xml, "UTF-8");
        (new PDFWriter(m_embedFontUri)).generate(xml, resp);
    }

    /**
     * 初始化。
     * 
     * @see javax.servlet.GenericServlet#init(javax.servlet.ServletConfig)
     */
    @Override
    public void init(ServletConfig config) throws ServletException
    {
        super.init(config);
        m_embedFontUri = config.getInitParameter("font");
        if (m_embedFontUri == null
            || (m_embedFontUri = m_embedFontUri.trim()).length() == 0)
        {
            // 没有配置，自动内嵌 /com/hynnet/fonts/simfang.ttf
            String uri = "/com/hynnet/fonts/simfang.ttf";
            InputStream in;

            try
            {
                in = getClass().getResourceAsStream(uri);
                if (in == null)
                {
                    m_embedFontUri = Font.STHeitiSC_Light;
                }
                else
                {
                    m_embedFontUri = uri;
                    in.close();
                }
            }
            catch (Exception e)
            {
                m_embedFontUri = Font.STHeitiSC_Light;
            }
        }
        else if ("no".equalsIgnoreCase(m_embedFontUri)
                 || "none".equalsIgnoreCase(m_embedFontUri))
        {
            // 不嵌套字体，默认字体
            m_embedFontUri = Font.STHeitiSC_Light;
        }
        else if (m_embedFontUri.charAt(0) == '/')
        {
            // 验证字体资源是否存在
            InputStream in;

            try
            {
                in = getClass().getResourceAsStream(m_embedFontUri);
                if (in == null)
                {
                    m_embedFontUri = null;
                }
                else
                {
                    in.close();
                }
            }
            catch (Exception e)
            {
                logger.error("无法加载字体资源：{} {}", m_embedFontUri, e.getMessage());
                m_embedFontUri = null;
            }
        }
        if (m_embedFontUri != null && logger.isInfoEnabled())
        {
            logger.info("pdf字体：{}",
                        m_embedFontUri.charAt(0) == '/' ? "内嵌" : "",
                        m_embedFontUri);
        }
    }
}
