/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2excel;

import com.dhtmlx.xml2excel.BaseWriter;
import com.dhtmlx.xml2excel.ExcelCell;
import com.dhtmlx.xml2excel.ExcelColumn;
import com.dhtmlx.xml2excel.ExcelRow;
import com.dhtmlx.xml2excel.ExcelXmlParser;
import com.dhtmlx.xml2excel.RGBColor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelWriter
extends BaseWriter {
    private WritableWorkbook wb;
    private WritableSheet sheet;
    private ExcelColumn[][] cols;
    private int colsNumber = 0;
    private ExcelXmlParser parser;
    public int headerOffset = 0;
    public int scale = 6;
    public String pathToImgs = "";
    public int fontSize = 10;
    String bgColor = "";
    String lineColor = "";
    String headerTextColor = "";
    String scaleOneColor = "";
    String scaleTwoColor = "";
    String gridTextColor = "";
    String watermarkTextColor = "";
    private int cols_stat;
    private int rows_stat;
    RGBColor colors;
    private String watermark = null;

    public void generate(String xml, HttpServletResponse resp) {
        this.parser = new ExcelXmlParser();
        try {
            this.parser.setXML(xml);
            this.createExcel(resp);
            this.setColorProfile();
            this.headerPrint(this.parser);
            this.rowsPrint(this.parser, resp);
            this.footerPrint(this.parser);
            this.insertHeader(this.parser, resp);
            this.insertFooter(this.parser, resp);
            this.watermarkPrint(this.parser);
            this.outputExcel(resp);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void createExcel(HttpServletResponse resp) throws IOException {
        this.wb = Workbook.createWorkbook((OutputStream)resp.getOutputStream());
        this.sheet = this.wb.createSheet("First Sheet", 0);
        this.colors = new RGBColor();
    }

    private void outputExcel(HttpServletResponse resp) throws IOException, WriteException {
        resp.setContentType("application/vnd.ms-excel");
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("Content-Disposition", "attachment;filename=grid.xls");
        resp.setHeader("Cache-Control", "max-age=0");
        this.wb.write();
        this.wb.close();
    }

    private void headerPrint(ExcelXmlParser parser) throws RowsExceededException, WriteException, IOException {
        int i;
        this.cols = parser.getColumnsInfo("head");
        int[] widths = parser.getWidths();
        this.cols_stat = widths.length;
        int sumWidth = 0;
        for (i = 0; i < widths.length; ++i) {
            sumWidth += widths[i];
        }
        if (!parser.getWithoutHeader()) {
            int j;
            for (i = 0; i < this.cols.length; ++i) {
                this.sheet.setRowView(i, 450);
                this.sheet.getSettings().setVerticalFreeze(i + 1);
                j = 0;
                while (j < this.cols[i].length) {
                    this.sheet.setColumnView(j, widths[j] / this.scale);
                    WritableFont font = new WritableFont(WritableFont.ARIAL, this.fontSize - 1, WritableFont.BOLD);
                    font.setColour(this.colors.getColor(this.headerTextColor, this.wb));
                    WritableCellFormat f = new WritableCellFormat(font);
                    f.setBackground(this.colors.getColor(this.bgColor, this.wb));
                    f.setBorder(Border.ALL, BorderLineStyle.THIN, this.colors.getColor(this.lineColor, this.wb));
                    f.setVerticalAlignment(VerticalAlignment.CENTRE);
                    f.setAlignment(Alignment.CENTRE);
                    String name = this.cols[i][j].getName();
                    Label label = new Label(j, i, name, (CellFormat)f);
                    this.sheet.addCell((WritableCell)label);
                    this.colsNumber = j++;
                }
            }
            this.headerOffset = this.cols.length;
            for (i = 0; i < this.cols.length; ++i) {
                for (j = 0; j < this.cols[i].length; ++j) {
                    int rspan;
                    int cspan = this.cols[i][j].getColspan();
                    if (cspan > 0) {
                        this.sheet.mergeCells(j, i, j + cspan - 1, i);
                    }
                    if ((rspan = this.cols[i][j].getRowspan()) <= 0) continue;
                    this.sheet.mergeCells(j, i, j, i + rspan - 1);
                }
            }
        }
    }

    private void footerPrint(ExcelXmlParser parser) throws RowsExceededException, WriteException, IOException {
        this.cols = parser.getColumnsInfo("foot");
        if (this.cols == null) {
            return;
        }
        if (!parser.getWithoutHeader()) {
            int j;
            int i;
            for (i = 0; i < this.cols.length; ++i) {
                this.sheet.setRowView(i + this.headerOffset, 450);
                for (j = 0; j < this.cols[i].length; ++j) {
                    WritableFont font = new WritableFont(WritableFont.ARIAL, this.fontSize, WritableFont.BOLD);
                    font.setColour(this.colors.getColor(this.headerTextColor, this.wb));
                    WritableCellFormat f = new WritableCellFormat(font);
                    f.setBackground(this.colors.getColor(this.bgColor, this.wb));
                    f.setBorder(Border.ALL, BorderLineStyle.THIN, this.colors.getColor(this.lineColor, this.wb));
                    f.setVerticalAlignment(VerticalAlignment.CENTRE);
                    f.setAlignment(Alignment.CENTRE);
                    String name = this.cols[i][j].getName();
                    Label label = new Label(j, i + this.headerOffset, name, (CellFormat)f);
                    this.sheet.addCell((WritableCell)label);
                }
            }
            for (i = 0; i < this.cols.length; ++i) {
                for (j = 0; j < this.cols[i].length; ++j) {
                    int rspan;
                    int cspan = this.cols[i][j].getColspan();
                    if (cspan > 0) {
                        this.sheet.mergeCells(j, this.headerOffset + i, j + cspan - 1, this.headerOffset + i);
                    }
                    if ((rspan = this.cols[i][j].getRowspan()) <= 0) continue;
                    this.sheet.mergeCells(j, this.headerOffset + i, j, this.headerOffset + i + rspan - 1);
                }
            }
        }
        this.headerOffset += this.cols.length;
    }

    private void watermarkPrint(ExcelXmlParser parser) throws WriteException {
        if (this.watermark == null) {
            return;
        }
        WritableFont font = new WritableFont(WritableFont.ARIAL, this.fontSize, WritableFont.BOLD);
        font.setColour(this.colors.getColor(this.watermarkTextColor, this.wb));
        WritableCellFormat f = new WritableCellFormat(font);
        f.setBorder(Border.ALL, BorderLineStyle.THIN, this.colors.getColor(this.lineColor, this.wb));
        f.setVerticalAlignment(VerticalAlignment.CENTRE);
        f.setAlignment(Alignment.CENTRE);
        Label label = new Label(0, this.headerOffset, this.watermark, (CellFormat)f);
        this.sheet.addCell((WritableCell)label);
        this.sheet.mergeCells(0, this.headerOffset, this.colsNumber, this.headerOffset);
    }

    private void rowsPrint(ExcelXmlParser parser, HttpServletResponse resp) throws WriteException, IOException {
        ExcelRow[] rows = parser.getGridContent();
        if (rows == null) {
            return;
        }
        this.rows_stat = rows.length;
        for (int i = 0; i < rows.length; ++i) {
            ExcelCell[] cells = rows[i].getCells();
            this.sheet.setRowView(i + this.headerOffset, 400);
            for (int j = 0; j < cells.length; ++j) {
                WritableFont font = new WritableFont(WritableFont.ARIAL, this.fontSize, cells[j].getBold() != false ? WritableFont.BOLD : WritableFont.NO_BOLD, cells[j].getItalic() != false);
                if (!cells[j].getTextColor().equals("") && parser.getProfile().equals("full_color")) {
                    font.setColour(this.colors.getColor(cells[j].getTextColor(), this.wb));
                } else {
                    font.setColour(this.colors.getColor(this.gridTextColor, this.wb));
                }
                WritableCellFormat f = new WritableCellFormat(font);
                if (!cells[j].getBgColor().equals("") && parser.getProfile().equals("full_color")) {
                    Colour col = this.colors.getColor(cells[j].getBgColor(), this.wb);
                    f.setBackground(col);
                } else {
                    Colour bg = i % 2 == 1 ? this.colors.getColor(this.scaleTwoColor, this.wb) : this.colors.getColor(this.scaleOneColor, this.wb);
                    f.setBackground(bg);
                }
                f.setBorder(Border.ALL, BorderLineStyle.THIN, this.colors.getColor(this.lineColor, this.wb));
                f.setVerticalAlignment(VerticalAlignment.CENTRE);
                String al = cells[j].getAlign();
                if (al == "") {
                    al = this.cols[0][j].getAlign();
                }
                if (al.equalsIgnoreCase("left")) {
                    f.setAlignment(Alignment.LEFT);
                } else if (al.equalsIgnoreCase("right")) {
                    f.setAlignment(Alignment.RIGHT);
                } else {
                    f.setAlignment(Alignment.CENTRE);
                }
                try {
                    String str = cells[j].getValue();
                    double name = Double.parseDouble(str);
                    if (str.indexOf(46) < 0 && str.length() > 11) {
                        this.sheet.addCell((WritableCell)new Label(j, i + this.headerOffset, str, (CellFormat)f));
                        continue;
                    }
                    Number label = new Number(j, i + this.headerOffset, name, (CellFormat)f);
                    this.sheet.addCell((WritableCell)label);
                    continue;
                }
                catch (Exception e) {
                    String name = cells[j].getValue();
                    Label label = new Label(j, i + this.headerOffset, name, (CellFormat)f);
                    this.sheet.addCell((WritableCell)label);
                }
            }
        }
        this.headerOffset += rows.length;
    }

    private void insertHeader(ExcelXmlParser parser, HttpServletResponse resp) throws IOException, RowsExceededException {
        if (parser.getHeader()) {
            this.sheet.insertRow(0);
            this.sheet.setRowView(0, 5000);
            File imgFile = new File(this.pathToImgs + "/header.png");
            WritableImage img = new WritableImage(0.0, 0.0, (double)this.cols[0].length, 1.0, imgFile);
            this.sheet.addImage(img);
            ++this.headerOffset;
        }
    }

    private void insertFooter(ExcelXmlParser parser, HttpServletResponse resp) throws IOException, RowsExceededException {
        if (parser.getFooter().booleanValue()) {
            this.sheet.setRowView(this.headerOffset, 5000);
            File imgFile = new File(this.pathToImgs + "/footer.png");
            WritableImage img = new WritableImage(0.0, (double)this.headerOffset, (double)this.cols[0].length, 1.0, imgFile);
            this.sheet.addImage(img);
        }
    }

    public int getColsStat() {
        return this.cols_stat;
    }

    public int getRowsStat() {
        return this.rows_stat;
    }

    private void setColorProfile() {
        String profile = this.parser.getProfile();
        if (profile.equalsIgnoreCase("color") || profile.equalsIgnoreCase("full_color")) {
            this.bgColor = "D1E5FE";
            this.lineColor = "A4BED4";
            this.headerTextColor = "000000";
            this.scaleOneColor = "FFFFFF";
            this.scaleTwoColor = "E3EFFF";
            this.gridTextColor = "000000";
            this.watermarkTextColor = "8b8b8b";
        } else if (profile.equalsIgnoreCase("gray")) {
            this.bgColor = "E3E3E3";
            this.lineColor = "B8B8B8";
            this.headerTextColor = "000000";
            this.scaleOneColor = "FFFFFF";
            this.scaleTwoColor = "EDEDED";
            this.gridTextColor = "000000";
            this.watermarkTextColor = "8b8b8b";
        } else {
            this.bgColor = "FFFFFF";
            this.lineColor = "000000";
            this.headerTextColor = "000000";
            this.scaleOneColor = "FFFFFF";
            this.scaleTwoColor = "FFFFFF";
            this.gridTextColor = "000000";
            this.watermarkTextColor = "000000";
        }
    }

    public void setWatermark(String mark) {
        this.watermark = mark;
    }

    public void setFontSize(int fontsize) {
        this.fontSize = fontsize;
    }
}

