/*
 * Decompiled with CFR 0.152.
 */
package com.dhtmlx.xml2excel;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CSVxml {
    private Document dom;
    private String profile;
    private NodeList header;
    private NodeList rows;
    private NodeList footer;
    private int headerPos;
    private int footerPos;
    private int rowsPos;

    private void parseXmlString(String xml_string) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            StringReader reader = new StringReader(xml_string);
            InputSource inputSource = new InputSource(reader);
            inputSource.setEncoding("UTF-8");
            this.dom = db.parse(inputSource);
            reader.close();
            this.profile = this.dom.getDocumentElement().getAttribute("profile");
            if (this.profile == null) {
                this.profile = "color";
            }
            this.header = this.dom.getElementsByTagName("head");
            if (this.header.getLength() > 0) {
                this.header = this.header.item(0).getChildNodes();
                this.header = this.removeSettings(this.header);
            }
            this.headerPos = 0;
            this.footer = this.dom.getElementsByTagName("foot");
            if (this.footer.getLength() > 0) {
                this.footer = this.footer.item(0).getChildNodes();
                this.footer = this.removeSettings(this.footer);
            }
            this.footerPos = 0;
            this.rows = this.dom.getElementsByTagName("row");
            this.rowsPos = 0;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public CSVxml(String xml) {
        this.parseXmlString(xml);
    }

    private String[] getDataArray(Node node) {
        NodeList columns = node.getChildNodes();
        String[] data = new String[columns.getLength()];
        for (int i = columns.getLength() - 1; i >= 0; --i) {
            data[i] = columns.item(i).getTextContent();
        }
        return data;
    }

    public String[] getHeader() {
        if (this.header == null || this.header.getLength() <= this.headerPos) {
            return null;
        }
        Node node = this.header.item(this.headerPos);
        ++this.headerPos;
        return this.getDataArray(node);
    }

    public String[] getFooter() {
        if (this.footer == null || this.footer.getLength() <= this.footerPos) {
            return null;
        }
        Node node = this.footer.item(this.footerPos);
        ++this.footerPos;
        return this.getDataArray(node);
    }

    public String[] getRow() {
        if (this.rows == null || this.rows.getLength() <= this.rowsPos) {
            return null;
        }
        Node node = this.rows.item(this.rowsPos);
        ++this.rowsPos;
        return this.getDataArray(node);
    }

    private NodeList removeSettings(NodeList header) {
        for (int i = 0; i < header.getLength(); ++i) {
            NodeList childs = header.item(i).getChildNodes();
            for (int j = 0; j < childs.getLength(); ++j) {
                if (childs.item(j).getNodeType() != 3 && !childs.item(j).getNodeName().equals("settings")) continue;
                header.item(i).removeChild(childs.item(j));
            }
        }
        return header;
    }

    public String getProfile() {
        return this.profile;
    }
}

