
import java.io.IOException;
import java.net.URLDecoder;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.dhtmlx.xml2excel.ExcelWriter;
import com.hynnet.util.GeneralHttpServletRequest;

@SuppressWarnings("serial")
public class ExcelGenerator extends HttpServlet
{
    /**
     * 日志对象。
     */
    private static final Logger logger = LoggerFactory.getLogger(ExcelGenerator.class.getName());

    public void doPost(HttpServletRequest req, HttpServletResponse resp)
            throws IOException
    {
        GeneralHttpServletRequest request = new GeneralHttpServletRequest(null,
                                                                          req,
                                                                          req.getServletContext());
        String xml = request.getParameter("grid_xml");

        if (xml != null)
        {
            xml = URLDecoder.decode(xml, "UTF-8");
            (new ExcelWriter()).generate(xml, resp);
        }
        else if (logger.isTraceEnabled())
        {
            logger.trace("DHTMLX Grid导出Excel请求参数中没有grid_xml：",
                         request.getPostData());
        }
    }

}
