/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.components.JVLCPlayer;
import chrriis.dj.nativeswing.swtimpl.components.VLCAudio;
import chrriis.dj.nativeswing.swtimpl.components.VLCInput;
import chrriis.dj.nativeswing.swtimpl.components.VLCPlayerDecorator;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultVLCPlayerDecorator
extends VLCPlayerDecorator {
    private final ResourceBundle RESOURCES;
    private int lastVolume;
    private JVLCPlayer vlcPlayer;
    private VLCPlayerControlBar controlBar;
    private JPanel nativeComponentBorderContainerPane;

    public DefaultVLCPlayerDecorator(JVLCPlayer vlcPlayer, Component renderingComponent) {
        String className = JVLCPlayer.class.getName();
        this.RESOURCES = ResourceBundle.getBundle(String.valueOf(className.substring(0, className.lastIndexOf(46)).replace('.', '/')) + "/resource/VLCPlayer");
        this.lastVolume = 50;
        this.vlcPlayer = vlcPlayer;
        this.nativeComponentBorderContainerPane = new JPanel(new BorderLayout());
        this.nativeComponentBorderContainerPane.add(renderingComponent, "Center");
        this.add((Component)this.nativeComponentBorderContainerPane, "Center");
        this.setControlBarVisible(false);
    }

    protected JVLCPlayer getFlashPlayer() {
        return this.vlcPlayer;
    }

    private void adjustBorder() {
        this.nativeComponentBorderContainerPane.setBorder(this.getInnerAreaBorder());
    }

    protected Border getInnerAreaBorder() {
        Border border = this.isControlBarVisible() ? BorderFactory.createBevelBorder(1) : null;
        return border;
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        if (isControlBarVisible == this.isControlBarVisible()) {
            return;
        }
        if (isControlBarVisible) {
            this.controlBar = new VLCPlayerControlBar();
            this.add((Component)this.controlBar, "South");
        } else {
            this.remove(this.controlBar);
            this.controlBar.disconnect();
            this.controlBar = null;
        }
        this.revalidate();
        this.repaint();
        this.adjustBorder();
    }

    public boolean isControlBarVisible() {
        return this.controlBar != null;
    }

    protected String getTimeDisplay(int currentTime, int totalTime) {
        boolean showHours = totalTime >= 3600000;
        return String.valueOf(this.formatTime(currentTime, showHours)) + " / " + this.formatTime(totalTime, showHours);
    }

    private String formatTime(int milliseconds, boolean showHours) {
        int seconds = milliseconds / 1000;
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        seconds %= 60;
        StringBuilder sb = new StringBuilder();
        if (hours != 0 || showHours) {
            sb.append(hours).append(':');
        }
        sb.append(minutes < 10 ? "0" : "").append(minutes).append(':');
        sb.append(seconds < 10 ? "0" : "").append(seconds);
        return sb.toString();
    }

    protected void addControlBarComponents(VLCPlayerControlBar controlBar, JComponent buttonContainer) {
        buttonContainer.add(controlBar.getPlayButton());
        buttonContainer.add(controlBar.getPauseButton());
        buttonContainer.add(controlBar.getStopButton());
    }

    protected void configureComponent(JComponent c, VLCDecoratorComponentType componentType) {
        switch (componentType) {
            case PLAY_BUTTON: {
                ((AbstractButton)c).setIcon(this.createIcon("PlayIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("PlayText"));
                return;
            }
            case PAUSE_BUTTON: {
                ((AbstractButton)c).setIcon(this.createIcon("PauseIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("PauseText"));
                return;
            }
            case STOP_BUTTON: {
                ((AbstractButton)c).setIcon(this.createIcon("StopIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("StopText"));
                return;
            }
            case VOLUME_BUTTON_OFF: {
                ((AbstractButton)c).setIcon(this.createIcon("VolumeOffIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("VolumeOffText"));
                return;
            }
            case VOLUME_BUTTON_ON: {
                ((AbstractButton)c).setIcon(this.createIcon("VolumeOnIcon"));
                ((AbstractButton)c).setToolTipText(this.RESOURCES.getString("VolumeOnText"));
                return;
            }
        }
        throw new IllegalStateException("Type not handled: " + (Object)((Object)componentType));
    }

    private Icon createIcon(String resourceKey) {
        String value = this.RESOURCES.getString(resourceKey);
        return value.length() == 0 ? null : new ImageIcon(JVLCPlayer.class.getResource(value));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VLCDecoratorComponentType {
        PLAY_BUTTON,
        PAUSE_BUTTON,
        STOP_BUTTON,
        VOLUME_BUTTON_ON,
        VOLUME_BUTTON_OFF;

    }

    public class VLCPlayerControlBar
    extends JPanel {
        private JButton playButton;
        private JButton pauseButton;
        private JButton stopButton;
        private JSlider seekBarSlider;
        private volatile boolean isAdjustingSeekBar;
        private volatile Thread updateThread;
        private JLabel timeLabel;
        private JButton volumeButton;
        private JSlider volumeSlider;
        private boolean isAdjustingVolume;
        private WebBrowserAdapter webBrowserListener;
        private boolean isMute;
        private int volume;

        VLCPlayerControlBar() {
            super(new BorderLayout());
            this.volume = -2;
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 4, 2));
            this.playButton = new JButton();
            DefaultVLCPlayerDecorator.this.configureComponent(this.playButton, VLCDecoratorComponentType.PLAY_BUTTON);
            this.playButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCPlaylist().play();
                }
            });
            this.pauseButton = new JButton();
            DefaultVLCPlayerDecorator.this.configureComponent(this.pauseButton, VLCDecoratorComponentType.PAUSE_BUTTON);
            this.pauseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCPlaylist().togglePause();
                }
            });
            this.stopButton = new JButton();
            DefaultVLCPlayerDecorator.this.configureComponent(this.stopButton, VLCDecoratorComponentType.STOP_BUTTON);
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCPlaylist().stop();
                }
            });
            DefaultVLCPlayerDecorator.this.addControlBarComponents(this, buttonPanel);
            this.seekBarSlider = new JSlider(0, 10000, 0);
            this.seekBarSlider.setVisible(false);
            this.seekBarSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!VLCPlayerControlBar.this.isAdjustingSeekBar) {
                        DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCInput().setRelativePosition((float)VLCPlayerControlBar.this.seekBarSlider.getValue() / 10000.0f);
                    }
                }
            });
            this.add((Component)this.seekBarSlider, "North");
            JPanel volumePanel = new JPanel(new FlowLayout(2, 0, 2));
            this.volumeButton = new JButton();
            Insets margin = this.volumeButton.getMargin();
            margin.left = Math.min(2, margin.left);
            margin.right = Math.min(2, margin.left);
            this.volumeButton.setMargin(margin);
            this.volumeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCAudio().toggleMute();
                }
            });
            volumePanel.add(this.volumeButton);
            this.volumeSlider = new JSlider();
            this.volumeSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!VLCPlayerControlBar.this.isAdjustingVolume) {
                        DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCAudio().setVolume(VLCPlayerControlBar.this.volumeSlider.getValue());
                    }
                }
            });
            this.volumeSlider.setPreferredSize(new Dimension(60, this.volumeSlider.getPreferredSize().height));
            volumePanel.add(this.volumeSlider);
            this.volumeButton.setEnabled(false);
            this.volumeSlider.setEnabled(false);
            GridBagLayout gridBag = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            JPanel buttonBarPanel = new JPanel(gridBag);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 1.0;
            cons.anchor = 17;
            cons.fill = 2;
            this.timeLabel = new JLabel(" ");
            this.timeLabel.setPreferredSize(new Dimension(0, this.timeLabel.getPreferredSize().height));
            gridBag.setConstraints(this.timeLabel, cons);
            buttonBarPanel.add(this.timeLabel);
            ++cons.gridx;
            cons.weightx = 0.0;
            cons.anchor = 10;
            cons.fill = 0;
            gridBag.setConstraints(buttonPanel, cons);
            buttonBarPanel.add(buttonPanel);
            buttonBarPanel.setMinimumSize(buttonBarPanel.getPreferredSize());
            ++cons.gridx;
            cons.weightx = 1.0;
            cons.anchor = 13;
            cons.fill = 2;
            volumePanel.setPreferredSize(new Dimension(0, volumePanel.getPreferredSize().height));
            gridBag.setConstraints(volumePanel, cons);
            buttonBarPanel.add(volumePanel);
            this.add((Component)buttonBarPanel, "Center");
            this.adjustButtonState();
            this.updateControlBar();
            this.webBrowserListener = new WebBrowserAdapter(){

                public void locationChanged(WebBrowserNavigationEvent e) {
                    VLCPlayerControlBar.this.adjustButtonState();
                }
            };
            DefaultVLCPlayerDecorator.this.vlcPlayer.getWebBrowser().addWebBrowserListener(this.webBrowserListener);
        }

        void disconnect() {
            this.stopUpdateThread();
            DefaultVLCPlayerDecorator.this.vlcPlayer.getWebBrowser().removeWebBrowserListener(this.webBrowserListener);
        }

        void adjustButtonState() {
            String resourceLocation = DefaultVLCPlayerDecorator.this.vlcPlayer.getWebBrowser().getResourceLocation();
            boolean isEnabled = resourceLocation != null && resourceLocation.startsWith(WebServer.getDefaultWebServer().getURLPrefix());
            this.playButton.setEnabled(isEnabled);
            this.pauseButton.setEnabled(isEnabled);
            this.stopButton.setEnabled(isEnabled);
            this.volumeButton.setEnabled(isEnabled);
            this.volumeSlider.setEnabled(isEnabled);
            if (isEnabled) {
                this.adjustVolumePanel();
                this.startUpdateThread();
            }
        }

        void adjustVolumePanel() {
            VLCAudio vlcAudio = DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCAudio();
            boolean isMute = vlcAudio.isMute();
            int volume = vlcAudio.getVolume();
            this.volumeButton.setEnabled(true);
            this.volumeSlider.setEnabled(!isMute);
            if (isMute == this.isMute && this.volume == volume) {
                return;
            }
            if (isMute) {
                DefaultVLCPlayerDecorator.this.configureComponent(this.volumeButton, VLCDecoratorComponentType.VOLUME_BUTTON_OFF);
            } else {
                DefaultVLCPlayerDecorator.this.configureComponent(this.volumeButton, VLCDecoratorComponentType.VOLUME_BUTTON_ON);
            }
            this.isAdjustingVolume = true;
            if (!isMute) {
                this.volumeSlider.setValue(volume);
                DefaultVLCPlayerDecorator.this.lastVolume = volume;
            } else {
                this.volumeSlider.setValue(DefaultVLCPlayerDecorator.this.lastVolume);
            }
            this.isAdjustingVolume = false;
            this.isMute = isMute;
            this.volume = volume;
        }

        public JButton getPlayButton() {
            return this.playButton;
        }

        public JButton getPauseButton() {
            return this.pauseButton;
        }

        public JButton getStopButton() {
            return this.stopButton;
        }

        public void removeNotify() {
            this.stopUpdateThread();
            super.removeNotify();
        }

        public void addNotify() {
            super.addNotify();
            this.adjustButtonState();
        }

        private void stopUpdateThread() {
            this.updateThread = null;
        }

        private void startUpdateThread() {
            if (this.updateThread != null) {
                return;
            }
            if (DefaultVLCPlayerDecorator.this.vlcPlayer.isNativePeerDisposed()) {
                return;
            }
            this.updateThread = new Thread("NativeSwing - VLC Player control bar update"){

                public void run() {
                    final 8 currentThread = this;
                    while (currentThread == VLCPlayerControlBar.this.updateThread) {
                        if (DefaultVLCPlayerDecorator.this.vlcPlayer.isNativePeerDisposed()) {
                            VLCPlayerControlBar.this.stopUpdateThread();
                            return;
                        }
                        try {
                            8.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (currentThread != VLCPlayerControlBar.this.updateThread) {
                                    return;
                                }
                                if (!DefaultVLCPlayerDecorator.this.vlcPlayer.isNativePeerValid()) {
                                    return;
                                }
                                VLCPlayerControlBar.this.updateControlBar();
                            }
                        });
                    }
                }
            };
            this.updateThread.setDaemon(true);
            this.updateThread.start();
        }

        private void updateControlBar() {
            boolean isValid;
            VLCInput vlcInput = DefaultVLCPlayerDecorator.this.vlcPlayer.getVLCInput();
            VLCInput.VLCMediaState state = vlcInput.getMediaState();
            boolean bl = isValid = state == VLCInput.VLCMediaState.OPENING || state == VLCInput.VLCMediaState.BUFFERING || state == VLCInput.VLCMediaState.PLAYING || state == VLCInput.VLCMediaState.PAUSED || state == VLCInput.VLCMediaState.STOPPING;
            if (isValid) {
                int time = vlcInput.getAbsolutePosition();
                int length = vlcInput.getDuration();
                boolean bl2 = isValid = time >= 0 && length > 0;
                if (isValid) {
                    this.isAdjustingSeekBar = true;
                    this.seekBarSlider.setValue(Math.round((float)time * 10000.0f / (float)length));
                    this.isAdjustingSeekBar = false;
                    this.timeLabel.setText(DefaultVLCPlayerDecorator.this.getTimeDisplay(time, length));
                }
            }
            if (!isValid) {
                this.timeLabel.setText("");
            }
            this.seekBarSlider.setVisible(isValid);
            this.adjustVolumePanel();
        }
    }
}

