/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hubspot.horizon.Headers;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.internal.AbstractHttpResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;

public class CachingHttpResponse
extends AbstractHttpResponse {
    private final AbstractHttpResponse delegate;
    private final byte[] responseBytes;

    public static CachingHttpResponse from(AbstractHttpResponse response) {
        return new CachingHttpResponse(response);
    }

    private CachingHttpResponse(AbstractHttpResponse delegate) {
        this.delegate = delegate;
        this.responseBytes = delegate.getAsBytes();
    }

    public ObjectMapper getObjectMapper() {
        return this.delegate.getObjectMapper();
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isError() {
        return this.delegate.isError();
    }

    public boolean isClientError() {
        return this.delegate.isClientError();
    }

    public boolean isServerError() {
        return this.delegate.isServerError();
    }

    public byte[] getAsBytes() {
        return Arrays.copyOf(this.responseBytes, this.responseBytes.length);
    }

    public HttpRequest getRequest() {
        return this.delegate.getRequest();
    }

    public int getStatusCode() {
        return this.delegate.getStatusCode();
    }

    public Headers getHeaders() {
        return this.delegate.getHeaders();
    }

    public InputStream getAsInputStream() {
        return new ByteArrayInputStream(this.responseBytes);
    }
}

