/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier;

import com.hubspot.maven.plugins.prettier.PrettierArgs;
import com.hubspot.maven.plugins.prettier.internal.NodeInstall;
import com.hubspot.maven.plugins.prettier.internal.PrettierPaths;
import java.nio.file.Path;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="print-args", requiresProject=false)
public class PrintArgsMojo
extends PrettierArgs {
    public final void execute() throws MojoExecutionException, MojoFailureException {
        NodeInstall nodeInstall = this.resolveNodeInstall();
        Path prettierJavaDirectory = this.downloadPrettierJava(nodeInstall);
        Path prettierBin = prettierJavaDirectory.resolve(PrettierPaths.prettierBinPath(this.prettierJavaVersion));
        Path prettierJavaPlugin = prettierJavaDirectory.resolve(PrettierPaths.prettierJavaPluginPath(this.prettierJavaVersion));
        System.out.println("nodeExecutable=" + nodeInstall.getNodePath());
        System.out.println("npmCommand=" + String.join((CharSequence)" ", nodeInstall.getNpmCommand()));
        System.out.println("prettierBin=" + prettierBin);
        System.out.println("prettierJavaPlugin=" + prettierJavaPlugin);
        if (this.printWidth != null) {
            System.out.println("printWidth=" + this.printWidth);
        }
        if (this.tabWidth != null) {
            System.out.println("tabWidth=" + this.tabWidth);
        }
        if (this.useTabs != null) {
            System.out.println("useTabs=" + this.useTabs);
        }
        if (this.endOfLine != null) {
            System.out.println("endOfLine=" + this.endOfLine);
        }
        if (this.ignoreConfigFile) {
            System.out.println("noConfig=true");
        }
        if (this.ignoreEditorConfig) {
            System.out.println("noEditorconfig=true");
        }
        this.computeInputGlobs().forEach(inputGlob -> System.out.println("inputGlob=" + inputGlob));
    }
}

