/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.maven.plugins.prettier.diff;

import com.hubspot.maven.plugins.prettier.diff.DiffGenerator;
import com.hubspot.maven.plugins.prettier.diff.GenerateDiffArgs;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;

public class DefaultDiffGenerator
implements DiffGenerator {
    @Override
    public void generateDiffs(GenerateDiffArgs args) throws MojoExecutionException {
        Path baseDir = args.getProject().getBasedir().toPath().toAbsolutePath();
        Path diffFile = Paths.get(args.getProject().getBuild().getDirectory(), new String[0]).resolve("prettier-java.diff").toAbsolutePath();
        try {
            Path diffDirectory = diffFile.getParent();
            if (diffDirectory != null) {
                Files.createDirectories(diffDirectory, new FileAttribute[0]);
            }
            Files.deleteIfExists(diffFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error deleting file " + diffFile, (Exception)e);
        }
        for (Path fileToFormat : args.getIncorrectlyFormattedFiles()) {
            fileToFormat = fileToFormat.toAbsolutePath();
            ArrayList<String> prettierArgs = new ArrayList<String>(args.getBasePrettierCommand());
            prettierArgs.add(DefaultDiffGenerator.quote(fileToFormat));
            String prettierCommand = String.join((CharSequence)" ", prettierArgs);
            String diffCommand = String.format("%s | diff -u %s - >> %s", prettierCommand, DefaultDiffGenerator.quote(baseDir.relativize(fileToFormat)), DefaultDiffGenerator.quote(diffFile));
            ProcessBuilder processBuilder = new ProcessBuilder("sh", "-c", diffCommand).directory(baseDir.toFile());
            this.runDiffCommand(processBuilder, args.getLog());
        }
        args.getLog().info((CharSequence)("Diff file generated at " + baseDir.relativize(diffFile)));
    }

    private static String quote(Path path) {
        return "'" + path + "'";
    }
}

