"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArraysPrettierVisitor = void 0;
var printer_utils_1 = require("./printer-utils");
var doc_1 = require("prettier/doc");
var base_cst_printer_1 = require("../base-cst-printer");
var line = doc_1.builders.line;
var ArraysPrettierVisitor = /** @class */ (function (_super) {
    __extends(ArraysPrettierVisitor, _super);
    function ArraysPrettierVisitor() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ArraysPrettierVisitor.prototype.arrayInitializer = function (ctx) {
        var optionalVariableInitializerList = this.visit(ctx.variableInitializerList);
        return printer_utils_1.printArrayList({
            list: optionalVariableInitializerList,
            extraComma: ctx.Comma,
            LCurly: ctx.LCurly[0],
            RCurly: ctx.RCurly[0],
            trailingComma: this.prettierOptions.trailingComma
        });
    };
    ArraysPrettierVisitor.prototype.variableInitializerList = function (ctx) {
        var variableInitializers = this.mapVisit(ctx.variableInitializer);
        var commas = ctx.Comma
            ? ctx.Comma.map(function (comma) {
                return printer_utils_1.rejectAndConcat([comma, line]);
            })
            : [];
        return printer_utils_1.rejectAndJoinSeps(commas, variableInitializers);
    };
    return ArraysPrettierVisitor;
}(base_cst_printer_1.BaseCstPrettierPrinter));
exports.ArraysPrettierVisitor = ArraysPrettierVisitor;
