"use strict";
var parse = require("./parser");
var print = require("./printer");
var options = require("./options");
var languages = [
    {
        name: "Java",
        parsers: ["java"],
        group: "Java",
        tmScope: "text.html.vue",
        aceMode: "html",
        codemirrorMode: "clike",
        codemirrorMimeType: "text/x-java",
        extensions: [".java"],
        linguistLanguageId: 181,
        vscodeLanguageIds: ["java"]
    }
];
function locStart( /* node */) {
    return -1;
}
function locEnd( /* node */) {
    return -1;
}
function hasPragma( /* text */) {
    return false;
}
var parsers = {
    java: {
        parse: parse,
        astFormat: "java",
        locStart: locStart,
        locEnd: locEnd,
        hasPragma: hasPragma
    }
};
function canAttachComment(node) {
    return node.ast_type && node.ast_type !== "comment";
}
function printComment(commentPath) {
    var comment = commentPath.getValue();
    switch (comment.ast_type) {
        case "comment":
            return comment.value;
        default:
            throw new Error("Not a comment: " + JSON.stringify(comment));
    }
}
function clean(ast, newObj) {
    delete newObj.lineno;
    delete newObj.col_offset;
}
var printers = {
    java: {
        print: print,
        // hasPrettierIgnore,
        printComment: printComment,
        canAttachComment: canAttachComment,
        massageAstNode: clean
    }
};
module.exports = {
    languages: languages,
    printers: printers,
    parsers: parsers,
    options: options
};
