/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GranteeInterface;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.Owner;
import com.obs.services.model.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AccessControlList
extends HeaderResponse {
    public static final AccessControlList REST_CANNED_PRIVATE = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ_WRITE = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ_DELIVERED = new AccessControlList();
    public static final AccessControlList REST_CANNED_PUBLIC_READ_WRITE_DELIVERED = new AccessControlList();
    @Deprecated
    public static final AccessControlList REST_CANNED_AUTHENTICATED_READ = new AccessControlList();
    @Deprecated
    public static final AccessControlList REST_CANNED_BUCKET_OWNER_READ = new AccessControlList();
    @Deprecated
    public static final AccessControlList REST_CANNED_BUCKET_OWNER_FULL_CONTROL = new AccessControlList();
    @Deprecated
    public static final AccessControlList REST_CANNED_LOG_DELIVERY_WRITE = new AccessControlList();
    private Set<GrantAndPermission> grants;
    private Owner owner;
    private boolean delivered;

    public boolean isDelivered() {
        return this.delivered;
    }

    public void setDelivered(boolean delivered) {
        this.delivered = delivered;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public Set<GrantAndPermission> getGrants() {
        if (this.grants == null) {
            this.grants = new HashSet<GrantAndPermission>();
        }
        return this.grants;
    }

    public List<Permission> getPermissionsForGrantee(GranteeInterface grantee) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        for (GrantAndPermission gap : this.getGrants()) {
            if (!gap.getGrantee().equals(grantee)) continue;
            permissions.add(gap.getPermission());
        }
        return permissions;
    }

    public GrantAndPermission grantPermission(GranteeInterface grantee, Permission permission) {
        return this.grantPermission(grantee, permission, false);
    }

    public GrantAndPermission grantPermission(GranteeInterface grantee, Permission permission, boolean delivered) {
        GrantAndPermission obj = new GrantAndPermission(grantee, permission);
        obj.setDelivered(delivered);
        this.getGrants().add(obj);
        return obj;
    }

    public void grantAllPermissions(GrantAndPermission[] grantAndPermissions) {
        for (int i = 0; i < grantAndPermissions.length; ++i) {
            GrantAndPermission gap = grantAndPermissions[i];
            this.grantPermission(gap.getGrantee(), gap.getPermission(), gap.isDelivered());
        }
    }

    public GrantAndPermission[] getGrantAndPermissions() {
        return this.getGrants().toArray(new GrantAndPermission[this.getGrants().size()]);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (GrantAndPermission item : this.getGrantAndPermissions()) {
            sb.append(item.toString()).append(",");
        }
        sb.append("]");
        return "AccessControlList [owner=" + this.owner + ", grants=" + sb.toString() + "]";
    }
}

