/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.security;

import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.internal.utils.ServiceUtils;
import java.util.Calendar;
import java.util.Date;

public class LimitedTimeSecurityKey
extends BasicSecurityKey {
    protected Date expiryDate;
    private static final long EXPIRY_SECONDS = 300L;
    private static final long WILL_SOON_EXPIRE_SECONDS = 120L;

    public LimitedTimeSecurityKey(String accessKey, String secretKey, String securityToken) {
        super(accessKey, secretKey, securityToken);
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.securityToken = securityToken;
        this.expiryDate = LimitedTimeSecurityKey.getUtcTime();
    }

    public LimitedTimeSecurityKey(String accessKey, String secretKey, String securityToken, Date expiryDate) {
        super(accessKey, secretKey, securityToken);
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.securityToken = securityToken;
        this.expiryDate = ServiceUtils.cloneDateIgnoreNull(expiryDate);
    }

    public boolean aboutToExpire() {
        return this.expiryDate.getTime() - LimitedTimeSecurityKey.getUtcTime().getTime() >= 120000L && this.expiryDate.getTime() - LimitedTimeSecurityKey.getUtcTime().getTime() < 300000L;
    }

    public boolean willSoonExpire() {
        return this.expiryDate.before(LimitedTimeSecurityKey.getUtcTime()) || this.expiryDate.getTime() - LimitedTimeSecurityKey.getUtcTime().getTime() < 120000L;
    }

    private static Date getUtcTime() {
        Calendar calendar = Calendar.getInstance();
        int offset = calendar.get(15);
        calendar.add(14, -offset);
        return calendar.getTime();
    }

    @Override
    public String getAccessKey() {
        return this.accessKey;
    }

    @Override
    public String getSecretKey() {
        return this.secretKey;
    }

    @Override
    public String getSecurityToken() {
        return this.securityToken;
    }

    public Date getExpiryDate() {
        return ServiceUtils.cloneDateIgnoreNull(this.expiryDate);
    }
}

