/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.Constants;
import com.obs.services.internal.RepeatableRequestEntity;
import com.obs.services.internal.RequestConvertor;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.SimpleProgressManager;
import com.obs.services.internal.handler.XmlResponsesSaxParser;
import com.obs.services.internal.io.HttpMethodReleaseInputStream;
import com.obs.services.internal.io.ProgressInputStream;
import com.obs.services.internal.security.BasicSecurityKey;
import com.obs.services.internal.task.BlockRejectedExecutionHandler;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.internal.utils.AbstractAuthentication;
import com.obs.services.internal.utils.JSONChange;
import com.obs.services.internal.utils.RestUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.internal.utils.V2Authentication;
import com.obs.services.internal.utils.V4Authentication;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.AbstractBulkRequest;
import com.obs.services.model.AbstractTemporarySignatureRequest;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BaseBucketRequest;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketDirectColdAccess;
import com.obs.services.model.BucketEncryption;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.DeleteObjectRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.GetObjectAclRequest;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.GrantAndPermission;
import com.obs.services.model.GroupGrantee;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.ModifyObjectRequest;
import com.obs.services.model.ModifyObjectResult;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.Permission;
import com.obs.services.model.PolicyTempSignatureRequest;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.ProgressListener;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.ReadAheadQueryResult;
import com.obs.services.model.ReadAheadRequest;
import com.obs.services.model.ReadAheadResult;
import com.obs.services.model.RenameObjectRequest;
import com.obs.services.model.RenameObjectResult;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RequestPaymentConfiguration;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.SetBucketAclRequest;
import com.obs.services.model.SetBucketCorsRequest;
import com.obs.services.model.SetBucketDirectColdAccessRequest;
import com.obs.services.model.SetBucketEncryptionRequest;
import com.obs.services.model.SetBucketLifecycleRequest;
import com.obs.services.model.SetBucketLoggingRequest;
import com.obs.services.model.SetBucketNotificationRequest;
import com.obs.services.model.SetBucketPolicyRequest;
import com.obs.services.model.SetBucketQuotaRequest;
import com.obs.services.model.SetBucketReplicationRequest;
import com.obs.services.model.SetBucketRequestPaymentRequest;
import com.obs.services.model.SetBucketStoragePolicyRequest;
import com.obs.services.model.SetBucketTaggingRequest;
import com.obs.services.model.SetBucketVersioningRequest;
import com.obs.services.model.SetBucketWebsiteRequest;
import com.obs.services.model.SetObjectAclRequest;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TaskCallback;
import com.obs.services.model.TaskProgressListener;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.TruncateObjectRequest;
import com.obs.services.model.TruncateObjectResult;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import com.obs.services.model.V4PostSignatureResponse;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.fs.DropFileResult;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.ListContentSummaryRequest;
import com.obs.services.model.fs.ListContentSummaryResult;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import com.oef.services.model.CreateAsynchFetchJobsResult;
import com.oef.services.model.DisPolicy;
import com.oef.services.model.GetDisPolicyResult;
import com.oef.services.model.QueryAsynchFetchJobsResult;
import com.oef.services.model.QueryExtensionPolicyResult;
import com.oef.services.model.RequestParamEnum;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import okhttp3.RequestBody;
import okhttp3.Response;

public class ObsService
extends RequestConvertor {
    private static final ILogger log = LoggerBuilder.getLogger("com.obs.services.ObsClient");

    protected ObsService() {
    }

    protected HeaderResponse setBucketVersioningImpl(SetBucketVersioningRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transVersioningConfiguration(request.getBucketName(), request.getStatus() != null ? request.getStatus().getCode() : null);
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParams, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected void verifyResponseContentType(Response response) throws ServiceException {
        String contentType;
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true) && !"application/xml".equalsIgnoreCase(contentType = response.header("Content-Type")) && !"text/xml".equalsIgnoreCase(contentType)) {
            throw new ServiceException("Expected XML document response from OBS but received content type " + contentType);
        }
    }

    protected BucketVersioningConfiguration getBucketVersioningImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.VERSIONING.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        BucketVersioningConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketVersioningHandler.class, false).getVersioningStatus();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketRequestPaymentImpl(SetBucketRequestPaymentRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REQUEST_PAYMENT.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transRequestPaymentConfiguration(request.getBucketName(), request.getPayer() != null ? request.getPayer().getCode() : null);
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParams, this.createRequestBody("application/xml", xml), true);
        return this.build(response);
    }

    protected RequestPaymentConfiguration getBucketRequestPaymentImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(SpecialParamEnum.REQUEST_PAYMENT.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParams, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        RequestPaymentConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.RequestPaymentHandler.class, false).getRequestPaymentConfiguration();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected ListVersionsResult listVersionsImpl(ListVersionsRequest request) throws ServiceException {
        RequestConvertor.TransResult result = this.transListVersionsRequest(request);
        Response response = this.performRestGet(request.getBucketName(), null, result.getParams(), result.getHeaders());
        this.verifyResponseContentType(response);
        XmlResponsesSaxParser.ListVersionsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.ListVersionsHandler.class, true);
        List<VersionOrDeleteMarker> partialItems = handler.getItems();
        ListVersionsResult listVersionsResult = new ListVersionsResult(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName(), handler.getRequestPrefix() == null ? request.getPrefix() : handler.getRequestPrefix(), handler.getKeyMarker() == null ? request.getKeyMarker() : handler.getKeyMarker(), handler.getNextKeyMarker(), handler.getVersionIdMarker() == null ? request.getVersionIdMarker() : handler.getVersionIdMarker(), handler.getNextVersionIdMarker(), String.valueOf(handler.getRequestMaxKeys()), handler.isListingTruncated(), partialItems.toArray(new VersionOrDeleteMarker[partialItems.size()]), handler.getCommonPrefixes(), response.header(this.getIHeaders().bucketRegionHeader()), handler.getDelimiter() == null ? request.getDelimiter() : handler.getDelimiter());
        ObsService.setResponseHeaders(listVersionsResult, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(listVersionsResult, response.code());
        return listVersionsResult;
    }

    protected BucketPolicyResponse getBucketPolicyImpl(BaseBucketRequest request) throws ServiceException {
        try {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
            Response response = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
            BucketPolicyResponse ret = new BucketPolicyResponse(response.body().string());
            ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
            ObsService.setStatusCode(ret, response.code());
            return ret;
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
    }

    protected BucketNotificationConfiguration getBucketNotificationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketNotificationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketNotificationConfigurationHandler.class, false).getBucketNotificationConfiguration();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketNotificationImpl(SetBucketNotificationRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.NOTIFICATION.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transBucketNotificationConfiguration(request.getBucketNotificationConfiguration());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketPolicyImpl(SetBucketPolicyRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "text/plain");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("text/plain", request.getPolicy()), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketPolicyImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.POLICY.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected InitiateMultipartUploadResult initiateMultipartUploadImpl(InitiateMultipartUploadRequest request) throws ServiceException {
        RequestConvertor.TransResult result = this.transInitiateMultipartUploadRequest(request);
        this.prepareRESTHeaderAcl(result.getHeaders(), request.getAcl());
        Response httpResponse = this.performRestPost(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), null, false);
        this.verifyResponseContentType(httpResponse);
        InitiateMultipartUploadResult multipartUpload = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.InitiateMultipartUploadHandler.class, true).getInitiateMultipartUploadResult();
        ObsService.setResponseHeaders(multipartUpload, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(multipartUpload, httpResponse.code());
        return multipartUpload;
    }

    protected HeaderResponse abortMultipartUploadImpl(AbortMultipartUploadRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        Response response = this.performRestDelete(request.getBucketName(), request.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected CompleteMultipartUploadResult completeMultipartUploadImpl(CompleteMultipartUploadRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPost(request.getBucketName(), request.getObjectKey(), metadata, requestParameters, this.createRequestBody("application/xml", this.getIConvertor().transCompleteMultipartUpload(request.getPartEtag())), false);
        this.verifyResponseContentType(response);
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CompleteMultipartUploadHandler.class, true);
        String versionId = response.header(this.getIHeaders().versionIdHeader());
        CompleteMultipartUploadResult ret = new CompleteMultipartUploadResult(handler.getBucketName(), handler.getObjectKey(), handler.getEtag(), handler.getLocation(), versionId, this.getObjectUrl(handler.getBucketName(), handler.getObjectKey()));
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected MultipartUploadListing listMultipartUploadsImpl(ListMultipartUploadsRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.UPLOADS.getOriginalStringCode(), "");
        if (request.getPrefix() != null) {
            requestParameters.put("prefix", request.getPrefix());
        }
        if (request.getDelimiter() != null) {
            requestParameters.put("delimiter", request.getDelimiter());
        }
        if (request.getMaxUploads() != null) {
            requestParameters.put("max-uploads", request.getMaxUploads().toString());
        }
        if (request.getKeyMarker() != null) {
            requestParameters.put("key-marker", request.getKeyMarker());
        }
        if (request.getUploadIdMarker() != null) {
            requestParameters.put("upload-id-marker", request.getUploadIdMarker());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListMultipartUploadsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListMultipartUploadsHandler.class, true);
        MultipartUploadListing listResult = new MultipartUploadListing(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName(), handler.getKeyMarker() == null ? request.getKeyMarker() : handler.getKeyMarker(), handler.getUploadIdMarker() == null ? request.getUploadIdMarker() : handler.getUploadIdMarker(), handler.getNextKeyMarker(), handler.getNextUploadIdMarker(), handler.getPrefix() == null ? request.getPrefix() : handler.getPrefix(), handler.getMaxUploads(), handler.isTruncated(), handler.getMultipartUploadList(), handler.getDelimiter() == null ? request.getDelimiter() : handler.getDelimiter(), handler.getCommonPrefixes().toArray(new String[handler.getCommonPrefixes().size()]));
        ObsService.setResponseHeaders(listResult, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(listResult, httpResponse.code());
        return listResult;
    }

    protected ListPartsResult listPartsImpl(ListPartsRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("uploadId", request.getUploadId());
        if (null != request.getMaxParts()) {
            requestParameters.put("max-parts", request.getMaxParts().toString());
        }
        if (null != request.getPartNumberMarker()) {
            requestParameters.put("part-number-marker", request.getPartNumberMarker().toString());
        }
        Response httpResponse = this.performRestGet(request.getBucketName(), request.getKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListPartsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListPartsHandler.class, true);
        ListPartsResult result = new ListPartsResult(handler.getBucketName() == null ? request.getBucketName() : handler.getBucketName(), handler.getObjectKey() == null ? request.getKey() : handler.getObjectKey(), handler.getUploadId() == null ? request.getUploadId() : handler.getUploadId(), handler.getInitiator(), handler.getOwner(), StorageClassEnum.getValueFromCode(handler.getStorageClass()), handler.getMultiPartList(), handler.getMaxParts(), handler.isTruncated(), (String)(handler.getPartNumberMarker() == null ? (request.getPartNumberMarker() == null ? null : request.getPartNumberMarker().toString()) : handler.getPartNumberMarker()), handler.getNextPartNumberMarker());
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected WebsiteConfiguration getBucketWebsiteConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        WebsiteConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketWebsiteConfigurationHandler.class, false).getWebsiteConfig();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected HeaderResponse setBucketWebsiteConfigurationImpl(SetBucketWebsiteRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String xml = this.getIConvertor().transWebsiteConfiguration(request.getWebsiteConfig());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketWebsiteConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.WEBSITE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected LifecycleConfiguration getBucketLifecycleConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(response);
        LifecycleConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.BucketLifecycleConfigurationHandler.class, false).getLifecycleConfig();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketLifecycleConfigurationImpl(SetBucketLifecycleRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        String xml = this.getIConvertor().transLifecycleConfiguration(request.getLifecycleConfig());
        metadata.put("Content-MD5", ServiceUtils.computeMD5(xml));
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketLifecycleConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LIFECYCLE.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected DeleteObjectsResult deleteObjectsImpl(DeleteObjectsRequest deleteObjectsRequest) throws ServiceException {
        String xml = this.getIConvertor().transKeyAndVersion(deleteObjectsRequest.getKeyAndVersions(), deleteObjectsRequest.isQuiet());
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-MD5", ServiceUtils.computeMD5(xml));
        metadata.put("Content-Type", "application/xml");
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DELETE.getOriginalStringCode(), "");
        this.transRequestPaymentHeaders(deleteObjectsRequest, metadata, this.getIHeaders());
        Response httpResponse = this.performRestPost(deleteObjectsRequest.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), false);
        this.verifyResponseContentType(httpResponse);
        DeleteObjectsResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.DeleteObjectsHandler.class, true).getMultipleDeleteResult();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected boolean headBucketImpl(BaseBucketRequest request) throws ServiceException {
        try {
            this.performRestHead(request.getBucketName(), null, null, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
            return true;
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    protected HeaderResponse setBucketFSStatusImpl(SetBucketFSStatusRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.FILEINTERFACE.getOriginalStringCode(), "");
        String xml = this.getIConvertor().transBucketFileInterface(request.getStatus());
        Response response = this.performRestPut(request.getBucketName(), null, this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected TruncateFileResult truncateFileImpl(TruncateFileRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParameters.put("length", String.valueOf(request.getNewLength()));
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, null, true);
        TruncateFileResult result = new TruncateFileResult();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected TruncateObjectResult truncateObjectImpl(TruncateObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TRUNCATE.getOriginalStringCode(), "");
        requestParameters.put("length", String.valueOf(request.getNewLength()));
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, null, true);
        TruncateObjectResult result = new TruncateObjectResult();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected RenameResult renameFileImpl(RenameRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParameters.put("name", request.getNewObjectKey());
        Response response = this.performRestPost(request.getBucketName(), request.getObjectKey(), this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, null, true);
        RenameResult result = new RenameResult();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected RenameObjectResult renameObjectImpl(RenameObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RENAME.getOriginalStringCode(), "");
        requestParameters.put("name", request.getNewObjectKey());
        Response response = this.performRestPost(request.getBucketName(), request.getObjectKey(), this.transRequestPaymentHeaders(request, null, this.getIHeaders()), requestParameters, null, true);
        RenameObjectResult result = new RenameObjectResult();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected GetBucketFSStatusResult getBucketMetadataImpl(BucketMetadataInfoRequest bucketMetadataInfoRequest) throws ServiceException {
        GetBucketFSStatusResult output = null;
        String origin = bucketMetadataInfoRequest.getOrigin();
        List<String> requestHeaders = bucketMetadataInfoRequest.getRequestHeaders();
        if (origin != null && requestHeaders != null && requestHeaders.size() > 0) {
            for (int i = 0; i < requestHeaders.size(); ++i) {
                String value = requestHeaders.get(i);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Origin", origin);
                headers.put("Access-Control-Request-Headers", value);
                this.transRequestPaymentHeaders(bucketMetadataInfoRequest, headers, this.getIHeaders());
                Response response = this.performRestHead(bucketMetadataInfoRequest.getBucketName(), null, null, headers);
                if (output == null) {
                    output = this.getOptionInfoResult(response);
                } else {
                    String header = response.header("Access-Control-Allow-Headers");
                    if (header != null && !output.getAllowHeaders().contains(header)) {
                        output.getAllowHeaders().add(header);
                    }
                }
                response.close();
            }
        } else {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (origin != null) {
                headers.put("Origin", origin);
            }
            this.transRequestPaymentHeaders(bucketMetadataInfoRequest, headers, this.getIHeaders());
            Response response = this.performRestHead(bucketMetadataInfoRequest.getBucketName(), null, null, headers);
            output = this.getOptionInfoResult(response);
            response.close();
        }
        return output;
    }

    protected RestoreObjectRequest.RestoreObjectStatus restoreObjectImpl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        RestoreObjectResult restoreObjectResult = this.restoreObjectV2Impl(restoreObjectRequest);
        return this.transRestoreObjectResultToRestoreObjectStatus(restoreObjectResult);
    }

    protected RestoreObjectResult restoreObjectV2Impl(RestoreObjectRequest restoreObjectRequest) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.RESTORE.getOriginalStringCode(), "");
        if (restoreObjectRequest.getVersionId() != null) {
            requestParameters.put("versionId", restoreObjectRequest.getVersionId());
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transRestoreObjectRequest(restoreObjectRequest);
        metadata.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(restoreObjectRequest, metadata, this.getIHeaders());
        Response response = this.performRestPost(restoreObjectRequest.getBucketName(), restoreObjectRequest.getObjectKey(), metadata, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        RestoreObjectResult ret = new RestoreObjectResult(restoreObjectRequest.getBucketName(), restoreObjectRequest.getObjectKey(), restoreObjectRequest.getVersionId());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected BucketTagInfo getBucketTaggingImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketTagInfo result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketTagInfoHandler.class, false).getBucketTagInfo();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketTaggingImpl(SetBucketTaggingRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transBucketTagInfo(request.getBucketTagInfo());
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketTaggingImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.TAGGING.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected BucketEncryption getBucketEncryptionImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketEncryption ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketEncryptionHandler.class, false).getEncryption();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected HeaderResponse setBucketEncryptionImpl(SetBucketEncryptionRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String encryptAsXml = request.getBucketEncryption() == null ? "" : this.getIConvertor().transBucketEcryption(request.getBucketEncryption());
        metadata.put("Content-Length", String.valueOf(encryptAsXml.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", encryptAsXml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketEncryptionImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ENCRYPTION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected ReplicationConfiguration getBucketReplicationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        ReplicationConfiguration result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketReplicationConfigurationHandler.class, false).getReplicationConfiguration();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketReplicationConfigurationImpl(SetBucketReplicationRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transReplicationConfiguration(request.getReplicationConfiguration());
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketReplicationConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.REPLICATION.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    protected TemporarySignatureResponse createTemporarySignatureResponse(AbstractTemporarySignatureRequest request) throws Exception {
        void var22_30;
        AbstractAuthentication abstractAuthentication;
        String objectKeyPath;
        String requestMethod = request.getMethod() != null ? request.getMethod().getOperationType() : "GET";
        TreeMap<String, Object> queryParams = new TreeMap<String, Object>();
        queryParams.putAll(request.getQueryParams());
        BasicSecurityKey securityKey = this.getProviderCredentials().getSecurityKey();
        String accessKey = securityKey.getAccessKey();
        String secretKey = securityKey.getSecretKey();
        String securityToken = securityKey.getSecurityToken();
        if (!queryParams.containsKey(this.getIHeaders().securityTokenHeader()) && ServiceUtils.isValid(securityToken)) {
            queryParams.put(this.getIHeaders().securityTokenHeader(), securityToken);
        }
        String endpoint = this.getEndpoint();
        String bucketName = request.getBucketName();
        String objectKey = request.getObjectKey();
        String hostname = ServiceUtils.generateHostnameForBucket(bucketName, this.isPathStyle(), endpoint);
        String virtualBucketPath = "";
        String uriPath = "";
        String string = objectKeyPath = objectKey != null ? RestUtils.encodeUrlPath(objectKey, "/") : "";
        if (!endpoint.equals(hostname)) {
            int subdomainOffset = hostname.lastIndexOf("." + endpoint);
            if (subdomainOffset > 0) {
                virtualBucketPath = hostname.substring(0, subdomainOffset) + "/";
            }
            uriPath = objectKeyPath;
        } else {
            uriPath = (!ServiceUtils.isValid(bucketName) ? "" : bucketName.trim()) + "/" + objectKeyPath;
        }
        if (this.isCname()) {
            hostname = endpoint;
            uriPath = objectKeyPath;
            virtualBucketPath = endpoint + "/";
        }
        uriPath = uriPath + "?";
        if (request.getSpecialParam() != null) {
            if (request.getSpecialParam() == SpecialParamEnum.STORAGECLASS || request.getSpecialParam() == SpecialParamEnum.STORAGEPOLICY) {
                request.setSpecialParam(this.getSpecialParamForStorageClass());
            }
            uriPath = uriPath + request.getSpecialParam().getOriginalStringCode() + "&";
        }
        String accessKeyIdPrefix = this.getProviderCredentials().getAuthType() == AuthTypeEnum.OBS ? "AccessKeyId=" : "AWSAccessKeyId=";
        uriPath = uriPath + accessKeyIdPrefix + accessKey;
        String expiresOrPolicy = "";
        String uriExpiresOrPolicy = "";
        if (request instanceof TemporarySignatureRequest) {
            TemporarySignatureRequest tempRequest = (TemporarySignatureRequest)request;
            long secondsSinceEpoch = tempRequest.getExpires() <= 0L ? 300L : tempRequest.getExpires();
            expiresOrPolicy = String.valueOf(secondsSinceEpoch += System.currentTimeMillis() / 1000L);
            uriExpiresOrPolicy = "&Expires=" + expiresOrPolicy;
        } else if (request instanceof PolicyTempSignatureRequest) {
            PolicyTempSignatureRequest policyRequest = (PolicyTempSignatureRequest)request;
            String policy = policyRequest.generatePolicy();
            expiresOrPolicy = ServiceUtils.toBase64(policy.getBytes("UTF-8"));
            uriExpiresOrPolicy = "&Policy=" + expiresOrPolicy;
        }
        uriPath = uriPath + uriExpiresOrPolicy;
        StringBuilder temp = new StringBuilder(uriPath);
        for (Map.Entry entry : queryParams.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            String key = RestUtils.uriEncode((CharSequence)entry.getKey(), false);
            temp.append("&");
            temp.append(key);
            temp.append("=");
            String string2 = RestUtils.uriEncode(entry.getValue().toString(), false);
            temp.append(string2);
        }
        uriPath = temp.toString();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(request.getHeaders());
        headers.put("Host", hostname + ":" + (this.getHttpsOnly() ? this.getHttpsPort() : this.getHttpPort()));
        TreeMap<String, String> actualSignedRequestHeaders = new TreeMap<String, String>();
        for (Map.Entry entry : headers.entrySet()) {
            String value;
            if (!ServiceUtils.isValid((String)entry.getKey())) continue;
            String key = ((String)entry.getKey()).toLowerCase().trim();
            boolean validKey = false;
            if (Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key) || key.startsWith(this.getRestHeaderPrefix()) || key.startsWith("x-obs-")) {
                validKey = true;
            } else if (requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                key = this.getRestMetadataPrefix() + key;
                validKey = true;
            }
            if (!validKey) continue;
            String string3 = value = entry.getValue() == null ? "" : ((String)entry.getValue()).trim();
            if (key.startsWith(this.getRestMetadataPrefix())) {
                value = RestUtils.uriEncode(value, true);
            }
            actualSignedRequestHeaders.put(((String)entry.getKey()).trim(), value);
        }
        String resource = "";
        if (request instanceof TemporarySignatureRequest) {
            resource = "/" + virtualBucketPath + uriPath;
        }
        if ((abstractAuthentication = this.getAuthentication()) == null) {
            AbstractAuthentication abstractAuthentication2 = V2Authentication.getInstance();
        }
        String canonicalString = var22_30.makeServiceCanonicalString(requestMethod, resource, actualSignedRequestHeaders, expiresOrPolicy, Constants.ALLOWED_RESOURCE_PARAMTER_NAMES);
        String signedCanonical = ServiceUtils.signWithHmacSha1(secretKey, canonicalString);
        String encodedCanonical = RestUtils.encodeUrlString(signedCanonical);
        uriPath = uriPath + "&Signature=" + encodedCanonical;
        String signedUrl = this.getHttpsOnly() ? "https://" : "http://";
        signedUrl = signedUrl + (String)headers.get("Host") + "/" + uriPath;
        TemporarySignatureResponse response = new TemporarySignatureResponse(signedUrl);
        response.getActualSignedRequestHeaders().putAll(actualSignedRequestHeaders);
        return response;
    }

    protected PostSignatureResponse createPostSignatureResponse(PostSignatureRequest request, boolean isV4) throws Exception {
        BasicSecurityKey securityKey = this.getProviderCredentials().getSecurityKey();
        String accessKey = securityKey.getAccessKey();
        String secretKey = securityKey.getSecretKey();
        String securityToken = securityKey.getSecurityToken();
        Date requestDate = request.getRequestDate() != null ? request.getRequestDate() : new Date();
        SimpleDateFormat expirationDateFormat = ServiceUtils.getExpirationDateFormat();
        Date expiryDate = request.getExpiryDate() == null ? new Date(requestDate.getTime() + (request.getExpires() <= 0L ? 300L : request.getExpires()) * 1000L) : request.getExpiryDate();
        String expiration = expirationDateFormat.format(expiryDate);
        StringBuilder originPolicy = new StringBuilder();
        originPolicy.append("{\"expiration\":").append("\"").append(expiration).append("\",").append("\"conditions\":[");
        String shortDate = ServiceUtils.getShortDateFormat().format(requestDate);
        String longDate = ServiceUtils.getLongDateFormat().format(requestDate);
        String credential = this.getCredential(shortDate, accessKey);
        if (request.getConditions() != null && !request.getConditions().isEmpty()) {
            originPolicy.append(ServiceUtils.join(request.getConditions(), ",")).append(",");
        } else {
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (isV4) {
                params.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
                params.put("X-Amz-Date", longDate);
                params.put("X-Amz-Credential", credential);
            }
            params.putAll(request.getFormParams());
            if (!params.containsKey(this.getIHeaders().securityTokenHeader()) && ServiceUtils.isValid(securityToken)) {
                params.put(this.getIHeaders().securityTokenHeader(), securityToken);
            }
            if (ServiceUtils.isValid(request.getBucketName())) {
                params.put("bucket", request.getBucketName());
            }
            if (ServiceUtils.isValid(request.getObjectKey())) {
                params.put("key", request.getObjectKey());
            }
            boolean matchAnyBucket = true;
            boolean matchAnyKey = true;
            for (Map.Entry entry : params.entrySet()) {
                if (!ServiceUtils.isValid((String)entry.getKey())) continue;
                String key = ((String)entry.getKey()).toLowerCase().trim();
                if (key.equals("bucket")) {
                    matchAnyBucket = false;
                } else if (key.equals("key")) {
                    matchAnyKey = false;
                }
                if (!Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key) && !key.startsWith(this.getRestHeaderPrefix()) && !key.startsWith("x-obs-") && !key.equals("acl") && !key.equals("bucket") && !key.equals("key") && !key.equals("success_action_redirect") && !key.equals("redirect") && !key.equals("success_action_status")) continue;
                String value = entry.getValue() == null ? "" : entry.getValue().toString();
                originPolicy.append("{\"").append(key).append("\":").append("\"").append(value).append("\"},");
            }
            if (matchAnyBucket) {
                originPolicy.append("[\"starts-with\", \"$bucket\", \"\"],");
            }
            if (matchAnyKey) {
                originPolicy.append("[\"starts-with\", \"$key\", \"\"],");
            }
        }
        originPolicy.append("]}");
        String policy = ServiceUtils.toBase64(originPolicy.toString().getBytes("UTF-8"));
        if (isV4) {
            String signature = V4Authentication.caculateSignature(policy, shortDate, secretKey);
            return new V4PostSignatureResponse(policy, originPolicy.toString(), "AWS4-HMAC-SHA256", credential, longDate, signature, expiration);
        }
        String signature = AbstractAuthentication.caculateSignature(policy, secretKey);
        return new PostSignatureResponse(policy, originPolicy.toString(), signature, expiration, accessKey);
    }

    protected TemporarySignatureResponse createV4TemporarySignature(TemporarySignatureRequest request) throws Exception {
        StringBuilder canonicalUri = new StringBuilder();
        String bucketName = request.getBucketName();
        String endpoint = this.getEndpoint();
        String objectKey = request.getObjectKey();
        if (!this.isCname()) {
            if (ServiceUtils.isValid(bucketName)) {
                if (this.isPathStyle() || !ServiceUtils.isBucketNameValidDNSName(bucketName)) {
                    canonicalUri.append("/").append(bucketName.trim());
                } else {
                    endpoint = bucketName.trim() + "." + endpoint;
                }
                if (ServiceUtils.isValid(objectKey)) {
                    canonicalUri.append("/").append(RestUtils.uriEncode(objectKey, false));
                }
            }
        } else if (ServiceUtils.isValid(objectKey)) {
            canonicalUri.append("/").append(RestUtils.uriEncode(objectKey, false));
        }
        if (this.isCname()) {
            endpoint = this.getEndpoint();
        }
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.putAll(request.getHeaders());
        TreeMap<String, Object> queryParams = new TreeMap<String, Object>();
        queryParams.putAll(request.getQueryParams());
        Date requestDate = request.getRequestDate();
        if (requestDate == null) {
            requestDate = new Date();
        }
        if (this.getHttpsOnly() && this.getHttpsPort() == 443 || !this.getHttpsOnly() && this.getHttpPort() == 80) {
            headers.put("Host", endpoint);
        } else {
            headers.put("Host", endpoint + ":" + (this.getHttpsOnly() ? this.getHttpsPort() : this.getHttpPort()));
        }
        BasicSecurityKey securityKey = this.getProviderCredentials().getSecurityKey();
        String accessKey = securityKey.getAccessKey();
        String secretKey = securityKey.getSecretKey();
        String securityToken = securityKey.getSecurityToken();
        if (!queryParams.containsKey(this.getIHeaders().securityTokenHeader()) && ServiceUtils.isValid(securityToken)) {
            queryParams.put(this.getIHeaders().securityTokenHeader(), securityToken);
        }
        String requestMethod = request.getMethod() != null ? request.getMethod().getOperationType() : "GET";
        StringBuilder signedHeaders = new StringBuilder();
        StringBuilder canonicalHeaders = new StringBuilder();
        int index = 0;
        TreeMap<String, String> actualSignedRequestHeaders = new TreeMap<String, String>();
        for (Map.Entry entry : headers.entrySet()) {
            String value;
            if (!ServiceUtils.isValid((String)entry.getKey())) continue;
            String key = ((String)entry.getKey()).toLowerCase().trim();
            boolean validKey = false;
            if (Constants.ALLOWED_REQUEST_HTTP_HEADER_METADATA_NAMES.contains(key) || key.startsWith(this.getRestHeaderPrefix()) || key.startsWith("x-obs-")) {
                validKey = true;
            } else if (requestMethod.equals("PUT") || requestMethod.equals("POST")) {
                key = this.getRestMetadataPrefix() + key;
                validKey = true;
            }
            if (!validKey) continue;
            String string = value = entry.getValue() == null ? "" : ((String)entry.getValue()).trim();
            if (key.startsWith(this.getRestMetadataPrefix())) {
                value = RestUtils.uriEncode(value, true);
            }
            signedHeaders.append(key);
            canonicalHeaders.append(key).append(":").append(value).append("\n");
            if (index++ != headers.size() - 1) {
                signedHeaders.append(";");
            }
            actualSignedRequestHeaders.put(((String)entry.getKey()).trim(), value);
        }
        String shortDate = ServiceUtils.getShortDateFormat().format(requestDate);
        String longDate = ServiceUtils.getLongDateFormat().format(requestDate);
        queryParams.put("X-Amz-Algorithm", "AWS4-HMAC-SHA256");
        queryParams.put("X-Amz-Credential", this.getCredential(shortDate, accessKey));
        queryParams.put("X-Amz-Date", longDate);
        queryParams.put("X-Amz-Expires", request.getExpires() <= 0L ? 300L : request.getExpires());
        queryParams.put("X-Amz-SignedHeaders", signedHeaders.toString());
        StringBuilder canonicalQueryString = new StringBuilder();
        StringBuilder signedUrl = new StringBuilder();
        if (this.getHttpsOnly()) {
            String securePortStr = this.getHttpsPort() == 443 ? "" : ":" + this.getHttpsPort();
            signedUrl.append("https://").append(endpoint).append(securePortStr);
        } else {
            String insecurePortStr = this.getHttpPort() == 80 ? "" : ":" + this.getHttpPort();
            signedUrl.append("http://").append(endpoint).append(insecurePortStr);
        }
        signedUrl.append((CharSequence)canonicalUri).append("?");
        if (request.getSpecialParam() != null) {
            if (request.getSpecialParam() == SpecialParamEnum.STORAGECLASS || request.getSpecialParam() == SpecialParamEnum.STORAGEPOLICY) {
                request.setSpecialParam(this.getSpecialParamForStorageClass());
            }
            queryParams.put(request.getSpecialParam().getOriginalStringCode(), null);
        }
        index = 0;
        for (Map.Entry entry : queryParams.entrySet()) {
            if (!ServiceUtils.isValid((String)entry.getKey())) continue;
            String key = RestUtils.uriEncode((CharSequence)entry.getKey(), false);
            canonicalQueryString.append(key).append("=");
            signedUrl.append(key);
            if (entry.getValue() != null) {
                String value = RestUtils.uriEncode(entry.getValue().toString(), false);
                canonicalQueryString.append(value);
                signedUrl.append("=").append(value);
            } else {
                canonicalQueryString.append("");
            }
            if (index++ == queryParams.size() - 1) continue;
            canonicalQueryString.append("&");
            signedUrl.append("&");
        }
        StringBuilder canonicalRequest = new StringBuilder(requestMethod).append("\n").append(canonicalUri.length() == 0 ? "/" : canonicalUri).append("\n").append((CharSequence)canonicalQueryString).append("\n").append((CharSequence)canonicalHeaders).append("\n").append((CharSequence)signedHeaders).append("\n").append("UNSIGNED-PAYLOAD");
        StringBuilder stringBuilder = new StringBuilder("AWS4-HMAC-SHA256").append("\n").append(longDate).append("\n").append(shortDate).append("/").append("region").append("/").append("s3").append("/").append("aws4_request").append("\n").append(V4Authentication.byteToHex(V4Authentication.sha256encode(canonicalRequest.toString())));
        signedUrl.append("&").append("X-Amz-").append("Signature=").append(V4Authentication.caculateSignature(stringBuilder.toString(), shortDate, secretKey));
        TemporarySignatureResponse response = new TemporarySignatureResponse(signedUrl.toString());
        response.getActualSignedRequestHeaders().putAll(actualSignedRequestHeaders);
        return response;
    }

    protected BucketMetadataInfoResult optionsImpl(String bucketName, String objectName, OptionsInfoRequest option) throws ServiceException {
        int i;
        IdentityHashMap<String, String> metadata = new IdentityHashMap<String, String>();
        if (ServiceUtils.isValid(option.getOrigin())) {
            metadata.put("Origin", option.getOrigin().trim());
        }
        for (i = 0; option.getRequestMethod() != null && i < option.getRequestMethod().size(); ++i) {
            metadata.put(new String(new StringBuilder("Access-Control-Request-Method")), option.getRequestMethod().get(i));
        }
        for (i = 0; option.getRequestHeaders() != null && i < option.getRequestHeaders().size(); ++i) {
            metadata.put(new String(new StringBuilder("Access-Control-Request-Headers")), option.getRequestHeaders().get(i));
        }
        this.transRequestPaymentHeaders(option.isRequesterPays(), metadata, this.getIHeaders());
        Response rsult = this.performRestOptions(bucketName, objectName, metadata, null, true);
        return this.getOptionInfoResult(rsult);
    }

    protected HeaderResponse deleteBucketCorsImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected BucketCors getBucketCorsImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketCors ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketCorsHandler.class, false).getConfiguration();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected HeaderResponse setBucketCorsImpl(SetBucketCorsRequest request) throws ServiceException {
        String corsXML = request.getBucketCors() == null ? "" : this.getIConvertor().transBucketCors(request.getBucketCors());
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.CORS.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        metadata.put("Content-MD5", ServiceUtils.computeMD5(corsXML));
        metadata.put("Content-Length", String.valueOf(corsXML.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", corsXML), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketQuotaImpl(SetBucketQuotaRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String quotaAsXml = request.getBucketQuota() == null ? "" : this.getIConvertor().transBucketQuota(request.getBucketQuota());
        metadata.put("Content-Length", String.valueOf(quotaAsXml.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", quotaAsXml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketStorageImpl(SetBucketStoragePolicyRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(this.getSpecialParamForStorageClass().getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        String xml = request.getBucketStorage() == null ? "" : this.getIConvertor().transStoragePolicy(request.getBucketStorage());
        metadata.put("Content-Length", String.valueOf(xml.length()));
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", xml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    void putAclImpl(String bucketName, String objectKey, AccessControlList acl, String versionId, boolean isRequesterPays) throws ServiceException {
        if (acl != null) {
            HashMap<String, String> requestParameters = new HashMap<String, String>();
            requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
            if (versionId != null) {
                requestParameters.put("versionId", versionId);
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("Content-Type", "application/xml");
            String aclAsXml = this.getIConvertor().transAccessControlList(acl, !ServiceUtils.isValid(objectKey));
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            this.transRequestPaymentHeaders(isRequesterPays, metadata, this.getIHeaders());
            this.performRestPut(bucketName, objectKey, metadata, requestParameters, this.createRequestBody("application/xml", aclAsXml), true);
        }
    }

    protected HeaderResponse setObjectAclImpl(SetObjectAclRequest request) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (request.getVersionId() != null) {
            requestParameters.put("versionId", request.getVersionId());
        }
        RequestBody entity = null;
        if (ServiceUtils.isValid(request.getCannedACL())) {
            request.setAcl(this.getIConvertor().transCannedAcl(request.getCannedACL().trim()));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAclObject(metadata, request.getAcl());
        if (isExtraAclPutRequired) {
            String aclAsXml = request.getAcl() == null ? "" : this.getIConvertor().transAccessControlList(request.getAcl(), false);
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            entity = this.createRequestBody("application/xml", aclAsXml);
        }
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), metadata, requestParameters, entity, true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse setBucketAclImpl(SetBucketAclRequest request) throws ServiceException {
        boolean isExtraAclPutRequired;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        RequestBody entity = null;
        if (ServiceUtils.isValid(request.getCannedACL())) {
            request.setAcl(this.getIConvertor().transCannedAcl(request.getCannedACL().trim()));
        }
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        boolean bl = isExtraAclPutRequired = !this.prepareRESTHeaderAcl(metadata, request.getAcl());
        if (isExtraAclPutRequired) {
            String aclAsXml = request.getAcl() == null ? "" : this.getIConvertor().transAccessControlList(request.getAcl(), true);
            metadata.put("Content-Length", String.valueOf(aclAsXml.length()));
            entity = this.createRequestBody("application/xml", aclAsXml);
        }
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, entity, true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected ObsBucket createBucketImpl(CreateBucketRequest request) throws ServiceException {
        Response response;
        AccessControlList acl;
        String bucketName;
        block4: {
            RequestConvertor.TransResult result = this.transCreateBucketRequest(request);
            bucketName = request.getBucketName();
            acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
            response = this.performRestPut(bucketName, null, result.getHeaders(), null, result.getBody(), true);
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating bucket with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(bucketName, null, acl, null, false);
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set bucket acl error", e);
                }
            }
        }
        Map<String, Object> map = this.cleanResponseHeaders(response);
        ObsBucket bucket = new ObsBucket();
        bucket.setBucketName(bucketName);
        bucket.setLocation(request.getLocation());
        bucket.setAcl(acl);
        bucket.setBucketStorageClass(request.getBucketStorageClass());
        ObsService.setResponseHeaders(bucket, map);
        ObsService.setStatusCode(bucket, response.code());
        return bucket;
    }

    protected BucketLocationResponse getBucketLocationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOCATION.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketLocationResponse ret = new BucketLocationResponse(this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLocationHandler.class, false).getLocation());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected BucketLoggingConfiguration getBucketLoggingConfigurationImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketLoggingConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketLoggingHandler.class, false).getBucketLoggingStatus();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppendObjectResult appendObjectImpl(AppendObjectRequest request) throws ServiceException {
        AppendObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            RequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transAppendObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPost(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose()) {
                    RepeatableRequestEntity entity = (RepeatableRequestEntity)result.getBody();
                    ServiceUtils.closeStream(entity);
                }
            }
            String nextPosition = response.header(this.getIHeaders().nextPositionHeader());
            ret = new AppendObjectResult(request.getBucketName(), request.getObjectKey(), response.header("ETag"), nextPosition != null ? Long.parseLong(nextPosition) : -1L, StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile writeFileImpl(WriteFileRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            RequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transWriteFileRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders().versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModifyObjectResult modifyObjectImpl(ModifyObjectRequest request) throws ServiceException {
        ModifyObjectResult ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            RequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transModifyObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ModifyObjectResult();
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObsFSFile putObjectImpl(PutObjectRequest request) throws ServiceException {
        ObsFSFile ret;
        block8: {
            Response response;
            boolean isExtraAclPutRequired;
            RequestConvertor.TransResult result = null;
            AccessControlList acl = request.getAcl();
            try {
                result = this.transPutObjectRequest(request);
                isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
                response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), null, result.getBody(), true);
            }
            finally {
                if (result != null && result.getBody() != null && request.isAutoClose() && result.getBody() instanceof Closeable) {
                    ServiceUtils.closeStream((Closeable)result.getBody());
                }
            }
            ret = new ObsFSFile(request.getBucketName(), request.getObjectKey(), response.header("ETag"), response.header(this.getIHeaders().versionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())), this.getObjectUrl(request.getBucketName(), request.getObjectKey()));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(ret, map);
            ObsService.setStatusCode(ret, response.code());
            if (isExtraAclPutRequired && acl != null) {
                try {
                    this.putAclImpl(request.getBucketName(), request.getObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return ret;
    }

    protected CopyObjectResult copyObjectImpl(CopyObjectRequest request) throws ServiceException {
        CopyObjectResult copyRet;
        block4: {
            RequestConvertor.TransResult result = this.transCopyObjectRequest(request);
            AccessControlList acl = request.getAcl();
            boolean isExtraAclPutRequired = !this.prepareRESTHeaderAcl(result.getHeaders(), acl);
            Response response = this.performRestPut(request.getDestinationBucketName(), request.getDestinationObjectKey(), result.getHeaders(), null, null, false);
            this.verifyResponseContentType(response);
            XmlResponsesSaxParser.CopyObjectResultHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyObjectResultHandler.class, false);
            copyRet = new CopyObjectResult(handler.getETag(), handler.getLastModified(), response.header(this.getIHeaders().versionIdHeader()), response.header(this.getIHeaders().copySourceVersionIdHeader()), StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())));
            Map<String, Object> map = this.cleanResponseHeaders(response);
            ObsService.setResponseHeaders(copyRet, map);
            ObsService.setStatusCode(copyRet, response.code());
            if (isExtraAclPutRequired && acl != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Creating object with a non-canned ACL using REST, so an extra ACL Put is required");
                }
                try {
                    this.putAclImpl(request.getDestinationBucketName(), request.getDestinationObjectKey(), acl, null, request.isRequesterPays());
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn("Try to set object acl error", e);
                }
            }
        }
        return copyRet;
    }

    protected ObsFSAttribute getObjectMetadataImpl(GetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        return (ObsFSAttribute)this.getObjectImpl(true, request.getBucketName(), request.getObjectKey(), headers, params, null, -1L);
    }

    protected boolean doesObjectExistImpl(GetObjectMetadataRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        this.transSseCHeaders(request.getSseCHeader(), headers, this.getIHeaders());
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            params.put("versionId", request.getVersionId());
        }
        boolean doesObjectExist = false;
        try {
            Response response = this.performRestHead(request.getBucketName(), request.getObjectKey(), params, headers);
            if (200 == response.code()) {
                doesObjectExist = true;
            }
        }
        catch (ServiceException ex) {
            if (404 == ex.getResponseCode()) {
                doesObjectExist = false;
            }
            throw ex;
        }
        return doesObjectExist;
    }

    protected ObjectMetadata setObjectMetadataImpl(SetObjectMetadataRequest request) {
        RequestConvertor.TransResult result = this.transSetObjectMetadataRequest(request);
        Response response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
        return this.getObsFSAttributeFromResponse(response);
    }

    protected ObsObject getObjectImpl(GetObjectRequest request) throws ServiceException {
        RequestConvertor.TransResult result = this.transGetObjectRequest(request);
        if (request.getRequestParameters() != null) {
            result.getParams().putAll(request.getRequestParameters());
        }
        return (ObsObject)this.getObjectImpl(false, request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), request.getProgressListener(), request.getProgressInterval());
    }

    private ObsFSAttribute getObsFSAttributeFromResponse(Response response) {
        ObsFSAttribute objMetadata;
        block15: {
            String fsMode;
            block14: {
                Date lastModifiedDate;
                block13: {
                    lastModifiedDate = null;
                    String lastModified = response.header("Last-Modified");
                    if (lastModified != null) {
                        try {
                            lastModifiedDate = ServiceUtils.parseRfc822Date(lastModified);
                        }
                        catch (ParseException e) {
                            if (!log.isWarnEnabled()) break block13;
                            log.warn("Response last-modified is not well-format", e);
                        }
                    }
                }
                objMetadata = new ObsFSAttribute();
                objMetadata.setLastModified(lastModifiedDate);
                objMetadata.setContentEncoding(response.header("Content-Encoding"));
                objMetadata.setContentType(response.header("Content-Type"));
                String contentLength = response.header("Content-Length");
                if (contentLength != null) {
                    try {
                        objMetadata.setContentLength(Long.parseLong(contentLength));
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block14;
                        log.warn("Response content-length is not well-format", e);
                    }
                }
            }
            if ((fsMode = response.header(this.getIHeaders().fsModeHeader())) != null) {
                objMetadata.setMode(Integer.parseInt(fsMode));
            }
            objMetadata.setWebSiteRedirectLocation(response.header(this.getIHeaders().websiteRedirectLocationHeader()));
            objMetadata.setObjectStorageClass(StorageClassEnum.getValueFromCode(response.header(this.getIHeaders().storageClassHeader())));
            String etag = response.header("ETag");
            objMetadata.setEtag(etag);
            if (etag != null && !etag.contains("-")) {
                String md5 = etag;
                if (md5.startsWith("\"")) {
                    md5 = md5.substring(1);
                }
                if (md5.endsWith("\"")) {
                    md5 = md5.substring(0, md5.length() - 1);
                }
                try {
                    objMetadata.setContentMd5(ServiceUtils.toBase64(ServiceUtils.fromHex(md5)));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block15;
                    log.debug(e.getMessage(), e);
                }
            }
        }
        objMetadata.setAppendable("Appendable".equals(response.header(this.getIHeaders().objectTypeHeader())));
        String nextPosition = response.header(this.getIHeaders().nextPositionHeader(), "-1");
        objMetadata.setNextPosition(Long.parseLong(nextPosition));
        if (objMetadata.getNextPosition() == -1L) {
            objMetadata.setNextPosition(Long.parseLong(response.header("Content-Length", "-1")));
        }
        objMetadata.getMetadata().putAll(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(objMetadata, response.code());
        return objMetadata;
    }

    protected Object getObjectImpl(boolean headOnly, String bucketName, String objectKey, Map<String, String> headers, Map<String, String> params, ProgressListener progressListener, long progressInterval) throws ServiceException {
        int readBufferSize;
        Response response = headOnly ? this.performRestHead(bucketName, objectKey, params, headers) : this.performRestGet(bucketName, objectKey, params, headers);
        ObsFSAttribute objMetadata = this.getObsFSAttributeFromResponse(response);
        if (headOnly) {
            response.close();
            return objMetadata;
        }
        ReadFileResult obsObject = new ReadFileResult();
        obsObject.setObjectKey(objectKey);
        obsObject.setBucketName(bucketName);
        obsObject.setMetadata(objMetadata);
        InputStream input = response.body().byteStream();
        if (progressListener != null) {
            SimpleProgressManager progressManager = new SimpleProgressManager(objMetadata.getContentLength(), 0L, progressListener, progressInterval > 0L ? progressInterval : 102400L);
            input = new ProgressInputStream(input, progressManager);
        }
        if ((readBufferSize = this.obsProperties.getIntProperty("httpclient.read-buffer-size", 8192)) > 0) {
            input = new BufferedInputStream(input, readBufferSize);
        }
        obsObject.setObjectContent(input);
        return obsObject;
    }

    protected BucketQuota getBucketQuotaImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.QUOTA.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketQuota ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketQuotaHandler.class, false).getQuota();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected BucketStoragePolicyConfiguration getBucketStoragePolicyImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(this.getSpecialParamForStorageClass().getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketStoragePolicyConfiguration ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketStoragePolicyHandler.class, false).getStoragePolicy();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected BucketStorageInfo getBucketStorageInfoImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.STORAGEINFO.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketStorageInfo ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketStorageInfoHandler.class, false).getStorageInfo();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected AccessControlList getBucketAclImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected AccessControlList getObjectAclImpl(GetObjectAclRequest getObjectAclRequest) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.ACL.getOriginalStringCode(), "");
        if (ServiceUtils.isValid(getObjectAclRequest.getVersionId())) {
            requestParameters.put("versionId", getObjectAclRequest.getVersionId().trim());
        }
        Response httpResponse = this.performRestGet(getObjectAclRequest.getBucketName(), getObjectAclRequest.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(getObjectAclRequest, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        AccessControlList ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.AccessControlListHandler.class, false).getAccessControlList();
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(ret, httpResponse.code());
        return ret;
    }

    protected DeleteObjectResult deleteObjectImpl(DeleteObjectRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        if (request.getVersionId() != null) {
            requestParameters.put("versionId", request.getVersionId());
        }
        Response response = this.performRestDelete(request.getBucketName(), request.getObjectKey(), requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        DropFileResult result = new DropFileResult(Boolean.valueOf(response.header(this.getIHeaders().deleteMarkerHeader())), request.getObjectKey(), response.header(this.getIHeaders().versionIdHeader()));
        Map<String, Object> map = this.cleanResponseHeaders(response);
        ObsService.setResponseHeaders(result, map);
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected ReadAheadResult readAheadObjectsImpl(ReadAheadRequest request) throws ServiceException {
        String body;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("prefix", request.getPrefix());
        HashMap<String, String> metadata = new HashMap<String, String>();
        String cacheControl = request.getCacheOption().getCode() + ", ttl=" + request.getTtl();
        metadata.put("x-cache-control", cacheControl);
        Response response = this.performRestPost(request.getBucketName(), null, metadata, requestParameters, null, false);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        ReadAheadResult result = (ReadAheadResult)JSONChange.jsonToObj(new ReadAheadResult(), body);
        result.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected ReadAheadResult deleteReadAheadObjectsImpl(String bucketName, String prefix) throws ServiceException {
        String body;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("prefix", prefix);
        Response response = this.performRestDelete(bucketName, null, requestParameters, false);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        ReadAheadResult result = (ReadAheadResult)JSONChange.jsonToObj(new ReadAheadResult(), body);
        result.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected ReadAheadQueryResult queryReadAheadObjectsTaskImpl(String bucketName, String taskId) throws ServiceException {
        String body;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put("readAhead", "");
        requestParameters.put("taskID", taskId);
        Response response = this.performRestGet(bucketName, null, requestParameters, null);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        ReadAheadQueryResult result = (ReadAheadQueryResult)JSONChange.jsonToObj(new ReadAheadQueryResult(), body);
        result.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(result, response.code());
        return result;
    }

    protected BucketDirectColdAccess getBucketDirectColdAccessImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        Response httpResponse = this.performRestGet(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        this.verifyResponseContentType(httpResponse);
        BucketDirectColdAccess result = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.BucketDirectColdAccessHandler.class, false).getBucketDirectColdAccess();
        ObsService.setResponseHeaders(result, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketDirectColdAccessImpl(SetBucketDirectColdAccessRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        HashMap<String, String> headers = new HashMap<String, String>();
        String requestXmlElement = this.getIConvertor().transBucketDirectColdAccess(request.getAccess());
        headers.put("Content-MD5", ServiceUtils.computeMD5(requestXmlElement));
        headers.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, headers, this.getIHeaders());
        Response response = this.performRestPut(request.getBucketName(), null, headers, requestParameters, this.createRequestBody("application/xml", requestXmlElement), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketDirectColdAccessImpl(BaseBucketRequest request) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.DIRECTCOLDACCESS.getOriginalStringCode(), "");
        Response response = this.performRestDelete(request.getBucketName(), null, requestParameters, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected ObjectListing listObjectsImpl(ListObjectsRequest listObjectsRequest) throws ServiceException {
        RequestConvertor.TransResult result = this.transListObjectsRequest(listObjectsRequest);
        Response httpResponse = this.performRestGet(listObjectsRequest.getBucketName(), null, result.getParams(), result.getHeaders());
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListObjectsHandler listObjectsHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListObjectsHandler.class, true);
        ObjectListing objList = new ObjectListing(listObjectsHandler.getObjects(), listObjectsHandler.getCommonPrefixes(), listObjectsHandler.getBucketName() == null ? listObjectsRequest.getBucketName() : listObjectsHandler.getBucketName(), listObjectsHandler.isListingTruncated(), listObjectsHandler.getRequestPrefix() == null ? listObjectsRequest.getPrefix() : listObjectsHandler.getRequestPrefix(), listObjectsHandler.getRequestMarker() == null ? listObjectsRequest.getMarker() : listObjectsHandler.getRequestMarker(), listObjectsHandler.getRequestMaxKeys(), listObjectsHandler.getRequestDelimiter() == null ? listObjectsRequest.getDelimiter() : listObjectsHandler.getRequestDelimiter(), listObjectsHandler.getMarkerForNextListing(), httpResponse.header(this.getIHeaders().bucketRegionHeader()), listObjectsHandler.getExtenedCommonPrefixes());
        ObsService.setResponseHeaders(objList, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(objList, httpResponse.code());
        return objList;
    }

    protected ListContentSummaryResult listContentSummaryImpl(ListContentSummaryRequest listContentSummaryRequest) throws ServiceException {
        RequestConvertor.TransResult result = this.transListContentSummaryRequest(listContentSummaryRequest);
        Response httpResponse = this.performRestGet(listContentSummaryRequest.getBucketName(), null, result.getParams(), null);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListContentSummaryHandler listContentSummaryHandler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListContentSummaryHandler.class, true);
        ListContentSummaryResult contentSummaryResult = new ListContentSummaryResult(listContentSummaryHandler.getFolderContentSummaries(), listContentSummaryHandler.getBucketName() == null ? listContentSummaryRequest.getBucketName() : listContentSummaryHandler.getBucketName(), listContentSummaryHandler.isListingTruncated(), listContentSummaryHandler.getRequestPrefix() == null ? listContentSummaryRequest.getPrefix() : listContentSummaryHandler.getRequestPrefix(), listContentSummaryHandler.getRequestMarker() == null ? listContentSummaryRequest.getMarker() : listContentSummaryHandler.getRequestMarker(), listContentSummaryHandler.getRequestMaxKeys(), listContentSummaryHandler.getRequestDelimiter() == null ? listContentSummaryRequest.getDelimiter() : listContentSummaryHandler.getRequestDelimiter(), listContentSummaryHandler.getMarkerForNextListing(), httpResponse.header(this.getIHeaders().bucketRegionHeader()));
        ObsService.setResponseHeaders(contentSummaryResult, this.cleanResponseHeaders(httpResponse));
        ObsService.setStatusCode(contentSummaryResult, httpResponse.code());
        return contentSummaryResult;
    }

    protected ListBucketsResult listAllBucketsImpl(ListBucketsRequest request) throws ServiceException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (request != null && request.isQueryLocation()) {
            this.putHeader(headers, this.getIHeaders().locationHeader(), "true");
        }
        if (request != null && request.getBucketType() != null) {
            this.putHeader(headers, this.getIHeaders().bucketTypeHeader(), request.getBucketType().getCode());
        }
        Response httpResponse = this.performRestGetForListBuckets("", null, null, headers);
        this.verifyResponseContentType(httpResponse);
        XmlResponsesSaxParser.ListBucketsHandler handler = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(httpResponse), XmlResponsesSaxParser.ListBucketsHandler.class, true);
        Map<String, Object> responseHeaders = this.cleanResponseHeaders(httpResponse);
        ListBucketsResult result = new ListBucketsResult(handler.getBuckets(), handler.getOwner());
        ObsService.setResponseHeaders(result, responseHeaders);
        ObsService.setStatusCode(result, httpResponse.code());
        return result;
    }

    protected HeaderResponse setBucketLoggingConfigurationImpl(SetBucketLoggingRequest request) throws ServiceException {
        if (request.getLoggingConfiguration().isLoggingEnabled() && request.isUpdateTargetACLifRequired() && this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS) {
            boolean isSetLoggingGroupWrite = false;
            boolean isSetLoggingGroupReadACP = false;
            String groupIdentifier = "http://acs.amazonaws.com/groups/s3/LogDelivery";
            BaseBucketRequest getBucketAclRequest = new BaseBucketRequest(request.getLoggingConfiguration().getTargetBucketName());
            getBucketAclRequest.setRequesterPays(request.isRequesterPays());
            AccessControlList logBucketACL = this.getBucketAclImpl(getBucketAclRequest);
            for (GrantAndPermission gap : logBucketACL.getGrantAndPermissions()) {
                if (!(gap.getGrantee() instanceof GroupGrantee)) continue;
                GroupGrantee grantee = (GroupGrantee)gap.getGrantee();
                if (!groupIdentifier.equals(this.getIConvertor().transGroupGrantee(grantee.getGroupGranteeType()))) continue;
                if (Permission.PERMISSION_WRITE.equals(gap.getPermission())) {
                    isSetLoggingGroupWrite = true;
                    continue;
                }
                if (!Permission.PERMISSION_READ_ACP.equals(gap.getPermission())) continue;
                isSetLoggingGroupReadACP = true;
            }
            if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                if (log.isWarnEnabled()) {
                    log.warn("Target logging bucket '" + request.getLoggingConfiguration().getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now");
                }
                if (logBucketACL.getOwner() != null) {
                    logBucketACL.getOwner().setDisplayName(null);
                }
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                SetBucketAclRequest aclReqeust = new SetBucketAclRequest(request.getBucketName(), logBucketACL);
                aclReqeust.setRequesterPays(request.isRequesterPays());
                this.setBucketAclImpl(aclReqeust);
            } else if (log.isDebugEnabled()) {
                log.debug("Target logging bucket '" + request.getLoggingConfiguration().getTargetBucketName() + "' has the necessary ACL settings");
            }
        }
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(SpecialParamEnum.LOGGING.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/xml");
        this.transRequestPaymentHeaders(request, metadata, this.getIHeaders());
        String statusAsXml = request.getLoggingConfiguration() == null ? "" : this.getIConvertor().transBucketLoggingConfiguration(request.getLoggingConfiguration());
        Response response = this.performRestPut(request.getBucketName(), null, metadata, requestParameters, this.createRequestBody("application/xml", statusAsXml), true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteBucketImpl(BaseBucketRequest request) throws ServiceException {
        Response response = this.performRestDelete(request.getBucketName(), null, null, this.transRequestPaymentHeaders(request, null, this.getIHeaders()));
        return this.build(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UploadPartResult uploadPartImpl(UploadPartRequest request) throws ServiceException {
        Response response;
        RequestConvertor.TransResult result = null;
        try {
            result = this.transUploadPartRequest(request);
            response = this.performRestPut(request.getBucketName(), request.getObjectKey(), result.getHeaders(), result.getParams(), result.getBody(), true);
        }
        finally {
            if (result != null && result.getBody() != null && request.isAutoClose()) {
                RepeatableRequestEntity entity = (RepeatableRequestEntity)result.getBody();
                ServiceUtils.closeStream(entity);
            }
        }
        UploadPartResult ret = new UploadPartResult();
        ret.setEtag(response.header("ETag"));
        ret.setPartNumber(request.getPartNumber());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected CopyPartResult copyPartImpl(CopyPartRequest request) throws ServiceException {
        RequestConvertor.TransResult result = this.transCopyPartRequest(request);
        Response response = this.performRestPut(request.getDestinationBucketName(), request.getDestinationObjectKey(), result.getHeaders(), result.getParams(), null, false);
        this.verifyResponseContentType(response);
        CopyPartResult ret = this.getXmlResponseSaxParser().parse(new HttpMethodReleaseInputStream(response), XmlResponsesSaxParser.CopyPartResultHandler.class, true).getCopyPartResult(request.getPartNumber());
        ObsService.setResponseHeaders(ret, this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    private String getObjectUrl(String bucketName, String objectKey) {
        boolean pathStyle = this.isPathStyle();
        boolean https = this.getHttpsOnly();
        boolean isCname = this.isCname();
        return (https ? "https://" : "http://") + (pathStyle || isCname ? "" : bucketName + ".") + this.getEndpoint() + ":" + (https ? this.getHttpsPort() : this.getHttpPort()) + "/" + (pathStyle ? bucketName + "/" : "") + RestUtils.uriEncode(objectKey, false);
    }

    protected ThreadPoolExecutor initThreadPool(AbstractBulkRequest request) {
        int taskThreadNum = request.getTaskThreadNum();
        int workQueenLength = request.getTaskQueueNum();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(taskThreadNum, taskThreadNum, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(workQueenLength));
        executor.setRejectedExecutionHandler(new BlockRejectedExecutionHandler());
        return executor;
    }

    protected void recordBulkTaskStatus(DefaultTaskProgressStatus progressStatus, TaskCallback<DeleteObjectResult, String> callback, TaskProgressListener listener, int interval) {
        progressStatus.execTaskIncrement();
        if (listener != null) {
            if (progressStatus.getExecTaskNum() % interval == 0) {
                listener.progressChanged(progressStatus);
            }
            if (progressStatus.getExecTaskNum() == progressStatus.getTotalTaskNum()) {
                listener.progressChanged(progressStatus);
            }
        }
    }

    protected HeaderResponse setExtensionPolicyImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/json", policyDocument), false, true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected QueryExtensionPolicyResult queryExtensionPolicyImpl(String bucketName) throws ServiceException {
        String body;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestGet(bucketName, null, requestParams, metadata, true);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        QueryExtensionPolicyResult ret = (QueryExtensionPolicyResult)JSONChange.jsonToObj(new QueryExtensionPolicyResult(), body);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteExtensionPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.EXTENSION_POLICY.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestDelete(bucketName, null, requestParams, metadata, true, true);
        return this.build(response);
    }

    protected CreateAsynchFetchJobsResult createFetchJobImpl(String bucketName, String policyDocument) throws ServiceException {
        String body;
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(RequestParamEnum.ASYNC_FETCH_JOBS.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestPost(bucketName, null, metadata, requestParameters, this.createRequestBody("application/json", policyDocument), false, true);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        CreateAsynchFetchJobsResult ret = (CreateAsynchFetchJobsResult)JSONChange.jsonToObj(new CreateAsynchFetchJobsResult(), body);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected QueryAsynchFetchJobsResult queryFetchJobImpl(String bucketName, String jobId) throws ServiceException {
        String body;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.ASYNC_FETCH_JOBS.getOriginalStringCode() + "/" + jobId, "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestGet(bucketName, null, requestParams, metadata, true);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        QueryAsynchFetchJobsResult ret = (QueryAsynchFetchJobsResult)JSONChange.jsonToObj(new QueryAsynchFetchJobsResult(), body);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse putDisPolicyImpl(String bucketName, String policyDocument) throws ServiceException {
        HashMap<String, String> requestParameters = new HashMap<String, String>();
        requestParameters.put(RequestParamEnum.DIS_POLICIES.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("Content-Type", "application/json");
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestPut(bucketName, null, metadata, requestParameters, this.createRequestBody("application/json", policyDocument), false, true);
        HeaderResponse ret = ObsService.build(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected GetDisPolicyResult getDisPolicyImpl(String bucketName) throws ServiceException {
        String body;
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.DIS_POLICIES.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestGet(bucketName, null, requestParams, metadata, true);
        this.verifyResponseContentTypeForJson(response);
        try {
            body = response.body().string();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        DisPolicy policy = (DisPolicy)JSONChange.jsonToObj(new DisPolicy(), body);
        GetDisPolicyResult ret = new GetDisPolicyResult(policy);
        ret.setResponseHeaders(this.cleanResponseHeaders(response));
        ObsService.setStatusCode(ret, response.code());
        return ret;
    }

    protected HeaderResponse deleteDisPolicyImpl(String bucketName) throws ServiceException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put(RequestParamEnum.DIS_POLICIES.getOriginalStringCode(), "");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put((this.getProviderCredentials().getAuthType() != AuthTypeEnum.OBS ? "x-amz-" : "x-obs-") + "oef-marker", "yes");
        Response response = this.performRestDelete(bucketName, null, requestParams, metadata, true, true);
        return this.build(response);
    }

    protected void verifyResponseContentTypeForJson(Response response) throws ServiceException {
        if (this.obsProperties.getBoolProperty("obs.verify-content-type", true)) {
            String contentType = response.header("Content-Type");
            if (null == contentType) {
                throw new ServiceException("Expected JSON document response  but received content type is null");
            }
            if (-1 == contentType.indexOf("application/json")) {
                throw new ServiceException("Expected JSON document response  but received content type is " + contentType);
            }
        }
    }
}

