/*
 * Decompiled with CFR 0.152.
 */
package com.obs.log;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.utils.AccessLoggerUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Log4jLogger
implements ILogger {
    private final Object logger;

    Log4jLogger(Object logger) {
        this.logger = logger;
    }

    @Override
    public boolean isInfoEnabled() {
        try {
            return this.logger != null && LoggerMethodHolder.infoLevel != null && (Boolean)LoggerMethodHolder.isEnabledFor.invoke(this.logger, LoggerMethodHolder.infoLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public void info(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "info");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void info(Object obj) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "info");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void info(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "info");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isWarnEnabled() {
        try {
            return this.logger != null && LoggerMethodHolder.warnLevel != null && (Boolean)LoggerMethodHolder.isEnabledFor.invoke(this.logger, LoggerMethodHolder.warnLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public void warn(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.warn != null) {
            try {
                LoggerMethodHolder.warn.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "warn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void warn(Object obj) {
        if (this.logger != null && LoggerMethodHolder.warn != null) {
            try {
                LoggerMethodHolder.warn.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "warn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void warn(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.warn != null) {
            try {
                LoggerMethodHolder.warn.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "warn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isErrorEnabled() {
        try {
            return this.logger != null && LoggerMethodHolder.errorLevel != null && (Boolean)LoggerMethodHolder.isEnabledFor.invoke(this.logger, LoggerMethodHolder.errorLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public void error(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.error != null) {
            try {
                LoggerMethodHolder.error.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "error");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void error(Object obj) {
        if (this.logger != null && LoggerMethodHolder.error != null) {
            try {
                LoggerMethodHolder.error.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "error");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void error(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.error != null) {
            try {
                LoggerMethodHolder.error.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "error");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return this.logger != null && LoggerMethodHolder.debugLevel != null && (Boolean)LoggerMethodHolder.isEnabledFor.invoke(this.logger, LoggerMethodHolder.debugLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public void debug(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.debug != null) {
            try {
                LoggerMethodHolder.debug.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "debug");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void debug(Object obj) {
        if (this.logger != null && LoggerMethodHolder.debug != null) {
            try {
                LoggerMethodHolder.debug.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "debug");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void debug(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.debug != null) {
            try {
                LoggerMethodHolder.debug.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "debug");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        try {
            return this.logger != null && LoggerMethodHolder.traceLevel != null && (Boolean)LoggerMethodHolder.isEnabledFor.invoke(this.logger, LoggerMethodHolder.traceLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public void trace(CharSequence msg) {
        if (this.logger != null && LoggerMethodHolder.trace != null) {
            try {
                LoggerMethodHolder.trace.invoke(this.logger, msg, null);
                AccessLoggerUtils.appendLog(msg, "trace");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void trace(Object obj) {
        if (this.logger != null && LoggerMethodHolder.trace != null) {
            try {
                LoggerMethodHolder.trace.invoke(this.logger, obj, null);
                AccessLoggerUtils.appendLog(obj, "trace");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void trace(Object obj, Throwable e) {
        if (this.logger != null && LoggerMethodHolder.trace != null) {
            try {
                LoggerMethodHolder.trace.invoke(this.logger, obj, e);
                AccessLoggerUtils.appendLog(obj, "trace");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void accessRecord(Object obj) {
        if (this.logger != null && LoggerMethodHolder.info != null) {
            try {
                LoggerMethodHolder.info.invoke(this.logger, obj, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class LoggerMethodHolder {
        private static Method info;
        private static Method warn;
        private static Method debug;
        private static Method trace;
        private static Method error;
        private static Method isEnabledFor;
        private static Class<?> priority;
        private static Class<?> level;
        private static Object infoLevel;
        private static Object debugLevel;
        private static Object errorLevel;
        private static Object warnLevel;
        private static Object traceLevel;

        private LoggerMethodHolder() {
        }

        static {
            try {
                if (LoggerBuilder.GetLoggerHolder.loggerClass != null) {
                    info = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("info", Object.class, Throwable.class);
                    warn = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("warn", Object.class, Throwable.class);
                    error = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("error", Object.class, Throwable.class);
                    debug = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("debug", Object.class, Throwable.class);
                    trace = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("trace", Object.class, Throwable.class);
                    priority = Class.forName("org.apache.log4j.Priority");
                    isEnabledFor = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isEnabledFor", priority);
                    level = Class.forName("org.apache.log4j.Level");
                    infoLevel = level.getField("INFO").get(level);
                    debugLevel = level.getField("DEBUG").get(level);
                    errorLevel = level.getField("ERROR").get(level);
                    warnLevel = level.getField("WARN").get(level);
                    traceLevel = level.getField("TRACE").get(level);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
    }
}

