/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model.fs;

import com.obs.services.exception.ObsException;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSFolder;
import com.obs.services.model.fs.ReadFileRequest;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.File;
import java.io.InputStream;

public class ObsFSFile
extends ObsFSFolder {
    public ObsFSFile(String bucketName, String objectKey, String etag, String versionId, StorageClassEnum storageClass, String objectUrl) {
        super(bucketName, objectKey, etag, versionId, storageClass, objectUrl);
    }

    @Override
    public ObsFSAttribute attribute() throws ObsException {
        return super.attribute();
    }

    public ReadFileResult read() throws ObsException {
        this.checkInternalClient();
        ReadFileRequest request = new ReadFileRequest(this.getBucketName(), this.getObjectKey());
        return this.innerClient.readFile(request);
    }

    public ReadFileResult read(long rangeStart, long rangeEnd) throws ObsException {
        this.checkInternalClient();
        ReadFileRequest request = new ReadFileRequest(this.getBucketName(), this.getObjectKey());
        request.setRangeStart(rangeStart);
        request.setRangeEnd(rangeEnd);
        return this.innerClient.readFile(request);
    }

    public ObsFSFile write(File file, long position) throws ObsException {
        this.checkInternalClient();
        WriteFileRequest request = new WriteFileRequest(this.getBucketName(), this.getObjectKey(), file, position);
        return this.innerClient.writeFile(request);
    }

    public ObsFSFile write(File file) throws ObsException {
        return this.write(file, 0L);
    }

    public ObsFSFile write(InputStream input, long position) throws ObsException {
        this.checkInternalClient();
        WriteFileRequest request = new WriteFileRequest(this.getBucketName(), this.getObjectKey(), input, position);
        return this.innerClient.writeFile(request);
    }

    public ObsFSFile append(File file) throws ObsException {
        this.checkInternalClient();
        WriteFileRequest request = new WriteFileRequest(this.getBucketName(), this.getObjectKey(), file);
        return this.innerClient.appendFile(request);
    }

    public ObsFSFile append(InputStream input) throws ObsException {
        this.checkInternalClient();
        WriteFileRequest request = new WriteFileRequest(this.getBucketName(), this.getObjectKey(), input);
        return this.innerClient.appendFile(request);
    }

    public ObsFSFile write(InputStream input) throws ObsException {
        return this.write(input, 0L);
    }

    @Override
    public RenameResult rename(String newName) throws ObsException {
        this.checkInternalClient();
        RenameRequest request = new RenameRequest(this.getBucketName(), this.getObjectKey(), newName);
        return this.innerClient.renameFile(request);
    }

    public TruncateFileResult truncate(long newLength) throws ObsException {
        this.checkInternalClient();
        TruncateFileRequest request = new TruncateFileRequest(this.getBucketName(), this.getObjectKey(), newLength);
        return this.innerClient.truncateFile(request);
    }
}

