/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.model;

import com.obs.services.internal.ObsConvertor;
import com.obs.services.model.EventTypeEnum;
import com.obs.services.model.HeaderResponse;
import java.util.ArrayList;
import java.util.List;

public class TopicConfiguration
extends HeaderResponse {
    private String id;
    private Filter filter;
    private String topic;
    private List<EventTypeEnum> events;

    public TopicConfiguration() {
    }

    public TopicConfiguration(String id, Filter filter, String topic, List<EventTypeEnum> events) {
        this.id = id;
        this.filter = filter;
        this.topic = topic;
        this.events = events;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Deprecated
    public List<String> getEvents() {
        ArrayList<String> list = new ArrayList<String>();
        for (EventTypeEnum e : this.getEventTypes()) {
            list.add(ObsConvertor.transEventTypeStatic(e));
        }
        return list;
    }

    @Deprecated
    public void setEvents(List<String> events) {
        if (events != null) {
            for (String event : events) {
                EventTypeEnum e = EventTypeEnum.getValueFromCode(event);
                if (e == null) continue;
                this.getEventTypes().add(e);
            }
        }
    }

    public List<EventTypeEnum> getEventTypes() {
        if (this.events == null) {
            this.events = new ArrayList<EventTypeEnum>();
        }
        return this.events;
    }

    public void setEventTypes(List<EventTypeEnum> events) {
        this.events = events;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    @Override
    public String toString() {
        return "TopicConfiguration [id=" + this.id + ", topic=" + this.topic + ", events=" + this.events + ", filter=" + this.filter + "]";
    }

    public static class Filter {
        private List<FilterRule> filterRules;

        public List<FilterRule> getFilterRules() {
            if (this.filterRules == null) {
                this.filterRules = new ArrayList<FilterRule>();
            }
            return this.filterRules;
        }

        public void setFilterRules(List<FilterRule> filterRules) {
            this.filterRules = filterRules;
        }

        public void addFilterRule(String name, String value) {
            this.getFilterRules().add(new FilterRule(name, value));
        }

        public String toString() {
            return "Filter [fileterRules=" + this.filterRules + "]";
        }

        public static class FilterRule {
            private String name;
            private String value;

            public FilterRule() {
            }

            public FilterRule(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                FilterRule other = (FilterRule)obj;
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return !(this.value == null ? other.value != null : !this.value.equals(other.value));
            }

            public String toString() {
                return "FilterRule [name=" + this.name + ", value=" + this.value + "]";
            }
        }
    }
}

