/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.utils;

import com.obs.services.internal.IHeaders;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.utils.DefaultAuthentication;
import com.obs.services.internal.utils.IAuthentication;
import com.obs.services.internal.utils.ServiceUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractAuthentication {
    protected abstract IHeaders getIHeaders();

    protected abstract String getAuthPrefix();

    public static String caculateSignature(String stringToSign, String sk) throws ServiceException {
        return ServiceUtils.signWithHmacSha1(sk, stringToSign);
    }

    public final IAuthentication makeAuthorizationString(String method, Map<String, String> headers, String fullUrl, List<String> serviceResourceParameterNames, ProviderCredentials credent) throws ServiceException {
        String canonicalString;
        try {
            canonicalString = this.makeServiceCanonicalString(method, fullUrl, headers, null, serviceResourceParameterNames);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException(e);
        }
        String signedCanonical = AbstractAuthentication.caculateSignature(canonicalString, credent.getSecretKey());
        String auth = this.getAuthPrefix() + " " + credent.getAccessKey() + ":" + signedCanonical;
        return new DefaultAuthentication(canonicalString, canonicalString, auth);
    }

    /*
     * WARNING - void declaration
     */
    public final String makeServiceCanonicalString(String method, String resource, Map<String, String> headersMap, String expires, List<String> serviceResourceParameterNames) throws UnsupportedEncodingException {
        String key;
        StringBuilder canonicalStringBuf = new StringBuilder();
        canonicalStringBuf.append(method).append("\n");
        String dateHeader = "Date".toLowerCase();
        String contentTypeHeader = "Content-Type".toLowerCase();
        String contentMd5Header = "Content-MD5".toLowerCase();
        String headerPrefix = this.getIHeaders().headerPrefix();
        String headerMetaPrefix = this.getIHeaders().headerMetaPrefix();
        TreeMap<String, Object> interestingHeaders = new TreeMap<String, Object>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                List<String> values;
                key = entry.getKey();
                String string = entry.getValue();
                if (key == null) continue;
                String lk = key.toLowerCase(Locale.getDefault());
                if (lk.equals(contentTypeHeader) || lk.equals(contentMd5Header) || lk.equals(dateHeader)) {
                    interestingHeaders.put(lk, string);
                    continue;
                }
                if (!lk.startsWith(headerPrefix)) continue;
                if (interestingHeaders.containsKey(lk)) {
                    values = (List)interestingHeaders.get(lk);
                } else {
                    values = new ArrayList();
                    interestingHeaders.put(lk, values);
                }
                values.add(string);
            }
        }
        if (interestingHeaders.containsKey(this.getIHeaders().dateHeader())) {
            interestingHeaders.put(dateHeader, "");
        }
        if (expires != null) {
            interestingHeaders.put(dateHeader, expires);
        }
        if (!interestingHeaders.containsKey(contentTypeHeader)) {
            interestingHeaders.put(contentTypeHeader, "");
        }
        if (!interestingHeaders.containsKey(contentMd5Header)) {
            interestingHeaders.put(contentMd5Header, "");
        }
        for (Map.Entry<String, String> entry : interestingHeaders.entrySet()) {
            void var16_25;
            key = entry.getKey();
            String string = entry.getValue();
            if (string instanceof List) {
                String string2 = ServiceUtils.join((List)((Object)string), ",", true);
            } else if (string == null) {
                String string3 = "";
            }
            if (key.startsWith(headerMetaPrefix)) {
                canonicalStringBuf.append(key).append(':').append(var16_25.toString().trim());
            } else if (key.startsWith(headerPrefix)) {
                canonicalStringBuf.append(key).append(':').append(var16_25);
            } else {
                canonicalStringBuf.append(var16_25);
            }
            canonicalStringBuf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            canonicalStringBuf.append(resource);
        } else {
            canonicalStringBuf.append(resource.substring(0, queryIndex));
        }
        if (queryIndex >= 0) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            String query = resource.substring(queryIndex + 1);
            for (String paramPair : query.split("&")) {
                String[] paramNameValue = paramPair.split("=");
                String name = URLDecoder.decode(paramNameValue[0], "UTF-8");
                String value2 = null;
                if (paramNameValue.length > 1) {
                    value2 = URLDecoder.decode(paramNameValue[1], "UTF-8");
                }
                if (!serviceResourceParameterNames.contains(name.toLowerCase()) && !name.toLowerCase().startsWith(headerPrefix)) continue;
                treeMap.put(name, value2);
            }
            if (treeMap.size() > 0) {
                canonicalStringBuf.append("?");
            }
            boolean bl = false;
            for (Map.Entry entry : treeMap.entrySet()) {
                boolean bl2;
                if (bl2) {
                    canonicalStringBuf.append("&");
                }
                canonicalStringBuf.append((String)entry.getKey());
                if (entry.getValue() != null) {
                    canonicalStringBuf.append("=").append((String)entry.getValue());
                }
                bl2 = true;
            }
        }
        return canonicalStringBuf.toString();
    }
}

