/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.handler;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SimpleHandler
extends DefaultHandler {
    private static final ILogger log = LoggerBuilder.getLogger(SimpleHandler.class);
    protected XMLReader xr = null;
    private StringBuffer textContent = null;
    protected SimpleHandler currentHandler = null;
    protected SimpleHandler parentHandler = null;

    public SimpleHandler(XMLReader xr) {
        this.xr = xr;
        this.textContent = new StringBuffer();
        this.currentHandler = this;
    }

    public void transferControlToHandler(SimpleHandler toHandler) {
        this.currentHandler = toHandler;
        toHandler.parentHandler = this;
        this.xr.setContentHandler(this.currentHandler);
        this.xr.setErrorHandler(this.currentHandler);
    }

    public void returnControlToParentHandler() {
        if (this.isChildHandler()) {
            this.parentHandler.currentHandler = this.parentHandler;
            this.parentHandler.controlReturned(this);
            this.currentHandler = this.parentHandler;
            this.xr.setContentHandler(this.currentHandler);
            this.xr.setErrorHandler(this.currentHandler);
        } else if (log.isDebugEnabled()) {
            log.debug("Ignoring call to return control to parent handler, as this class has no parent: " + this.getClass().getName());
        }
    }

    public boolean isChildHandler() {
        return this.parentHandler != null;
    }

    public void controlReturned(SimpleHandler childHandler) {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attrs) {
        block4: {
            try {
                Method method = this.currentHandler.getClass().getMethod("start" + name, new Class[0]);
                method.invoke((Object)this.currentHandler, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipped non-existent SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName());
                }
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block4;
                log.error("Unable to invoke SimpleHandler subclass's startElement method for '" + name + "' in " + this.getClass().getName(), t);
            }
        }
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        block4: {
            String elementText = this.textContent.toString().trim();
            try {
                Method method = this.currentHandler.getClass().getMethod("end" + name, String.class);
                method.invoke((Object)this.currentHandler, elementText);
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipped non-existent SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName());
                }
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block4;
                log.error("Unable to invoke SimpleHandler subclass's endElement method for '" + name + "' in " + this.getClass().getName(), t);
            }
        }
        this.textContent = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.textContent.append(ch, start, length);
    }
}

