/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services;

import com.obs.log.ILogger;
import com.obs.log.InterfaceLogBean;
import com.obs.log.LoggerBuilder;
import com.obs.services.IFSClient;
import com.obs.services.IObsClient;
import com.obs.services.ObsConfiguration;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.ObsService;
import com.obs.services.internal.ResumableClient;
import com.obs.services.internal.ServiceException;
import com.obs.services.internal.consensus.CacheManager;
import com.obs.services.internal.consensus.SegmentLock;
import com.obs.services.internal.security.ProviderCredentials;
import com.obs.services.internal.task.BlankTaksCallback;
import com.obs.services.internal.task.BlankTaskProgressStatus;
import com.obs.services.internal.task.BlockRejectedExecutionHandler;
import com.obs.services.internal.task.DefaultTaskProgressStatus;
import com.obs.services.internal.task.RestoreObjectTask;
import com.obs.services.internal.utils.AccessLoggerUtils;
import com.obs.services.internal.utils.ReflectUtils;
import com.obs.services.internal.utils.ServiceUtils;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.AccessControlList;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.AuthTypeEnum;
import com.obs.services.model.BucketCors;
import com.obs.services.model.BucketLocationResponse;
import com.obs.services.model.BucketLoggingConfiguration;
import com.obs.services.model.BucketMetadataInfoRequest;
import com.obs.services.model.BucketMetadataInfoResult;
import com.obs.services.model.BucketNotificationConfiguration;
import com.obs.services.model.BucketPolicyResponse;
import com.obs.services.model.BucketQuota;
import com.obs.services.model.BucketStorageInfo;
import com.obs.services.model.BucketStoragePolicyConfiguration;
import com.obs.services.model.BucketTagInfo;
import com.obs.services.model.BucketVersioningConfiguration;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadResult;
import com.obs.services.model.CopyObjectRequest;
import com.obs.services.model.CopyObjectResult;
import com.obs.services.model.CopyPartRequest;
import com.obs.services.model.CopyPartResult;
import com.obs.services.model.CreateBucketRequest;
import com.obs.services.model.DeleteObjectResult;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.DownloadFileResult;
import com.obs.services.model.GetObjectMetadataRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.HeaderResponse;
import com.obs.services.model.HttpMethodEnum;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadResult;
import com.obs.services.model.KeyAndVersion;
import com.obs.services.model.LifecycleConfiguration;
import com.obs.services.model.ListBucketsRequest;
import com.obs.services.model.ListBucketsResult;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ListPartsRequest;
import com.obs.services.model.ListPartsResult;
import com.obs.services.model.ListVersionsRequest;
import com.obs.services.model.ListVersionsResult;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsBucket;
import com.obs.services.model.ObsObject;
import com.obs.services.model.OptionsInfoRequest;
import com.obs.services.model.OptionsInfoResult;
import com.obs.services.model.PostSignatureRequest;
import com.obs.services.model.PostSignatureResponse;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.PutObjectResult;
import com.obs.services.model.ReplicationConfiguration;
import com.obs.services.model.RestoreObjectRequest;
import com.obs.services.model.RestoreObjectResult;
import com.obs.services.model.RestoreObjectsRequest;
import com.obs.services.model.RestoreTierEnum;
import com.obs.services.model.S3Bucket;
import com.obs.services.model.S3BucketCors;
import com.obs.services.model.SetObjectMetadataRequest;
import com.obs.services.model.SpecialParamEnum;
import com.obs.services.model.StorageClassEnum;
import com.obs.services.model.TaskProgressListener;
import com.obs.services.model.TemporarySignatureRequest;
import com.obs.services.model.TemporarySignatureResponse;
import com.obs.services.model.UploadFileRequest;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import com.obs.services.model.V4PostSignatureRequest;
import com.obs.services.model.V4PostSignatureResponse;
import com.obs.services.model.V4TemporarySignatureRequest;
import com.obs.services.model.V4TemporarySignatureResponse;
import com.obs.services.model.VersionOrDeleteMarker;
import com.obs.services.model.WebsiteConfiguration;
import com.obs.services.model.fs.GetAttributeRequest;
import com.obs.services.model.fs.GetBucketFSStatusRequest;
import com.obs.services.model.fs.GetBucketFSStatusResult;
import com.obs.services.model.fs.NewBucketRequest;
import com.obs.services.model.fs.NewFileRequest;
import com.obs.services.model.fs.NewFolderRequest;
import com.obs.services.model.fs.ObsFSAttribute;
import com.obs.services.model.fs.ObsFSBucket;
import com.obs.services.model.fs.ObsFSFile;
import com.obs.services.model.fs.ObsFSFolder;
import com.obs.services.model.fs.ReadFileRequest;
import com.obs.services.model.fs.ReadFileResult;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import com.obs.services.model.fs.SetBucketFSStatusRequest;
import com.obs.services.model.fs.TruncateFileRequest;
import com.obs.services.model.fs.TruncateFileResult;
import com.obs.services.model.fs.WriteFileRequest;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ObsClient
extends ObsService
implements Closeable,
IObsClient,
IFSClient {
    private static final ILogger ILOG = LoggerBuilder.getLogger(ObsClient.class);

    private void init(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        InterfaceLogBean reqBean = new InterfaceLogBean("ObsClient", config.getEndPoint(), "");
        ProviderCredentials credentials = new ProviderCredentials(accessKey, secretKey, securityToken);
        ObsProperties obsProperties = ServiceUtils.changeFromObsConfiguration(config);
        credentials.setAuthType(config.getAuthType());
        this.obsProperties = obsProperties;
        this.credentials = credentials;
        this.obsProperties = obsProperties;
        this.keyManagerFactory = config.getKeyManagerFactory();
        this.trustManagerFactory = config.getTrustManagerFactory();
        if (this.isAuthTypeNegotiation()) {
            this.apiVersionCache = new CacheManager();
            this.getProviderCredentials().initThreadLocalAuthType();
            this.segmentLock = new SegmentLock();
        }
        this.initHttpClient(config.getHttpDispatcher());
        reqBean.setRespTime(new Date());
        reqBean.setResultCode("0");
        if (ILOG.isInfoEnabled()) {
            ILOG.info(reqBean);
        }
        if (ILOG.isWarnEnabled()) {
            StringBuilder sb = new StringBuilder("[OBS SDK Version=");
            sb.append("3.0.3");
            sb.append("];");
            sb.append("[Endpoint=");
            String ep = "";
            ep = this.getHttpsOnly() ? "https://" + this.getEndpoint() + ":" + this.getHttpsPort() + "/" : "http://" + this.getEndpoint() + ":" + this.getHttpPort() + "/";
            sb.append(ep);
            sb.append("];");
            sb.append("[Access Mode=");
            sb.append(this.isPathStyle() ? "Path" : "Virtul Hosting");
            sb.append("]");
            ILOG.warn(sb);
        }
    }

    public ObsClient(String endPoint) {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init("", "", null, config);
    }

    public ObsClient(ObsConfiguration config) {
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init("", "", null, config);
    }

    public ObsClient(String accessKey, String secretKey, String endPoint) {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init(accessKey, secretKey, null, config);
    }

    public ObsClient(String accessKey, String secretKey, ObsConfiguration config) {
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init(accessKey, secretKey, null, config);
    }

    public ObsClient(String accessKey, String secretKey, String securityToken, String endPoint) {
        ObsConfiguration config = new ObsConfiguration();
        config.setEndPoint(endPoint);
        this.init(accessKey, secretKey, securityToken, config);
    }

    public ObsClient(String accessKey, String secretKey, String securityToken, ObsConfiguration config) {
        if (config == null) {
            config = new ObsConfiguration();
        }
        this.init(accessKey, secretKey, securityToken, config);
    }

    @Override
    public void refresh(String accessKey, String secretKey, String securityToken) {
        ProviderCredentials credentials = new ProviderCredentials(accessKey, secretKey, securityToken);
        credentials.setAuthType(this.credentials.getAuthType());
        this.setProviderCredentials(credentials);
    }

    public String createSignedUrl(HttpMethodEnum method, String bucketName, String objectKey, SpecialParamEnum specialParam, Date expiryTime, Map<String, String> headers, Map<String, Object> queryParams) throws ObsException {
        return this.createSignedUrl(method, bucketName, objectKey, specialParam, expiryTime == null ? 300L : (expiryTime.getTime() - System.currentTimeMillis()) / 1000L, headers, queryParams);
    }

    public String createSignedUrl(HttpMethodEnum method, String bucketName, String objectKey, SpecialParamEnum specialParam, long expires, Map<String, String> headers, Map<String, Object> queryParams) {
        TemporarySignatureRequest request = new TemporarySignatureRequest();
        request.setMethod(method);
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setSpecialParam(specialParam);
        request.setHeaders(headers);
        request.setQueryParams(queryParams);
        if (expires > 0L) {
            request.setExpires(expires);
        }
        return this.createTemporarySignature(request).getSignedUrl();
    }

    @Deprecated
    public V4TemporarySignatureResponse createV4TemporarySignature(V4TemporarySignatureRequest request) {
        ServiceUtils.asserParameterNotNull(request, "V4TemporarySignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createV4TemporarySignature", this.getEndpoint(), "");
        try {
            TemporarySignatureResponse response = this.createV4TemporarySignature((TemporarySignatureRequest)request);
            V4TemporarySignatureResponse res = new V4TemporarySignatureResponse(response.getSignedUrl());
            res.getActualSignedRequestHeaders().putAll(response.getActualSignedRequestHeaders());
            return res;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Deprecated
    public V4PostSignatureResponse createV4PostSignature(String acl, String contentType, long expires, String bucketName, String objectKey) throws ObsException {
        V4PostSignatureRequest request = new V4PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        request.getFormParams().put("acl", acl);
        request.getFormParams().put("content-type", contentType);
        return this.createV4PostSignature(request);
    }

    @Deprecated
    public V4PostSignatureResponse createV4PostSignature(long expires, String bucketName, String objectKey) throws ObsException {
        V4PostSignatureRequest request = new V4PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        return this.createV4PostSignature(request);
    }

    @Deprecated
    public V4PostSignatureResponse createV4PostSignature(V4PostSignatureRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "V4PostSignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createV4PostSignature", this.getEndpoint(), "");
        try {
            V4PostSignatureResponse response = (V4PostSignatureResponse)this._createPostSignature(request, true);
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            if (ILOG.isInfoEnabled()) {
                ILOG.info(reqBean);
            }
            return response;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Override
    public TemporarySignatureResponse createTemporarySignature(TemporarySignatureRequest request) {
        ServiceUtils.asserParameterNotNull(request, "TemporarySignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createTemporarySignature", this.getEndpoint(), "");
        try {
            TemporarySignatureResponse response = this.getProviderCredentials().getAuthType() == AuthTypeEnum.V4 ? this.createV4TemporarySignature(request) : this._createTemporarySignature(request);
            return response;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    public PostSignatureResponse createPostSignature(String acl, String contentType, long expires, String bucketName, String objectKey) throws ObsException {
        PostSignatureRequest request = new PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        request.getFormParams().put(this.getProviderCredentials().getAuthType() == AuthTypeEnum.V4 ? "acl" : this.getIHeaders().aclHeader(), acl);
        request.getFormParams().put("Content-Type", contentType);
        return this.createPostSignature(request);
    }

    public PostSignatureResponse createPostSignature(long expires, String bucketName, String objectKey) throws ObsException {
        PostSignatureRequest request = new PostSignatureRequest(expires, new Date(), bucketName, objectKey);
        return this.createPostSignature(request);
    }

    @Override
    public PostSignatureResponse createPostSignature(PostSignatureRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "PostSignatureRequest is null");
        InterfaceLogBean reqBean = new InterfaceLogBean("createPostSignature", this.getEndpoint(), "");
        try {
            PostSignatureResponse response = this._createPostSignature(request, this.getProviderCredentials().getAuthType() == AuthTypeEnum.V4);
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            if (ILOG.isInfoEnabled()) {
                ILOG.info(reqBean);
            }
            return response;
        }
        catch (Exception e) {
            reqBean.setRespTime(new Date());
            if (ILOG.isErrorEnabled()) {
                ILOG.error(reqBean);
            }
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Override
    public ObsBucket createBucket(String bucketName) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(String bucketName, String location) throws ObsException {
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucketName);
        obsBucket.setLocation(location);
        return this.createBucket(obsBucket);
    }

    @Override
    public ObsBucket createBucket(ObsBucket bucket) throws ObsException {
        CreateBucketRequest request = new CreateBucketRequest();
        request.setBucketName(bucket.getBucketName());
        request.setAcl(bucket.getAcl());
        request.setBucketStorageClass(bucket.getBucketStorageClass());
        request.setLocation(bucket.getLocation());
        return this.createBucket(request);
    }

    @Override
    public ObsBucket createBucket(final CreateBucketRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CreateBucketRequest is null");
        return this.doActionWithResult("createBucket", request.getBucketName(), new ActionCallbackWithResult<ObsBucket>(){

            @Override
            public ObsBucket action() throws ServiceException {
                if (ObsClient.this.isCname()) {
                    throw new ServiceException("createBucket is not allowed in customdomain mode");
                }
                return ObsClient.this.createBucketImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersionCache().getApiVersionInCache(bucketName);
                if (authTypeEnum == null) {
                    authTypeEnum = ObsClient.this.getApiVersion("");
                }
                ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
            }
        });
    }

    @Deprecated
    public ObsBucket createBucket(S3Bucket bucket) throws ObsException {
        ServiceUtils.asserParameterNotNull(bucket, "bucket is null");
        ObsBucket obsBucket = new ObsBucket();
        obsBucket.setBucketName(bucket.getBucketName());
        obsBucket.setLocation(bucket.getLocation());
        obsBucket.setAcl(bucket.getAcl());
        obsBucket.setMetadata(bucket.getMetadata());
        obsBucket.setBucketStorageClass(bucket.getBucketStorageClass());
        return this.createBucket(obsBucket);
    }

    @Deprecated
    public List<S3Bucket> listBuckets() throws ObsException {
        List<ObsBucket> ret = this.listBuckets(null);
        ArrayList<S3Bucket> buckets = new ArrayList<S3Bucket>(ret.size());
        buckets.addAll(ret);
        return buckets;
    }

    @Override
    public List<ObsBucket> listBuckets(ListBucketsRequest request) throws ObsException {
        return this.listBucketsV2(request).getBuckets();
    }

    @Override
    public ListBucketsResult listBucketsV2(final ListBucketsRequest request) throws ObsException {
        return this.doActionWithResult("listBuckets", "All Buckets", new ActionCallbackWithResult<ListBucketsResult>(){

            @Override
            public ListBucketsResult action() throws ServiceException {
                if (ObsClient.this.isCname()) {
                    throw new ServiceException("listBuckets is not allowed in customdomain mode");
                }
                return ObsClient.this.listAllBucketsImpl(request);
            }

            @Override
            void authTypeNegotiate(String bucketName) throws ServiceException {
                AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersion("");
                ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucket(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucket", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketImpl(bucketName);
            }
        });
    }

    @Override
    public ObjectListing listObjects(final ListObjectsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListObjectsRequest is null");
        return this.doActionWithResult("listObjects", request.getBucketName(), new ActionCallbackWithResult<ObjectListing>(){

            @Override
            public ObjectListing action() throws ServiceException {
                return ObsClient.this.listObjectsImpl(request);
            }
        });
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws ObsException {
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
        return this.listObjects(listObjectsRequest);
    }

    @Override
    public boolean headBucket(final String bucketName) throws ObsException {
        return this.doActionWithResult("headBucket", bucketName, new ActionCallbackWithResult<Boolean>(){

            @Override
            public Boolean action() throws ServiceException {
                return ObsClient.this.headBucketImpl(bucketName);
            }

            @Override
            void authTypeNegotiate(String bucketName2) throws ServiceException {
                block2: {
                    try {
                        AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersion(bucketName2);
                        ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
                    }
                    catch (ServiceException e) {
                        if (e.getResponseCode() == 404) break block2;
                        throw e;
                    }
                }
            }
        });
    }

    @Deprecated
    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String keyMarker, String versionIdMarker, long maxKeys, String nextVersionIdMarker) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        request.setPrefix(prefix);
        request.setKeyMarker(keyMarker);
        request.setMaxKeys((int)maxKeys);
        request.setVersionIdMarker(versionIdMarker);
        request.setDelimiter(delimiter);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(final ListVersionsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListVersionsRequest is null");
        return this.doActionWithResult("listVersions", request.getBucketName(), new ActionCallbackWithResult<ListVersionsResult>(){

            @Override
            public ListVersionsResult action() throws ServiceException {
                return ObsClient.this.listVersionsImpl(request);
            }
        });
    }

    @Override
    public ListVersionsResult listVersions(String bucketName) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, long maxKeys) throws ObsException {
        ListVersionsRequest request = new ListVersionsRequest();
        request.setBucketName(bucketName);
        request.setMaxKeys((int)maxKeys);
        return this.listVersions(request);
    }

    @Override
    public ListVersionsResult listVersions(String bucketName, String prefix, String delimiter, String keyMarker, String versionIdMarker, long maxKeys) throws ObsException {
        return this.listVersions(bucketName, prefix, delimiter, keyMarker, versionIdMarker, maxKeys, null);
    }

    @Override
    public BucketMetadataInfoResult getBucketMetadata(final BucketMetadataInfoRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "BucketMetadataInfoRequest is null");
        return this.doActionWithResult("getBucketMetadata", request.getBucketName(), new ActionCallbackWithResult<BucketMetadataInfoResult>(){

            @Override
            public BucketMetadataInfoResult action() throws ServiceException {
                return ObsClient.this.getBucketMetadataImpl(request);
            }
        });
    }

    @Override
    public AccessControlList getBucketAcl(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketAcl", bucketName, new ActionCallbackWithResult<AccessControlList>(){

            @Override
            public AccessControlList action() throws ServiceException {
                return ObsClient.this.getBucketAclImpl(bucketName);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketAcl(final String bucketName, final String cannedACL, final AccessControlList acl) throws ObsException {
        return this.doActionWithResult("setBucketAcl", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (acl == null && null == cannedACL) {
                    throw new IllegalArgumentException("Both CannedACL and AccessControlList is null");
                }
                return ObsClient.this.setBucketAclImpl(bucketName, cannedACL, acl);
            }
        });
    }

    @Override
    public HeaderResponse setBucketAcl(String bucketName, AccessControlList acl) throws ObsException {
        return this.setBucketAcl(bucketName, null, acl);
    }

    @Override
    public String getBucketLocation(String bucketName) throws ObsException {
        return this.getBucketLocationV2(bucketName).getLocation();
    }

    @Override
    public BucketLocationResponse getBucketLocationV2(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketLocation", bucketName, new ActionCallbackWithResult<BucketLocationResponse>(){

            @Override
            public BucketLocationResponse action() throws ServiceException {
                return ObsClient.this.getBucketLocationImpl(bucketName);
            }
        });
    }

    @Override
    public BucketStorageInfo getBucketStorageInfo(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketStorageInfo", bucketName, new ActionCallbackWithResult<BucketStorageInfo>(){

            @Override
            public BucketStorageInfo action() throws ServiceException {
                return ObsClient.this.getBucketStorageInfoImpl(bucketName);
            }
        });
    }

    @Override
    public BucketQuota getBucketQuota(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketQuota", bucketName, new ActionCallbackWithResult<BucketQuota>(){

            @Override
            public BucketQuota action() throws ServiceException {
                return ObsClient.this.getBucketQuotaImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse setBucketQuota(final String bucketName, final BucketQuota bucketQuota) throws ObsException {
        return this.doActionWithResult("setBucketQuota", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(bucketQuota, "The bucket '" + bucketName + "' does not include Quota information");
                return ObsClient.this.setBucketQuotaImpl(bucketName, bucketQuota);
            }
        });
    }

    @Override
    public BucketStoragePolicyConfiguration getBucketStoragePolicy(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketStoragePolicy", bucketName, new ActionCallbackWithResult<BucketStoragePolicyConfiguration>(){

            @Override
            public BucketStoragePolicyConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketStoragePolicyImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse setBucketStoragePolicy(final String bucketName, final BucketStoragePolicyConfiguration bucketStorage) throws ObsException {
        return this.doActionWithResult("setBucketStoragePolicy", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(bucketStorage, "The bucket '" + bucketName + "' does not include storagePolicy information");
                return ObsClient.this.setBucketStorageImpl(bucketName, bucketStorage);
            }
        });
    }

    @Override
    public HeaderResponse setBucketCors(final String bucketName, final BucketCors bucketCors) throws ObsException {
        return this.doActionWithResult("setBucketCors", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(bucketCors, "BucketCors is null");
                return ObsClient.this.setBucketCorsImpl(bucketName, bucketCors);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketCors(String bucketName, S3BucketCors s3BucketCors) throws ObsException {
        ServiceUtils.asserParameterNotNull(s3BucketCors, "The bucket '" + bucketName + "' does not include Cors information");
        BucketCors bucketCors = new BucketCors();
        bucketCors.setRules(s3BucketCors.getRules());
        return this.setBucketCors(bucketName, bucketCors);
    }

    @Override
    public BucketCors getBucketCors(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketCors", bucketName, new ActionCallbackWithResult<BucketCors>(){

            @Override
            public BucketCors action() throws ServiceException {
                return ObsClient.this.getBucketCorsImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketCors(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucketCors", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketCorsImpl(bucketName);
            }
        });
    }

    @Deprecated
    public OptionsInfoResult optionsBucket(final String bucketName, final OptionsInfoRequest optionInfo) throws ObsException {
        return this.doActionWithResult("optionsBucket", bucketName, new ActionCallbackWithResult<OptionsInfoResult>(){

            @Override
            public OptionsInfoResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(optionInfo, "OptionsInfoRequest is null");
                return ObsClient.this.optionsImpl(bucketName, null, optionInfo);
            }
        });
    }

    @Deprecated
    public OptionsInfoResult optionsObject(final String bucketName, final String objectKey, final OptionsInfoRequest optionInfo) throws ObsException {
        return this.doActionWithResult("optionsObject", bucketName, new ActionCallbackWithResult<OptionsInfoResult>(){

            @Override
            public OptionsInfoResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(optionInfo, "OptionsInfoRequest is null");
                return ObsClient.this.optionsImpl(bucketName, objectKey, optionInfo);
            }
        });
    }

    @Deprecated
    public BucketLoggingConfiguration getBucketLoggingConfiguration(String bucketName) throws ObsException {
        return this.getBucketLogging(bucketName);
    }

    @Override
    public BucketLoggingConfiguration getBucketLogging(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketLoggingConfiguration", bucketName, new ActionCallbackWithResult<BucketLoggingConfiguration>(){

            @Override
            public BucketLoggingConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketLoggingConfigurationImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse setBucketLoggingConfiguration(final String bucketName, final BucketLoggingConfiguration loggingConfiguration, final boolean updateTargetACLifRequired) throws ObsException {
        return this.doActionWithResult("setBucketLoggingConfiguration", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketLoggingConfigurationImpl(bucketName, loggingConfiguration == null ? new BucketLoggingConfiguration() : loggingConfiguration, updateTargetACLifRequired);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketLoggingConfiguration(String bucketName, BucketLoggingConfiguration loggingConfiguration) throws ObsException {
        return this.setBucketLogging(bucketName, loggingConfiguration);
    }

    @Override
    public HeaderResponse setBucketLogging(String bucketName, BucketLoggingConfiguration loggingConfiguration) throws ObsException {
        return this.setBucketLoggingConfiguration(bucketName, loggingConfiguration, false);
    }

    @Deprecated
    public HeaderResponse setBucketVersioning(String bucketName, String status) throws ObsException {
        return this.setBucketVersioning(bucketName, new BucketVersioningConfiguration(status));
    }

    @Override
    public HeaderResponse setBucketVersioning(final String bucketName, final BucketVersioningConfiguration versioningConfiguration) throws ObsException {
        return this.doActionWithResult("setBucketVersioning", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(versioningConfiguration, "BucketVersioningConfiguration is null");
                return ObsClient.this.setBucketVersioningImpl(bucketName, versioningConfiguration.getVersioningStatus());
            }
        });
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioning(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketVersioning", bucketName, new ActionCallbackWithResult<BucketVersioningConfiguration>(){

            @Override
            public BucketVersioningConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketVersioningImpl(bucketName);
            }
        });
    }

    @Deprecated
    public LifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) throws ObsException {
        return this.getBucketLifecycle(bucketName);
    }

    @Override
    public LifecycleConfiguration getBucketLifecycle(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketLifecycleConfiguration", bucketName, new ActionCallbackWithResult<LifecycleConfiguration>(){

            @Override
            public LifecycleConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketLifecycleConfigurationImpl(bucketName);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketLifecycleConfiguration(String bucketName, LifecycleConfiguration lifecycleConfig) throws ObsException {
        return this.setBucketLifecycle(bucketName, lifecycleConfig);
    }

    @Override
    public HeaderResponse setBucketLifecycle(final String bucketName, final LifecycleConfiguration lifecycleConfig) throws ObsException {
        return this.doActionWithResult("setBucketLifecycleConfiguration", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(lifecycleConfig, "LifecycleConfiguration is null");
                return ObsClient.this.setBucketLifecycleConfigurationImpl(bucketName, lifecycleConfig);
            }
        });
    }

    @Deprecated
    public HeaderResponse deleteBucketLifecycleConfiguration(String bucketName) throws ObsException {
        return this.deleteBucketLifecycle(bucketName);
    }

    @Override
    public HeaderResponse deleteBucketLifecycle(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucketLifecycleConfiguration", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketLifecycleConfigurationImpl(bucketName);
            }
        });
    }

    @Override
    public String getBucketPolicy(String bucketName) throws ObsException {
        return this.getBucketPolicyV2(bucketName).getPolicy();
    }

    @Override
    public BucketPolicyResponse getBucketPolicyV2(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketPolicy", bucketName, new ActionCallbackWithResult<BucketPolicyResponse>(){

            @Override
            public BucketPolicyResponse action() throws ServiceException {
                return ObsClient.this.getBucketPolicyImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse setBucketPolicy(final String bucketName, final String policy) throws ObsException {
        return this.doActionWithResult("setBucketPolicy", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(policy, "policy is null");
                return ObsClient.this.setBucketPolicyImpl(bucketName, policy);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketPolicy(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucketPolicy", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketPolicyImpl(bucketName);
            }
        });
    }

    @Deprecated
    public WebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws ObsException {
        return this.getBucketWebsite(bucketName);
    }

    @Override
    public WebsiteConfiguration getBucketWebsite(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketWebsiteConfiguration", bucketName, new ActionCallbackWithResult<WebsiteConfiguration>(){

            @Override
            public WebsiteConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketWebsiteConfigurationImpl(bucketName);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketWebsiteConfiguration(String bucketName, WebsiteConfiguration websiteConfig) throws ObsException {
        return this.setBucketWebsite(bucketName, websiteConfig);
    }

    @Override
    public HeaderResponse setBucketWebsite(final String bucketName, final WebsiteConfiguration websiteConfig) throws ObsException {
        return this.doActionWithResult("setBucketWebsiteConfiguration", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(websiteConfig, "WebsiteConfiguration is null");
                return ObsClient.this.setBucketWebsiteConfigurationImpl(bucketName, websiteConfig);
            }
        });
    }

    @Deprecated
    public HeaderResponse deleteBucketWebsiteConfiguration(String bucketName) throws ObsException {
        return this.deleteBucketWebsite(bucketName);
    }

    @Override
    public HeaderResponse deleteBucketWebsite(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucketWebsiteConfiguration", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketWebsiteConfigurationImpl(bucketName);
            }
        });
    }

    @Override
    public BucketTagInfo getBucketTagging(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketTagging", bucketName, new ActionCallbackWithResult<BucketTagInfo>(){

            @Override
            public BucketTagInfo action() throws ServiceException {
                return ObsClient.this.getBucketTaggingImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse setBucketTagging(final String bucketName, final BucketTagInfo bucketTagInfo) throws ObsException {
        return this.doActionWithResult("setBucketTagging", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(bucketTagInfo, "BucketTagInfo is null");
                return ObsClient.this.setBucketTaggingImpl(bucketName, bucketTagInfo);
            }
        });
    }

    @Override
    public HeaderResponse deleteBucketTagging(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucketTagging", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketTaggingImpl(bucketName);
            }
        });
    }

    @Deprecated
    public HeaderResponse setBucketReplicationConfiguration(String bucketName, ReplicationConfiguration replicationConfiguration) throws ObsException {
        return this.setBucketReplication(bucketName, replicationConfiguration);
    }

    @Override
    public HeaderResponse setBucketReplication(final String bucketName, final ReplicationConfiguration replicationConfiguration) throws ObsException {
        return this.doActionWithResult("setBucketReplication", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                ServiceUtils.asserParameterNotNull(replicationConfiguration, "ReplicationConfiguration is null");
                return ObsClient.this.setBucketReplicationConfigurationImpl(bucketName, replicationConfiguration);
            }
        });
    }

    @Deprecated
    public ReplicationConfiguration getBucketReplicationConfiguration(String bucketName) throws ObsException {
        return this.getBucketReplication(bucketName);
    }

    @Override
    public ReplicationConfiguration getBucketReplication(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketReplicationConfiguration", bucketName, new ActionCallbackWithResult<ReplicationConfiguration>(){

            @Override
            public ReplicationConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketReplicationConfigurationImpl(bucketName);
            }
        });
    }

    @Deprecated
    public HeaderResponse deleteBucketReplicationConfiguration(String bucketName) throws ObsException {
        return this.deleteBucketReplication(bucketName);
    }

    @Override
    public HeaderResponse deleteBucketReplication(final String bucketName) throws ObsException {
        return this.doActionWithResult("deleteBucketReplicationConfiguration", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.deleteBucketReplicationConfigurationImpl(bucketName);
            }
        });
    }

    @Override
    public BucketNotificationConfiguration getBucketNotification(final String bucketName) throws ObsException {
        return this.doActionWithResult("getBucketNotification", bucketName, new ActionCallbackWithResult<BucketNotificationConfiguration>(){

            @Override
            public BucketNotificationConfiguration action() throws ServiceException {
                return ObsClient.this.getBucketNotificationConfigurationImpl(bucketName);
            }
        });
    }

    @Override
    public HeaderResponse setBucketNotification(final String bucketName, final BucketNotificationConfiguration bucketNotificationConfiguration) throws ObsException {
        return this.doActionWithResult("setBucketNotification", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketNotificationImpl(bucketName, bucketNotificationConfiguration == null ? new BucketNotificationConfiguration() : bucketNotificationConfiguration);
            }
        });
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, InputStream input, ObjectMetadata metadata) throws ObsException {
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setInput(input);
        request.setMetadata(metadata);
        request.setObjectKey(objectKey);
        return this.putObject(request);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, InputStream input) throws ObsException {
        return this.putObject(bucketName, objectKey, input, null);
    }

    @Override
    public PutObjectResult putObject(final PutObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "PutObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("putObject", request.getBucketName(), new ActionCallbackWithResult<PutObjectResult>(){

            @Override
            public PutObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.putObjectImpl(request);
            }
        });
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, File file) throws ObsException {
        return this.putObject(bucketName, objectKey, file, null);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String objectKey, File file, ObjectMetadata metadata) throws ObsException {
        PutObjectRequest request = new PutObjectRequest();
        request.setBucketName(bucketName);
        request.setFile(file);
        request.setObjectKey(objectKey);
        request.setMetadata(metadata);
        return this.putObject(request);
    }

    @Override
    public AppendObjectResult appendObject(final AppendObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "AppendObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("appendObject", request.getBucketName(), new ActionCallbackWithResult<AppendObjectResult>(){

            @Override
            public AppendObjectResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.appendObjectImpl(request);
            }
        });
    }

    @Override
    public CompleteMultipartUploadResult uploadFile(UploadFileRequest uploadFileRequest) throws ObsException {
        return new ResumableClient(this).uploadFileResume(uploadFileRequest);
    }

    @Override
    public DownloadFileResult downloadFile(DownloadFileRequest downloadFileRequest) throws ObsException {
        return new ResumableClient(this).downloadFileResume(downloadFileRequest);
    }

    @Override
    public ObsObject getObject(final GetObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetObjectRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObject", request.getBucketName(), new ActionCallbackWithResult<ObsObject>(){

            @Override
            public ObsObject action() throws ServiceException {
                return ObsClient.this.getObjectImpl(request);
            }
        });
    }

    @Override
    public ObsObject getObject(String bucketName, String objectKey, String versionId) throws ObsException {
        return this.getObject(new GetObjectRequest(bucketName, objectKey, versionId));
    }

    @Override
    public ObsObject getObject(String bucketName, String objectKey) throws ObsException {
        return this.getObject(bucketName, objectKey, null);
    }

    @Override
    public ObjectMetadata getObjectMetadata(final GetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetObjectMetadataRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("getObjectMetadata", request.getBucketName(), new ActionCallbackWithResult<ObjectMetadata>(){

            @Override
            public ObjectMetadata action() throws ServiceException {
                return ObsClient.this.getObjectMetadataImpl(request);
            }
        });
    }

    @Override
    public ObjectMetadata setObjectMetadata(final SetObjectMetadataRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetObjectMetadataRequest is null");
        return this.doActionWithResult("setObjectMetadata", request.getBucketName(), new ActionCallbackWithResult<ObjectMetadata>(){

            @Override
            public ObjectMetadata action() throws ServiceException {
                return ObsClient.this.setObjectMetadataImpl(request);
            }
        });
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey, String versionId) throws ObsException {
        GetObjectMetadataRequest request = new GetObjectMetadataRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setVersionId(versionId);
        return this.getObjectMetadata(request);
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String objectKey) throws ObsException {
        return this.getObjectMetadata(bucketName, objectKey, null);
    }

    @Override
    @Deprecated
    public RestoreObjectRequest.RestoreObjectStatus restoreObject(final RestoreObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RestoreObjectRequest is null");
        return this.doActionWithResult("restoreObject", request.getBucketName(), new ActionCallbackWithResult<RestoreObjectRequest.RestoreObjectStatus>(){

            @Override
            public RestoreObjectRequest.RestoreObjectStatus action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return ObsClient.this.restoreObjectImpl(request);
            }
        });
    }

    @Override
    public RestoreObjectResult restoreObjectV2(final RestoreObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RestoreObjectRequest is null");
        return this.doActionWithResult("restoreObjectV2", request.getBucketName(), new ActionCallbackWithResult<RestoreObjectResult>(){

            @Override
            public RestoreObjectResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
                return ObsClient.this.restoreObjectV2Impl(request);
            }
        });
    }

    @Override
    public void restoreObjects(RestoreObjectsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RestoreObjectsRequest is null");
        if (!this.isCname()) {
            ServiceUtils.asserParameterNotNull(request.getBucketName(), "bucketName is null");
        }
        if (request.getKeyAndVersions() != null && request.getPrefix() != null) {
            throw new IllegalArgumentException("Prefix and keyandVersions cannot coexist in the same request");
        }
        int days = request.getDays();
        if (days < 1 || days > 30) {
            throw new IllegalArgumentException("Restoration days should be at least 1 and at most 30");
        }
        int taskThreadNum = request.getTaskThreadNum();
        int workQueenLength = request.getTaskQueueNum();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(taskThreadNum, taskThreadNum, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(workQueenLength));
        executor.setRejectedExecutionHandler(new BlockRejectedExecutionHandler());
        try {
            String bucketName = request.getBucketName();
            String prefix = request.getPrefix();
            RestoreTierEnum tier = request.getRestoreTier();
            boolean versionRestored = request.isVersionRestored();
            BlankTaksCallback<RestoreObjectResult, RestoreObjectRequest> callback = request.getCallback() == null ? new BlankTaksCallback() : request.getCallback();
            TaskProgressListener listener = request.getProgressListener();
            DefaultTaskProgressStatus progreStatus = listener == null ? new BlankTaskProgressStatus() : new DefaultTaskProgressStatus();
            int progressIntenal = request.getProgressInterval();
            int totalTaskNum = 0;
            if (request.getKeyAndVersions() != null) {
                totalTaskNum = request.getKeyAndVersions().size();
                for (KeyAndVersion kv : request.getKeyAndVersions()) {
                    RestoreObjectRequest taskRequest = new RestoreObjectRequest(bucketName, kv.getKey(), kv.getVersion(), days, tier);
                    RestoreObjectTask task = new RestoreObjectTask(this, bucketName, taskRequest, callback, listener, progreStatus, progressIntenal);
                    executor.execute(task);
                }
            } else if (versionRestored) {
                ListVersionsResult versionResult;
                ListVersionsRequest listRequest = new ListVersionsRequest(bucketName);
                listRequest.setPrefix(prefix);
                do {
                    versionResult = this.listVersions(listRequest);
                    for (VersionOrDeleteMarker v : versionResult.getVersions()) {
                        if (v.getObjectStorageClass() != StorageClassEnum.COLD) continue;
                        RestoreObjectRequest taskRequest = new RestoreObjectRequest(bucketName, v.getKey(), v.getVersionId(), days, tier);
                        RestoreObjectTask task = new RestoreObjectTask(this, bucketName, taskRequest, callback, listener, progreStatus, progressIntenal);
                        executor.execute(task);
                        if (!ILOG.isInfoEnabled() || ++totalTaskNum % 1000 != 0) continue;
                        ILOG.info("RestoreObjects: " + totalTaskNum + " tasks have submitted to be restored");
                    }
                    listRequest.setKeyMarker(versionResult.getNextKeyMarker());
                    listRequest.setVersionIdMarker(versionResult.getNextVersionIdMarker());
                } while (versionResult.isTruncated());
            } else {
                ObjectListing objectsResult;
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest(bucketName);
                listObjectsRequest.setPrefix(prefix);
                do {
                    objectsResult = this.listObjects(listObjectsRequest);
                    for (ObsObject o : objectsResult.getObjects()) {
                        if (o.getMetadata().getObjectStorageClass() != StorageClassEnum.COLD) continue;
                        RestoreObjectRequest taskRequest = new RestoreObjectRequest(bucketName, o.getObjectKey(), null, days, tier);
                        RestoreObjectTask task = new RestoreObjectTask(this, bucketName, taskRequest, callback, listener, progreStatus, progressIntenal);
                        executor.execute(task);
                        if (!ILOG.isInfoEnabled() || ++totalTaskNum % 1000 != 0) continue;
                        ILOG.info("RestoreObjects: " + totalTaskNum + " tasks have submitted to be restored");
                    }
                    listObjectsRequest.setMarker(objectsResult.getNextMarker());
                } while (objectsResult.isTruncated());
            }
            progreStatus.setTotalTaskNum(totalTaskNum);
            executor.shutdown();
            executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (ObsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ObsException(e.getMessage(), e);
        }
    }

    @Override
    public DeleteObjectResult deleteObject(final String bucketName, final String objectKey, final String versionId) throws ObsException {
        return this.doActionWithResult("deleteObject", bucketName, new ActionCallbackWithResult<DeleteObjectResult>(){

            @Override
            public DeleteObjectResult action() throws ServiceException {
                ServiceUtils.asserParameterNotNull2(objectKey, "objectKey is null");
                return ObsClient.this.deleteObjectImpl(bucketName, objectKey, versionId);
            }
        });
    }

    @Override
    public DeleteObjectResult deleteObject(String bucketName, String objectKey) throws ObsException {
        return this.deleteObject(bucketName, objectKey, null);
    }

    @Override
    public DeleteObjectsResult deleteObjects(final DeleteObjectsRequest deleteObjectsRequest) throws ObsException {
        ServiceUtils.asserParameterNotNull(deleteObjectsRequest, "DeleteObjectsRequest is null");
        return this.doActionWithResult("deleteObjects", deleteObjectsRequest.getBucketName(), new ActionCallbackWithResult<DeleteObjectsResult>(){

            @Override
            public DeleteObjectsResult action() throws ServiceException {
                return ObsClient.this.deleteObjectsImpl(deleteObjectsRequest);
            }
        });
    }

    @Override
    public AccessControlList getObjectAcl(final String bucketName, final String objectKey, final String versionId) throws ObsException {
        ServiceUtils.asserParameterNotNull2(objectKey, "objectKey is null");
        return this.doActionWithResult("getObjectAcl", bucketName, new ActionCallbackWithResult<AccessControlList>(){

            @Override
            public AccessControlList action() throws ServiceException {
                return ObsClient.this.getObjectAclImpl(bucketName, objectKey, versionId);
            }
        });
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String objectKey) throws ObsException {
        return this.getObjectAcl(bucketName, objectKey, null);
    }

    @Deprecated
    public HeaderResponse setObjectAcl(final String bucketName, final String objectKey, final String cannedACL, final AccessControlList acl, final String versionId) throws ObsException {
        return this.doActionWithResult("setObjectAcl", bucketName, new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                if (acl == null && null == cannedACL) {
                    throw new IllegalArgumentException("Both cannedACL and AccessControlList is null");
                }
                return ObsClient.this.setObjectAclImpl(bucketName, objectKey, cannedACL, acl, versionId);
            }
        });
    }

    @Override
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, AccessControlList acl, String versionId) throws ObsException {
        return this.setObjectAcl(bucketName, objectKey, null, acl, versionId);
    }

    @Override
    public HeaderResponse setObjectAcl(String bucketName, String objectKey, AccessControlList acl) throws ObsException {
        return this.setObjectAcl(bucketName, objectKey, null, acl, null);
    }

    @Override
    public CopyObjectResult copyObject(final CopyObjectRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CopyObjectRequest is null");
        ServiceUtils.asserParameterNotNull(request.getDestinationBucketName(), "destinationBucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getSourceObjectKey(), "sourceObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getDestinationObjectKey(), "destinationObjectKey is null");
        return this.doActionWithResult("copyObject", request.getSourceBucketName(), new ActionCallbackWithResult<CopyObjectResult>(){

            @Override
            public CopyObjectResult action() throws ServiceException {
                return ObsClient.this.copyObjectImpl(request);
            }
        });
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceObjectKey, String destBucketName, String destObjectKey) throws ObsException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceObjectKey, destBucketName, destObjectKey));
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(final InitiateMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "InitiateMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        return this.doActionWithResult("initiateMultipartUpload", request.getBucketName(), new ActionCallbackWithResult<InitiateMultipartUploadResult>(){

            @Override
            public InitiateMultipartUploadResult action() throws ServiceException {
                return ObsClient.this.initiateMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse abortMultipartUpload(final AbortMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "AbortMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("abortMultipartUpload", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.abortMultipartUploadImpl(request.getUploadId(), request.getBucketName(), request.getObjectKey());
            }
        });
    }

    @Override
    public UploadPartResult uploadPart(String bucketName, String objectKey, String uploadId, int partNumber, InputStream input) throws ObsException {
        UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(partNumber);
        request.setInput(input);
        return this.uploadPart(request);
    }

    @Override
    public UploadPartResult uploadPart(String bucketName, String objectKey, String uploadId, int partNumber, File file) throws ObsException {
        UploadPartRequest request = new UploadPartRequest();
        request.setBucketName(bucketName);
        request.setObjectKey(objectKey);
        request.setUploadId(uploadId);
        request.setPartNumber(partNumber);
        request.setFile(file);
        return this.uploadPart(request);
    }

    @Override
    public UploadPartResult uploadPart(final UploadPartRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "UploadPartRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("uploadPart", request.getBucketName(), new ActionCallbackWithResult<UploadPartResult>(){

            @Override
            public UploadPartResult action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.uploadPartImpl(request);
            }
        });
    }

    @Override
    public CopyPartResult copyPart(final CopyPartRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CopyPartRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getSourceObjectKey(), "sourceObjectKey is null");
        ServiceUtils.asserParameterNotNull(request.getDestinationBucketName(), "destinationBucketName is null");
        ServiceUtils.asserParameterNotNull2(request.getDestinationObjectKey(), "destinationObjectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("copyPart", request.getSourceBucketName(), new ActionCallbackWithResult<CopyPartResult>(){

            @Override
            public CopyPartResult action() throws ServiceException {
                return ObsClient.this.copyPartImpl(request);
            }
        });
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(final CompleteMultipartUploadRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CompleteMultipartUploadRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("completeMultipartUpload", request.getBucketName(), new ActionCallbackWithResult<CompleteMultipartUploadResult>(){

            @Override
            public CompleteMultipartUploadResult action() throws ServiceException {
                return ObsClient.this.completeMultipartUploadImpl(request);
            }
        });
    }

    @Override
    public ListPartsResult listParts(final ListPartsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListPartsRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getKey(), "objectKey is null");
        ServiceUtils.asserParameterNotNull(request.getUploadId(), "uploadId is null");
        return this.doActionWithResult("listParts", request.getBucketName(), new ActionCallbackWithResult<ListPartsResult>(){

            @Override
            public ListPartsResult action() throws ServiceException {
                return ObsClient.this.listPartsImpl(request);
            }
        });
    }

    @Override
    public MultipartUploadListing listMultipartUploads(final ListMultipartUploadsRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "ListMultipartUploadsRequest is null");
        return this.doActionWithResult("listMultipartUploads", request.getBucketName(), new ActionCallbackWithResult<MultipartUploadListing>(){

            @Override
            public MultipartUploadListing action() throws ServiceException {
                return ObsClient.this.listMultipartUploadsImpl(request);
            }
        });
    }

    @Override
    public ObsFSBucket newBucket(NewBucketRequest request) throws ObsException {
        ObsBucket bucket = this.createBucket(request);
        ObsFSBucket fsBucket = new ObsFSBucket(bucket.getBucketName(), bucket.getLocation());
        ReflectUtils.setInnerClient(fsBucket, this);
        return fsBucket;
    }

    @Override
    public ObsFSFile newFile(NewFileRequest request) throws ObsException {
        ObsFSFile obsFile = (ObsFSFile)this.putObject(request);
        ReflectUtils.setInnerClient(obsFile, this);
        return obsFile;
    }

    @Override
    public ObsFSFolder newFolder(NewFolderRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "CreateFolderRequest is null");
        if (request.getObjectKey() != null) {
            String delimiter = this.getFileSystemDelimiter();
            if (!request.getObjectKey().endsWith(delimiter)) {
                request.setObjectKey(request.getObjectKey() + delimiter);
            }
        }
        ObsFSFolder obsFolder = (ObsFSFolder)this.putObject(new PutObjectRequest(request));
        ReflectUtils.setInnerClient(obsFolder, this);
        return obsFolder;
    }

    @Override
    public ObsFSAttribute getAttribute(GetAttributeRequest request) throws ObsException {
        return (ObsFSAttribute)this.getObjectMetadata(request);
    }

    @Override
    public ReadFileResult readFile(ReadFileRequest request) throws ObsException {
        return (ReadFileResult)this.getObject(request);
    }

    @Override
    public ObsFSFile writeFile(final WriteFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "WriteFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ObsFSFile obsFile = this.doActionWithResult("writeFile", request.getBucketName(), new ActionCallbackWithResult<ObsFSFile>(){

            @Override
            public ObsFSFile action() throws ServiceException {
                if (null != request.getInput() && null != request.getFile()) {
                    throw new ServiceException("Both input and file are set, only one is allowed");
                }
                return ObsClient.this.writeFileImpl(request);
            }
        });
        ReflectUtils.setInnerClient(obsFile, this);
        return obsFile;
    }

    @Override
    public ObsFSFile appendFile(WriteFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "WriteFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "objectKey is null");
        ObjectMetadata metadata = this.getObjectMetadata(new GetObjectMetadataRequest(request.getBucketName(), request.getObjectKey()));
        request.setPosition(metadata.getNextPosition());
        return this.writeFile(request);
    }

    @Override
    public RenameResult renameFile(final RenameRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "RenameRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        ServiceUtils.asserParameterNotNull2(request.getNewObjectKey(), "NewObjectKey is null");
        return this.doActionWithResult("rename", request.getBucketName(), new ActionCallbackWithResult<RenameResult>(){

            @Override
            public RenameResult action() throws ServiceException {
                return ObsClient.this.renameObjectImpl(request);
            }
        });
    }

    @Override
    public RenameResult renameFolder(RenameRequest request) throws ObsException {
        if (request != null && request.getObjectKey() != null && request.getNewObjectKey() != null) {
            String delimiter = this.getFileSystemDelimiter();
            if (!request.getObjectKey().endsWith(delimiter)) {
                request.setObjectKey(request.getObjectKey() + delimiter);
            }
            if (!request.getNewObjectKey().endsWith(delimiter)) {
                request.setNewObjectKey(request.getNewObjectKey() + delimiter);
            }
        }
        return this.renameFile(request);
    }

    @Override
    public TruncateFileResult truncateFile(final TruncateFileRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "TruncateFileRequest is null");
        ServiceUtils.asserParameterNotNull2(request.getObjectKey(), "ObjectKey is null");
        return this.doActionWithResult("truncateFile", request.getBucketName(), new ActionCallbackWithResult<TruncateFileResult>(){

            @Override
            public TruncateFileResult action() throws ServiceException {
                return ObsClient.this.truncateFileImpl(request);
            }
        });
    }

    @Override
    public HeaderResponse setBucketFSStatus(final SetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "SetBucketFileInterfaceRequest is null");
        return this.doActionWithResult("setBucketFSStatus", request.getBucketName(), new ActionCallbackWithResult<HeaderResponse>(){

            @Override
            public HeaderResponse action() throws ServiceException {
                return ObsClient.this.setBucketFSStatusImpl(request);
            }
        });
    }

    @Override
    public GetBucketFSStatusResult getBucketFSStatus(final GetBucketFSStatusRequest request) throws ObsException {
        ServiceUtils.asserParameterNotNull(request, "GetBucketFSStatusRequest is null");
        return this.doActionWithResult("getBucketFSStatus", request.getBucketName(), new ActionCallbackWithResult<GetBucketFSStatusResult>(){

            @Override
            public GetBucketFSStatusResult action() throws ServiceException {
                return ObsClient.this.getBucketMetadataImpl(request);
            }
        });
    }

    private <T> T doActionWithResult(String action, String bucketName, ActionCallbackWithResult<T> callback) throws ObsException {
        if (!this.isCname()) {
            ServiceUtils.asserParameterNotNull(bucketName, "bucketName is null");
        }
        InterfaceLogBean reqBean = new InterfaceLogBean(action, this.getEndpoint(), "");
        try {
            long start = System.currentTimeMillis();
            if (this.isAuthTypeNegotiation()) {
                callback.authTypeNegotiate(bucketName);
            }
            T ret = callback.action();
            reqBean.setRespTime(new Date());
            reqBean.setResultCode("0");
            if (ILOG.isInfoEnabled()) {
                ILOG.info(reqBean);
            }
            if (ILOG.isInfoEnabled()) {
                ILOG.info("ObsClient [" + action + "] cost " + (System.currentTimeMillis() - start) + " ms");
            }
            T t = ret;
            return t;
        }
        catch (ServiceException e) {
            ObsException ex = ServiceUtils.changeFromServiceException(e);
            if (ex.getResponseCode() >= 400 && ex.getResponseCode() < 500) {
                if (ILOG.isWarnEnabled()) {
                    reqBean.setRespTime(new Date());
                    reqBean.setResultCode(String.valueOf(e.getResponseCode()));
                    ILOG.warn(reqBean);
                }
            } else if (ILOG.isErrorEnabled()) {
                reqBean.setRespTime(new Date());
                reqBean.setResultCode(String.valueOf(ex.getResponseCode()));
                ILOG.error(reqBean);
            }
            throw ex;
        }
        finally {
            if (this.isAuthTypeNegotiation()) {
                this.getProviderCredentials().removeThreadLocalAuthType();
            }
            AccessLoggerUtils.printLog();
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public String base64Md5(InputStream is, long length, long offset) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(is, length, offset));
    }

    public String base64Md5(InputStream is) throws NoSuchAlgorithmException, IOException {
        return ServiceUtils.toBase64(ServiceUtils.computeMD5Hash(is));
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private abstract class ActionCallbackWithResult<T> {
        private ActionCallbackWithResult() {
        }

        abstract T action() throws ServiceException;

        void authTypeNegotiate(String bucketName) throws ServiceException {
            AuthTypeEnum authTypeEnum = ObsClient.this.getApiVersion(bucketName);
            ObsClient.this.getProviderCredentials().setThreadLocalAuthType(authTypeEnum);
        }
    }
}

