/*
 * Copyright (C)2009 - SSHJ Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;

/**
 * Simple class holding the data for DH group key exchanges.
 */
public final class DHGroupData {

    public static final BigInteger G =
            new BigInteger("2");

    /**
     * First Oakley Group (https://tools.ietf.org/html/rfc2409) - P1
     * prime: 2^768 - 2 ^704 - 1 + 2^64 * { [2^638 pi] + 149686 }
     */
    public static final BigInteger P1 =
            new BigInteger("1797693134862315907708391567937874531978602960487560117064444236841971802161585193" +
                    "6894783379586492554150218056548598050364644054819923910005079287700335581663922955" +
                    "3136239076508735759914822574862575007425302077447712589550957937778424442426617334" +
                    "727629299387668709205606050270810842907692932019128194467627007");

    /**
     * 2048-bit MODP Group - P14 (https://tools.ietf.org/html/rfc3526#section-3)
     * prime: 2^2048 - 2^1984 - 1 + 2^64 * { [2^1918 pi] + 124476 }
     */
    public static final BigInteger P14 =
            new BigInteger("3231700607131100730033891392642382824881794124114023911284200975140074170663435422" +
                    "2619689417363569347117901737909704191754605873209195028853758986185622153212175412" +
                    "5149017745202702357960782362488842461894775876411059286460994117232454266225221932" +
                    "3054091903768052423551912567971587011700105805587765103886184728025797605490356973" +
                    "2561526167081339361799541336476559160368317896729073178384589680639671900977202194" +
                    "1686472258710314113364293195361934716365332097170774482279885885653692086452966360" +
                    "7725026895550592836275112117409697299806841055435958486658329164213621823107899099" +
                    "9448652468262416972035911852507045361090559");

    /**
     * 3072-bit MODP Group - P15 (https://tools.ietf.org/html/rfc3526#section-4)
     * prime: 2^3072 - 2^3008 - 1 + 2^64 * { [2^2942 pi] + 1690314 }
     */
    public static final BigInteger P15 =
            new BigInteger("5809605995369958062791915965639201402176612226902900533702900882779736177890990861" +
                    "4720947744773395811473734101856463783280437298007504700982109244878669350591643715" +
                    "8816804754094398164451663275506750162643455639819318662899007124866081936120511979" +
                    "3693985433297036118232914410171876807536457391277857011849897410207519105333355801" +
                    "1211093568974594262718454713979526759594407934930716283941227805101246184882326024" +
                    "6464987685045886124578424092925842628769970531258450962541951346360515542801716571" +
                    "4465363094021609290561084025893662561222573202082865797821865270991145082200656978" +
                    "1771928270245389902399691755461907706456858934380117144304264093386763147435711545" +
                    "3714203157300427642870143303638180170530865983075119035294602548205993130657100472" +
                    "7362479688415574702596946457770284148435989129632853918392117997472632693078113129" +
                    "8864873993477969827727846158652326212896569442842168246113187097645351525073541163" +
                    "44703769998514148343807");

    /**
     * 4096-bit MODP Group - P16 (https://tools.ietf.org/html/rfc3526#section-5)
     * prime: 2^4096 - 2^4032 - 1 + 2^64 * { [2^3966 pi] + 240904 }
     */
    public static final BigInteger P16 =
            new BigInteger("10443888814131525066796027198465295458312690609921350090225887564443381720223226907" +
                    "10444046669809783930111585737890362691860127079270495454517218673016928427459146001" +
                    "86688577976298222932119236830334623520436805101030915567415569746034717694639407653" +
                    "51572849948952848216337009218117167389724518349794558970103063334685907513583651387" +
                    "82250372269117968985194322444535687415522007151638638141456178420621277822674995027" +
                    "99027867345862954439173691976629900551150544617766815444623488266596168079657690319" +
                    "91160893476349471877789065280080047566925716669229641225661745827767073324523710012" +
                    "72163776841229318324903125740713574141005124561965913888899753461735347970011693256" +
                    "31675166067895083002751025580484610558346505544661509044430958305077580850929704003" +
                    "96800574353422539265662408981958636315888889363641299200593084556694540340103914782" +
                    "38784189888594672336242763795138176353222845524644040094258962433613354036104643881" +
                    "92523848922401019419308891166616558422942466816544168892779046060826486420423771700" +
                    "20547443379889419746612146996897065215430062626045358909981257522759426087721743761" +
                    "07314217749233048217904944409836238235772306749874396760463376480215133461333478395" +
                    "682746608242585133953883882226786118030184028136755970045385534758453247");

    /**
     * 6144-bit MODP Group - P17 (https://tools.ietf.org/html/rfc3526#section-6)
     * prime: 2^6144 - 2^6080 - 1 + 2^64 * { [2^6014 pi] + 929484 }
     */
    public static final BigInteger P17 =
            new BigInteger("3375152182143856118451852315996741233006489780574184654817389047442942990132667244" +
                    "5203235101919165483964194359460994881062089387893762814044257438204432573941083014" +
                    "8270060902589258751610180963277323358005958319159760142088223040073278481327349332" +
                    "9788580321367526156496260334045722077682632250005809131096725397661997398803366366" +
                    "6385188155212656268079501726223369693427999804134467810120772356498596945532366527" +
                    "4005175754719693358549052745041195095923660137119541482588848792245999152034563158" +
                    "8103477655308367699571833559858639559116999957082451503501754353335269752528775333" +
                    "2500527176569576894926734950469293596134095086603716860086302051544539652689091299" +
                    "0997845889190523834630577894405654606814419024423999564190605216296046973478790246" +
                    "5431380018607831652696452928806274087901103517592005919217856147319900620589671943" +
                    "5014765345518490882366607110905303449152556221163232127426440691921134648766635695" +
                    "8502392313045917442156109850296368954067188807663082492273159842675422662594896843" +
                    "7222391644541101590050623941926790971632033120898897818086898743162371034761799235" +
                    "6201449023892203230133009421463914291201346063125219636964261683591541014344239275" +
                    "3407356909977322220697587739633908763605465157552805170421605254873028981223116697" +
                    "9967944753045360039934269703271445854959128593945394903498124811432232236723864504" +
                    "2515984447890788917823576330019151696568654314153058547592091366014550143819685170" +
                    "0683437001046776090411663697600809334136054989623820777788455998349074759534307874" +
                    "4620138456732853067527579296235488377080690082718368571835346957473168052062194454" +
                    "0947734619035177180057973022652571032196598229259194875709994709721793154158686515" +
                    "7485072742241813169487971046010682120152329216914824963468544136987197501906011027" +
                    "0527448105054323981513068607360107630451228454921845984604608225359676243382741906" +
                    "0089029417044871218316020923109988915707117567");

    /**
     * 8192-bit MODP Group - P18 (https://tools.ietf.org/html/rfc3526#section-7)
     * prime: 2^8192 - 2^8128 - 1 + 2^64 * { [2^8062 pi] + 4743158 }
     */
    public static final BigInteger P18 =
            new BigInteger("10907481356194159294502949293597845003481551249531722117741011069661501689227856390" +
                    "28532473848836817769712164169076432969224698752674677662739994265785437233596157045" +
                    "97092233804069810050786103304731233182398243527947570019986097161273254052879655450" +
                    "28679197467769837593914759871425213158787195775191488118308799194269399584870875409" +
                    "65716419167467499326156226529675209172277001377591248147563782880558861083327174154" +
                    "01497513489312511601577631889029596069801161415772128252753946881651931933333750311" +
                    "47771923604122817210189558343776154804684792527488673203623853555966017951228067562" +
                    "17713579819870634321561907813255153703950795271232652404894983869492174481652303803" +
                    "49888136621050864726366837651413103110233683748899977574404673365182723939535354034" +
                    "84148728546397192946943234501868841898225445406472269872921606931847346549419069366" +
                    "46576130260972193280317171696418971553954161446191759093719524951116705577362073481" +
                    "31929604120128351615426904438925772770028968411946028348045230620413002491387998113" +
                    "59080269838682059693181678196808509986496944169079527129049624049377757896989172073" +
                    "56355227455066183815847669135530549755439819480321732925869069136146085326382334628" +
                    "74545639807160305805163420938670870330654590319960852382451372962513665912822110096" +
                    "77354505199524042481982628138310973742616503800172779169753241348465746813073370173" +
                    "80830353680623216336949471306191686438249305686413380231046096450953594089375540285" +
                    "03729247092939511402830554745258496207430943815182543790297601289174935519867842060" +
                    "37220349003113648930464957614043339386861400378480309162925432736845336400326376391" +
                    "00774502371542479302473698388692892420946478947733800387782741417786484770190108867" +
                    "87977899163321862864053398261932246615488301145229189025233648723608665439609385389" +
                    "86288058131775591620763631544364944775078712941198416378677017221666098312018454840" +
                    "78070518041336869808398454625586921201308185638888082699408686536045192649569198110" +
                    "35365994311180230063610650986502394366182943642656300791728205089442938884174888539" +
                    "82907077430529736053592775157496197308237732158947551217614678878653277071155738042" +
                    "64519206349215850195195364813387526811742474131549802130246506341207020335797706780" +
                    "70540694527543880626597851620970679570257924407538049023174103086261496878330620786" +
                    "96878681084236399719832090776247580804999882755913927872676271824428928096468742282" +
                    "63172435642368588260139161962836121481966092745325488641054238839295138992979335446" +
                    "110090325230955276870524611359124918392740353154294858383359");
}
