/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.sftp.SFTPException;
import net.schmizz.sshj.sftp.SFTPPacket;
import org.slf4j.Logger;

public class PacketReader
extends Thread {
    private final Logger log;
    private final InputStream in;
    private final Map<Long, Promise<Response, SFTPException>> promises = new ConcurrentHashMap<Long, Promise<Response, SFTPException>>();
    private final SFTPPacket<Response> packet = new SFTPPacket();
    private final byte[] lenBuf = new byte[4];
    private final SFTPEngine engine;

    public PacketReader(SFTPEngine engine) {
        this.engine = engine;
        this.log = engine.getLoggerFactory().getLogger(this.getClass());
        this.in = engine.getSubsystem().getInputStream();
        this.setName("sftp reader");
        this.setDaemon(true);
    }

    private void readIntoBuffer(byte[] buf, int off, int len) throws IOException {
        int read = 0;
        for (int count = 0; count < len && (read = this.in.read(buf, off + count, len - count)) != -1; count += read) {
        }
        if (read == -1) {
            throw new SFTPException("EOF while reading packet");
        }
    }

    private int getPacketLength() throws IOException {
        this.readIntoBuffer(this.lenBuf, 0, this.lenBuf.length);
        long len = (long)(this.lenBuf[0] << 24) & 0xFF000000L | (long)(this.lenBuf[1] << 16) & 0xFF0000L | (long)(this.lenBuf[2] << 8) & 0xFF00L | (long)this.lenBuf[3] & 0xFFL;
        if (len > 0x40000000L) {
            throw new SSHException(String.format("Indicated packet length %d too large", len));
        }
        return (int)len;
    }

    public SFTPPacket<Response> readPacket() throws IOException {
        int len = this.getPacketLength();
        this.packet.clear();
        this.packet.ensureCapacity(len);
        this.readIntoBuffer(this.packet.array(), 0, len);
        this.packet.wpos(len);
        return this.packet;
    }

    @Override
    public void run() {
        try {
            while (!this.isInterrupted()) {
                this.readPacket();
                this.handle();
            }
        }
        catch (IOException e) {
            for (Promise<Response, SFTPException> promise : this.promises.values()) {
                promise.deliverError(e);
            }
        }
    }

    public void handle() throws SFTPException {
        Response resp = new Response(this.packet, this.engine.getOperativeProtocolVersion());
        Promise<Response, SFTPException> promise = this.promises.remove(resp.getRequestID());
        this.log.debug("Received {} packet", (Object)resp.getType());
        if (promise == null) {
            throw new SFTPException("Received [" + (Object)((Object)resp.readType()) + "] response for request-id " + resp.getRequestID() + ", no such request was made");
        }
        promise.deliver(resp);
    }

    public Promise<Response, SFTPException> expectResponseTo(long requestId) {
        Promise<Response, SFTPException> promise = new Promise<Response, SFTPException>("sftp / " + requestId, SFTPException.chainer, this.engine.getLoggerFactory());
        this.promises.put(requestId, promise);
        return promise;
    }
}

