/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.request.dynos;

import com.heroku.api.Dyno;
import com.heroku.api.Heroku;
import com.heroku.api.exception.RequestFailedException;
import com.heroku.api.http.Http;
import com.heroku.api.http.HttpUtil;
import com.heroku.api.parser.Json;
import com.heroku.api.request.Request;
import com.heroku.api.util.Range;
import java.util.HashMap;
import java.util.Map;

public class DynoList
implements Request<Range<Dyno>> {
    private final String appName;
    private Map<String, String> headers = new HashMap<String, String>();

    public DynoList(String appName, String range) {
        this(appName);
        this.headers.put("Range", range);
    }

    public DynoList(String appName) {
        this.appName = appName;
    }

    @Override
    public Http.Method getHttpMethod() {
        return Http.Method.GET;
    }

    @Override
    public String getEndpoint() {
        return Heroku.Resource.Dynos.format(this.appName);
    }

    @Override
    public boolean hasBody() {
        return false;
    }

    @Override
    public String getBody() {
        throw HttpUtil.noBody();
    }

    @Override
    public Map<String, Object> getBodyAsMap() {
        throw HttpUtil.noBody();
    }

    @Override
    public Http.Accept getResponseType() {
        return Http.Accept.JSON;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Range<Dyno> getResponse(byte[] in, int code, Map<String, String> responseHeaders) {
        if (code == 200) {
            return (Range)Json.parse(in, DynoList.class);
        }
        if (code == 206) {
            Range r = (Range)Json.parse(in, DynoList.class);
            r.setNextRange(responseHeaders.get("Next-Range"));
            return r;
        }
        throw new RequestFailedException("Dyno list failed", code, in);
    }
}

