/*
 * Decompiled with CFR 0.152.
 */
package com.heroku.api.http;

import com.heroku.api.http.UserAgentValueProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class Http {

    public static enum Status {
        OK(200),
        CREATED(201),
        ACCEPTED(202),
        PAYMENT_REQUIRED(402),
        FORBIDDEN(403),
        NOT_FOUND(404),
        UNPROCESSABLE_ENTITY(422),
        INTERNAL_SERVER_ERROR(500),
        SERVICE_UNAVAILABLE(503);

        public final int statusCode;

        private Status(int statusCode) {
            this.statusCode = statusCode;
        }

        public boolean equals(int code) {
            return this.statusCode == code;
        }
    }

    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE,
        PATCH;

    }

    public static interface Header {
        public String getHeaderName();

        public String getHeaderValue();

        public static class Util {
            public static Map<String, String> setHeaders(Header ... headers) {
                HashMap<String, String> headerMap = new HashMap<String, String>();
                for (Header h : headers) {
                    headerMap.put(h.getHeaderName(), h.getHeaderValue());
                }
                return headerMap;
            }
        }
    }

    public static enum UserAgent implements Header
    {
        LATEST(UserAgent.loadValueProvider());

        static final String USER_AGENT = "User-Agent";
        private final UserAgentValueProvider userAgentValueProvider;

        private UserAgent(UserAgentValueProvider userAgentValueProvider) {
            this.userAgentValueProvider = userAgentValueProvider;
        }

        @Override
        public String getHeaderName() {
            return USER_AGENT;
        }

        @Override
        public String getHeaderValue() {
            return this.userAgentValueProvider.getHeaderValue();
        }

        public String getHeaderValue(String customPart) {
            return this.userAgentValueProvider.getHeaderValue(customPart);
        }

        private static UserAgentValueProvider loadValueProvider() {
            Iterator<UserAgentValueProvider> customProviders = ServiceLoader.load(UserAgentValueProvider.class, UserAgent.class.getClassLoader()).iterator();
            if (customProviders.hasNext()) {
                return customProviders.next();
            }
            return new UserAgentValueProvider.DEFAULT();
        }
    }

    public static enum ContentType implements Header
    {
        JSON("application/json"),
        FORM_URLENCODED("application/x-www-form-urlencoded"),
        SSH_AUTHKEY("text/ssh-authkey");

        private String value;
        static String CONTENT_TYPE;

        private ContentType(String val) {
            this.value = val;
        }

        @Override
        public String getHeaderName() {
            return CONTENT_TYPE;
        }

        @Override
        public String getHeaderValue() {
            return this.value;
        }

        static {
            CONTENT_TYPE = "Content-Type";
        }
    }

    public static enum Accept implements Header
    {
        JSON("application/json"),
        TEXT("text/plain");

        private String value;
        static String ACCEPT;

        private Accept(String val) {
            this.value = val;
        }

        @Override
        public String getHeaderName() {
            return ACCEPT;
        }

        @Override
        public String getHeaderValue() {
            return this.value;
        }

        static {
            ACCEPT = "Accept";
        }
    }
}

