/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.encoder;

import android.app.Application;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.serenegiant.encoder.MediaAudioEncoder;
import com.serenegiant.encoder.MediaEncoder;
import com.serenegiant.encoder.MediaSurfaceEncoder;
import com.serenegiant.encoder.MediaVideoBufferEncoder;
import com.serenegiant.encoder.MediaVideoEncoder;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.utils.UriHelper;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MediaMuxerWrapper {
    private static final boolean DEBUG = false;
    private static final String TAG = MediaMuxerWrapper.class.getSimpleName();
    private Uri mOutputUri;
    private final MediaMuxer mMediaMuxer;
    private int mEncoderCount;
    private int mStartedCount;
    private boolean mIsStarted;
    private MediaEncoder mVideoEncoder;
    private MediaEncoder mAudioEncoder;

    public MediaMuxerWrapper(Uri uri) throws IOException {
        Application context = UVCUtils.getApplication();
        this.mOutputUri = uri;
        if (Build.VERSION.SDK_INT < 29) {
            String outputPath = UriHelper.getPath((Context)UVCUtils.getApplication(), this.mOutputUri);
            this.mMediaMuxer = new MediaMuxer(outputPath, 0);
        } else {
            this.mMediaMuxer = new MediaMuxer(context.getContentResolver().openFileDescriptor(this.mOutputUri, "rw").getFileDescriptor(), 0);
        }
        this.mStartedCount = 0;
        this.mEncoderCount = 0;
        this.mIsStarted = false;
    }

    public Uri getOutputUri() {
        return this.mOutputUri;
    }

    public void prepare() throws IOException {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.prepare();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.prepare();
        }
    }

    public void startRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.startRecording();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.startRecording();
        }
    }

    public void pauseRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.pauseRecording();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.pauseRecording();
        }
    }

    public void resumeRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.resumeRecording();
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.resumeRecording();
        }
    }

    public void stopRecording() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.stopRecording();
        }
        this.mVideoEncoder = null;
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.stopRecording();
        }
        this.mAudioEncoder = null;
    }

    public synchronized boolean isStarted() {
        return this.mIsStarted;
    }

    void addEncoder(MediaEncoder encoder) {
        if (encoder instanceof MediaSurfaceEncoder || encoder instanceof MediaVideoEncoder || encoder instanceof MediaVideoBufferEncoder) {
            if (this.mVideoEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mVideoEncoder = encoder;
        } else if (encoder instanceof MediaAudioEncoder) {
            if (this.mAudioEncoder != null) {
                throw new IllegalArgumentException("Video encoder already added.");
            }
            this.mAudioEncoder = encoder;
        } else {
            throw new IllegalArgumentException("unsupported encoder");
        }
        this.mEncoderCount = (this.mVideoEncoder != null ? 1 : 0) + (this.mAudioEncoder != null ? 1 : 0);
    }

    synchronized boolean start() {
        ++this.mStartedCount;
        if (this.mEncoderCount > 0 && this.mStartedCount == this.mEncoderCount) {
            this.mMediaMuxer.start();
            this.mIsStarted = true;
            this.notifyAll();
        }
        return this.mIsStarted;
    }

    synchronized void stop() {
        --this.mStartedCount;
        if (this.mEncoderCount > 0 && this.mStartedCount <= 0) {
            try {
                this.mMediaMuxer.stop();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)" MediaMuxer stop error", (Throwable)e);
            }
            finally {
                this.mMediaMuxer.release();
            }
            this.mIsStarted = false;
        }
    }

    synchronized int addTrack(MediaFormat format) {
        if (this.mIsStarted) {
            throw new IllegalStateException("muxer already started");
        }
        int trackIx = this.mMediaMuxer.addTrack(format);
        return trackIx;
    }

    synchronized void writeSampleData(int trackIndex, ByteBuffer byteBuf, MediaCodec.BufferInfo bufferInfo) {
        if (this.mStartedCount > 0) {
            this.mMediaMuxer.writeSampleData(trackIndex, byteBuf, bufferInfo);
        }
    }
}

