/*
 * Decompiled with CFR 0.152.
 */
package com.herohan.uvcapp;

import android.app.Application;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.herohan.uvcapp.ICameraRendererHolder;
import com.herohan.uvcapp.ImageCaptureConfig;
import com.herohan.uvcapp.ImageRawData;
import com.herohan.uvcapp.ImageSaver;
import com.serenegiant.utils.UVCUtils;
import com.serenegiant.utils.UriHelper;
import java.io.File;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ImageCapture {
    private static final String TAG = ImageCapture.class.getSimpleName();
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_FILE_IO = 1;
    public static final int ERROR_CAPTURE_FAILED = 2;
    public static final int ERROR_CAMERA_CLOSED = 3;
    public static final int ERROR_INVALID_CAMERA = 4;
    public static final int CAPTURE_MODE_MAXIMIZE_QUALITY = 0;
    public static final int CAPTURE_MODE_MINIMIZE_LATENCY = 1;
    public static final int JPEG_QUALITY_MAXIMIZE_QUALITY_MODE = 100;
    public static final int JPEG_QUALITY_MINIMIZE_LATENCY_MODE = 95;
    private WeakReference<ICameraRendererHolder> mRendererHolderWeak;
    private ImageCaptureConfig mConfig;
    private Handler mMainHandler;
    private ExecutorService mExecutor;

    ImageCapture(ICameraRendererHolder rendererHolder, ImageCaptureConfig config) {
        this.mRendererHolderWeak = new WeakReference<ICameraRendererHolder>(rendererHolder);
        this.mConfig = (ImageCaptureConfig)config.clone();
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mExecutor = Executors.newFixedThreadPool(1, new ThreadFactory(){
            private final AtomicInteger mId = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, TAG + "image_capture" + this.mId.getAndIncrement());
            }
        });
    }

    void setConfig(ImageCaptureConfig config) {
        this.mConfig = (ImageCaptureConfig)config.clone();
    }

    @IntRange(from=1L, to=100L)
    int getJpegQualityInternal() {
        if (this.mConfig.hasJpegCompressionQuality()) {
            return this.mConfig.getJpegCompressionQuality();
        }
        switch (this.mConfig.getCaptureMode()) {
            case 0: {
                return 100;
            }
            case 1: {
                return 95;
            }
        }
        throw new IllegalStateException("CaptureMode " + this.mConfig.getCaptureMode() + " is invalid");
    }

    void takePicture(final @NonNull OutputFileOptions outputFileOptions, final @NonNull OnImageCaptureCallback imageSavedCallback) {
        final ImageSaver.OnImageSavedCallback imageSavedCallbackWrapper = new ImageSaver.OnImageSavedCallback(){

            @Override
            public void onImageSaved(@NonNull OutputFileResults outputFileResults) {
                ImageCapture.this.scanMediaFile(outputFileResults.getSavedUri());
                ImageCapture.this.mMainHandler.post(() -> imageSavedCallback.onImageSaved(outputFileResults));
            }

            @Override
            public void onError(@NonNull ImageSaver.SaveError error, @NonNull String message, @Nullable Throwable cause) {
                ImageCapture.this.mMainHandler.post(() -> {
                    int imageCaptureError = 0;
                    switch (error) {
                        case FILE_IO_FAILED: {
                            imageCaptureError = 1;
                            break;
                        }
                    }
                    imageSavedCallback.onError(imageCaptureError, message, cause);
                });
            }
        };
        ICameraRendererHolder cameraRendererHolder = (ICameraRendererHolder)this.mRendererHolderWeak.get();
        if (cameraRendererHolder == null) {
            imageSavedCallback.onError(4, "Not bound to a Camera", null);
        } else {
            final int outputJpegQuality = this.getJpegQualityInternal();
            cameraRendererHolder.captureImage(new ICameraRendererHolder.OnImageCapturedCallback(){

                @Override
                public void onCaptureSuccess(ImageRawData image) {
                    ImageCapture.this.mExecutor.execute(new ImageSaver(image, outputJpegQuality, outputFileOptions, imageSavedCallbackWrapper));
                }

                @Override
                public void onError(Exception e) {
                    String message = e.getMessage();
                    if (message == null) {
                        message = "captureImage failed with an unknown exception";
                    }
                    imageSavedCallback.onError(0, message, e);
                }
            });
        }
    }

    private void scanMediaFile(Uri uri) {
        if (uri == null) {
            return;
        }
        Application context = UVCUtils.getApplication();
        String path = UriHelper.getPath((Context)context, uri);
        try {
            MediaScannerConnection.scanFile((Context)context, (String[])new String[]{path}, null, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"MediaScannerConnection:", (Throwable)e);
        }
    }

    void release() {
        if (this.mExecutor != null) {
            this.mExecutor.shutdown();
            this.mExecutor = null;
        }
    }

    public static interface OnImageCaptureCallback {
        public void onImageSaved(@NonNull OutputFileResults var1);

        public void onError(int var1, @NonNull String var2, @Nullable Throwable var3);
    }

    public static final class OutputFileOptions {
        @Nullable
        private File mFile;
        @Nullable
        private ContentResolver mContentResolver;
        @Nullable
        private Uri mSaveCollection;
        @Nullable
        private ContentValues mContentValues;
        @Nullable
        private OutputStream mOutputStream;

        OutputFileOptions(@Nullable File file, @Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues, @Nullable OutputStream outputStream) {
            this.mFile = file;
            this.mContentResolver = contentResolver;
            this.mSaveCollection = saveCollection;
            this.mContentValues = contentValues;
            this.mOutputStream = outputStream;
        }

        @Nullable
        public File getFile() {
            return this.mFile;
        }

        @Nullable
        public ContentResolver getContentResolver() {
            return this.mContentResolver;
        }

        @Nullable
        public Uri getSaveCollection() {
            return this.mSaveCollection;
        }

        @Nullable
        public ContentValues getContentValues() {
            return this.mContentValues;
        }

        @Nullable
        public OutputStream getOutputStream() {
            return this.mOutputStream;
        }

        public static final class Builder {
            @Nullable
            private File mFile;
            @Nullable
            private ContentResolver mContentResolver;
            @Nullable
            private Uri mSaveCollection;
            @Nullable
            private ContentValues mContentValues;
            @Nullable
            private OutputStream mOutputStream;

            public Builder(@Nullable File file) {
                this.mFile = file;
            }

            public Builder(@Nullable ContentResolver contentResolver, @Nullable Uri saveCollection, @Nullable ContentValues contentValues) {
                this.mContentResolver = contentResolver;
                this.mSaveCollection = saveCollection;
                this.mContentValues = contentValues;
            }

            public Builder(@Nullable OutputStream outputStream) {
                this.mOutputStream = outputStream;
            }

            public OutputFileOptions build() {
                return new OutputFileOptions(this.mFile, this.mContentResolver, this.mSaveCollection, this.mContentValues, this.mOutputStream);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CaptureMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImageCaptureError {
    }

    public static class OutputFileResults {
        @Nullable
        private Uri mSavedUri;

        OutputFileResults(@Nullable Uri SavedUri) {
            this.mSavedUri = SavedUri;
        }

        @Nullable
        public Uri getSavedUri() {
            return this.mSavedUri;
        }
    }
}

