/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.usb;

import android.graphics.SurfaceTexture;
import android.hardware.usb.UsbDevice;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.serenegiant.usb.Format;
import com.serenegiant.usb.IButtonCallback;
import com.serenegiant.usb.IFrameCallback;
import com.serenegiant.usb.IStatusCallback;
import com.serenegiant.usb.Size;
import com.serenegiant.usb.USBMonitor;
import com.serenegiant.usb.UVCControl;
import com.serenegiant.usb.UVCParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UVCCamera {
    private static final boolean DEBUG = false;
    private static final String TAG = UVCCamera.class.getSimpleName();
    public static final int UVC_ERROR_BUSY = -6;
    public static final int UVC_VS_FORMAT_UNCOMPRESSED = 4;
    public static final int UVC_VS_FRAME_UNCOMPRESSED = 5;
    public static final int UVC_VS_FORMAT_MJPEG = 6;
    public static final int UVC_VS_FRAME_MJPEG = 7;
    public static final int DEFAULT_PREVIEW_WIDTH = 640;
    public static final int DEFAULT_PREVIEW_HEIGHT = 480;
    public static final int DEFAULT_PREVIEW_FRAME_FORMAT = 7;
    public static final int DEFAULT_PREVIEW_FPS = 30;
    public static final int FRAME_FORMAT_YUYV = 0;
    public static final int FRAME_FORMAT_MJPEG = 1;
    public static final int PIXEL_FORMAT_RAW = 0;
    public static final int PIXEL_FORMAT_YUV = 1;
    public static final int PIXEL_FORMAT_NV12 = 2;
    public static final int PIXEL_FORMAT_NV21 = 3;
    public static final int PIXEL_FORMAT_RGB = 4;
    public static final int PIXEL_FORMAT_RGB565 = 5;
    public static final int PIXEL_FORMAT_RGBX = 6;
    public static final int PIXEL_FORMAT_BGR = 7;
    public static final int UVC_QUIRK_FIX_BANDWIDTH = 128;
    private USBMonitor.UsbControlBlock mCtrlBlock;
    private UVCControl mControl = null;
    protected long mNativePtr = this.nativeCreate();
    protected String mSupportedFormats;
    protected List<Format> mSupportedFormatList;
    protected List<Size> mSupportedSizeList;
    protected Size mCurrentSize;
    protected UVCParam mParam;

    public UVCCamera(UVCParam param) {
        this.mParam = param != null ? (UVCParam)param.clone() : new UVCParam();
    }

    public synchronized int open(USBMonitor.UsbControlBlock ctrlBlock) {
        int result;
        try {
            this.mCtrlBlock = ctrlBlock.clone();
            this.mCtrlBlock.open();
            result = this.nativeConnect(this.mNativePtr, this.mCtrlBlock.getFileDescriptor(), this.mParam.getQuirks());
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
            result = -1;
        }
        if (result != 0) {
            return result;
        }
        this.updateSupportedFormats();
        Size size = this.mParam.getPreviewSize();
        if (!(size != null && this.checkSizeValid(size.width, size.height, size.type, size.fps) || (size = this.getSupportedSizeOne()) != null)) {
            size = new Size(7, 640, 480, 30, new ArrayList<Integer>(30));
        }
        int r = this.nativeSetPreviewSize(this.mNativePtr, size.width, size.height, size.type, size.fps);
        this.mCurrentSize = size;
        this.mControl = new UVCControl(this.nativeGetControl(this.mNativePtr));
        return result;
    }

    public void setQuirks(IStatusCallback callback) {
        if (this.mNativePtr != 0L) {
            this.nativeSetStatusCallback(this.mNativePtr, callback);
        }
    }

    public void setStatusCallback(IStatusCallback callback) {
        if (this.mNativePtr != 0L) {
            this.nativeSetStatusCallback(this.mNativePtr, callback);
        }
    }

    public void setButtonCallback(IButtonCallback callback) {
        if (this.mNativePtr != 0L) {
            this.nativeSetButtonCallback(this.mNativePtr, callback);
        }
    }

    public synchronized void close() {
        this.close(false);
    }

    public synchronized void close(boolean isSilent) {
        this.stopPreview();
        if (this.mNativePtr != 0L) {
            this.nativeRelease(this.mNativePtr);
        }
        if (this.mCtrlBlock != null) {
            this.mCtrlBlock.close(isSilent);
            this.mCtrlBlock = null;
        }
        this.mSupportedFormats = null;
        this.mSupportedFormatList = null;
        this.mSupportedSizeList = null;
        this.mCurrentSize = null;
        if (this.mControl != null) {
            this.mControl.release();
            this.mControl = null;
        }
    }

    public UsbDevice getDevice() {
        return this.mCtrlBlock != null ? this.mCtrlBlock.getDevice() : null;
    }

    public String getDeviceName() {
        return this.mCtrlBlock != null ? this.mCtrlBlock.getDeviceName() : null;
    }

    public USBMonitor.UsbControlBlock getUsbControlBlock() {
        return this.mCtrlBlock;
    }

    private void updateSupportedFormats() {
        if (this.mNativePtr != 0L) {
            this.mSupportedFormats = this.nativeGetSupportedFormats(this.mNativePtr);
            this.mSupportedFormatList = this.parseSupportedFormats(this.mSupportedFormats);
            this.mSupportedSizeList = this.fetchSupportedSizeList(this.mSupportedFormatList);
        }
    }

    public synchronized String getSupportedSize() {
        if (TextUtils.isEmpty((CharSequence)this.mSupportedFormats)) {
            this.updateSupportedFormats();
        }
        return this.mSupportedFormats;
    }

    public List<Format> getSupportedFormatList() {
        ArrayList<Format> list = new ArrayList<Format>();
        if (this.mSupportedFormatList != null) {
            for (Format format : this.mSupportedFormatList) {
                list.add(format.clone());
            }
        }
        return list;
    }

    public List<Size> getSupportedSizeList() {
        ArrayList<Size> list = new ArrayList<Size>();
        if (this.mSupportedSizeList != null) {
            for (Size size : this.mSupportedSizeList) {
                list.add(size.clone());
            }
        }
        return list;
    }

    public Size getSupportedSizeOne() {
        Size maxSize = null;
        List<Size> sizeList = this.getSupportedSizeList();
        if (sizeList != null && sizeList.size() > 0) {
            Collections.sort(sizeList, (o1, o2) -> o2.width * o2.height - o1.width * o1.height);
            for (Size size : sizeList) {
                if (size.type != 7) continue;
                maxSize = size;
                break;
            }
            if (maxSize == null) {
                maxSize = sizeList.get(0);
            }
        }
        return maxSize;
    }

    private List<Format> parseSupportedFormats(String supportedFormats) {
        ArrayList<Format> formatList = new ArrayList<Format>();
        if (!TextUtils.isEmpty((CharSequence)supportedFormats)) {
            try {
                JSONObject json = new JSONObject(supportedFormats);
                JSONArray formatsJSON = json.getJSONArray("formats");
                for (int i = 0; i < formatsJSON.length(); ++i) {
                    JSONObject formatJSON = formatsJSON.getJSONObject(i);
                    if (!formatJSON.has("subType") || !formatJSON.has("frameDescriptors")) continue;
                    int index = formatJSON.getInt("index");
                    int formatType = formatJSON.getInt("subType");
                    if (formatType != 6 && formatType != 4) continue;
                    List<Format.Descriptor> descriptorList = this.parseFrameDescriptors(formatJSON, index);
                    formatList.add(new Format(index, formatType, descriptorList));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return formatList;
    }

    private List<Format.Descriptor> parseFrameDescriptors(JSONObject format, int index) throws JSONException {
        ArrayList<Format.Descriptor> descriptorList = new ArrayList<Format.Descriptor>();
        JSONArray frameDescs = format.getJSONArray("frameDescriptors");
        for (int j = 0; j < frameDescs.length(); ++j) {
            JSONObject frameDesc = frameDescs.getJSONObject(j);
            int width = frameDesc.getInt("width");
            int height = frameDesc.getInt("height");
            int formatType = frameDesc.getInt("subType");
            int defaultFps = frameDesc.getInt("defaultFps");
            int defaultFrameInterval = frameDesc.getInt("defaultFrameInterval");
            ArrayList<Format.Interval> intervals = new ArrayList<Format.Interval>();
            JSONArray intervalJSONArray = frameDesc.getJSONArray("intervals");
            if (intervalJSONArray.length() > 0) {
                int maxFrameInterval = 0;
                int maxFps = 0;
                for (int k = 0; k < intervalJSONArray.length(); ++k) {
                    JSONObject jsonObject = intervalJSONArray.getJSONObject(k);
                    Format.Interval interval = new Format.Interval(jsonObject.getInt("index"), jsonObject.getInt("value"), jsonObject.getInt("fps"));
                    intervals.add(interval);
                    if (maxFps >= interval.fps) continue;
                    maxFrameInterval = interval.value;
                    maxFps = interval.fps;
                }
                if (maxFps > 0) {
                    defaultFrameInterval = maxFrameInterval;
                    defaultFps = maxFps;
                }
            }
            try {
                descriptorList.add(new Format.Descriptor(index, formatType, width, height, defaultFps, defaultFrameInterval, intervals));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return descriptorList;
    }

    private List<Size> fetchSupportedSizeList(List<Format> formatList) {
        ArrayList<Size> sizeList = new ArrayList<Size>();
        for (Format format : formatList) {
            for (Format.Descriptor descriptor : format.frameDescriptors) {
                ArrayList<Integer> fpsList = new ArrayList<Integer>();
                for (Format.Interval interval : descriptor.intervals) {
                    fpsList.add(interval.fps);
                }
                sizeList.add(new Size(descriptor.type, descriptor.width, descriptor.height, descriptor.fps, fpsList));
            }
        }
        return sizeList;
    }

    private boolean checkSizeValid(int width, int height, int frameType, int fps) {
        if (this.mNativePtr != 0L) {
            List<Size> sizeList = this.getSupportedSizeList();
            for (Size size : sizeList) {
                if (size.width != width || size.height != height || size.type != frameType || size.fps != fps && !size.fpsList.contains(fps)) continue;
                return true;
            }
        }
        return false;
    }

    public Size getPreviewSize() {
        return this.mCurrentSize;
    }

    public void setPreviewSize(int width, int height) {
        this.setPreviewSize(width, height, 7, 30);
    }

    public void setPreviewSize(int width, int height, int frameType) {
        this.setPreviewSize(width, height, frameType, 30);
    }

    public void setPreviewSize(int width, int height, int frameType, int fps) {
        this.setPreviewSize(new Size(frameType, width, height, fps, new ArrayList<Integer>(fps)));
    }

    public void setPreviewSize(Size size) {
        if (size.width == 0 || size.height == 0) {
            throw new IllegalArgumentException("invalid preview size");
        }
        if (this.mNativePtr != 0L) {
            if (!this.checkSizeValid(size.width, size.height, size.type, size.fps)) {
                throw new IllegalArgumentException("invalid preview size");
            }
            int result = this.nativeSetPreviewSize(this.mNativePtr, size.width, size.height, size.type, size.fps);
            if (result != 0) {
                result = this.nativeSetPreviewSize(this.mNativePtr, size.width, size.height, size.type, size.fps);
            }
            if (result != 0) {
                throw new IllegalArgumentException("Failed to set preview size");
            }
            this.mCurrentSize = size;
        }
    }

    public synchronized void setPreviewDisplay(SurfaceHolder holder) {
        this.nativeSetPreviewDisplay(this.mNativePtr, holder.getSurface());
    }

    public synchronized void setPreviewTexture(SurfaceTexture texture) {
        Surface surface = new Surface(texture);
        this.nativeSetPreviewDisplay(this.mNativePtr, surface);
    }

    public synchronized void setPreviewDisplay(Surface surface) {
        this.nativeSetPreviewDisplay(this.mNativePtr, surface);
    }

    public void setFrameCallback(IFrameCallback callback, int pixelFormat) {
        if (this.mNativePtr != 0L) {
            this.nativeSetFrameCallback(this.mNativePtr, callback, pixelFormat);
        }
    }

    public synchronized void startPreview() {
        if (this.mCtrlBlock != null) {
            this.nativeStartPreview(this.mNativePtr);
        }
    }

    public synchronized void stopPreview() {
        if (this.mCtrlBlock != null) {
            this.nativeStopPreview(this.mNativePtr);
        }
    }

    public void startCapture(Surface surface) {
        if (this.mCtrlBlock == null || surface == null) {
            throw new NullPointerException("startCapture");
        }
        this.nativeSetCaptureDisplay(this.mNativePtr, surface);
    }

    public void stopCapture() {
        if (this.mCtrlBlock != null) {
            this.nativeSetCaptureDisplay(this.mNativePtr, null);
        }
    }

    public synchronized void destroy() {
        this.destroy(false);
    }

    public synchronized void destroy(boolean isSilent) {
        this.close(isSilent);
        if (this.mNativePtr != 0L) {
            this.nativeDestroy(this.mNativePtr);
            this.mNativePtr = 0L;
        }
    }

    public UVCControl getControl() {
        return this.mControl;
    }

    public boolean isOpened() {
        return this.mControl != null;
    }

    private native long nativeCreate();

    private native void nativeDestroy(long var1);

    private native int nativeConnect(long var1, int var3, int var4);

    private native int nativeRelease(long var1);

    private native long nativeGetControl(long var1);

    private native int nativeSetStatusCallback(long var1, IStatusCallback var3);

    private native int nativeSetButtonCallback(long var1, IButtonCallback var3);

    private native int nativeSetPreviewSize(long var1, int var3, int var4, int var5, int var6);

    private native String nativeGetSupportedFormats(long var1);

    private native int nativeStartPreview(long var1);

    private native int nativeStopPreview(long var1);

    private native int nativeSetPreviewDisplay(long var1, Surface var3);

    private native int nativeSetFrameCallback(long var1, IFrameCallback var3, int var4);

    private native int nativeSetCaptureDisplay(long var1, Surface var3);

    static {
        System.loadLibrary("jpeg-turbo212");
        System.loadLibrary("usb1.0");
        System.loadLibrary("uvc");
        System.loadLibrary("UVCCamera");
    }
}

