/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.opengl.renderer;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.util.SparseArray;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.serenegiant.opengl.EGLBase;
import com.serenegiant.opengl.EGLTask;
import com.serenegiant.opengl.GLDrawer2D;
import com.serenegiant.opengl.GLHelper;
import com.serenegiant.opengl.renderer.IRendererHolder;
import com.serenegiant.opengl.renderer.RendererHolderCallback;
import com.serenegiant.opengl.renderer.RendererSurface;
import com.serenegiant.utils.UVCUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RendererHolder
extends EGLTask
implements IRendererHolder {
    private static final boolean DEBUG = false;
    private static final String TAG = RendererHolder.class.getSimpleName();
    protected static final int REQUEST_INIT = 1;
    protected static final int REQUEST_DRAW = 2;
    protected static final int REQUEST_UPDATE_SIZE = 3;
    protected static final int REQUEST_ADD_SLAVE_SURFACE = 4;
    protected static final int REQUEST_REMOVE_SLAVE_SURFACE = 5;
    protected static final int REQUEST_RECREATE_PRIMARY_SURFACE = 6;
    protected static final int REQUEST_CLEAR_SLAVE_SURFACE = 11;
    protected static final int REQUEST_CLEAR_SLAVE_SURFACE_ALL = 12;
    protected static final int REQUEST_REMOVE_SLAVE_SURFACE_ALL = 13;
    protected static final int REQUEST_RELEASE_PRIMARY_SURFACE = 14;
    protected static final int REQUEST_RELEASE = 99;
    protected final Context mContext = UVCUtils.getApplication();
    @Nullable
    private final RendererHolderCallback mCallback;
    protected volatile boolean isRunning;
    private final SparseArray<RendererSurface> mSlaveSurfaces = new SparseArray();
    protected int mVideoWidth;
    protected int mVideoHeight;
    protected int mTexId;
    protected final float[] mTexMatrix = new float[16];
    protected final float[] mMvpMatrix = new float[16];
    protected final float[] mRotationMatrix = new float[16];
    protected final float[] mMirrorMatrix = new float[16];
    private GLDrawer2D mDrawer;
    private SurfaceTexture mPrimaryTexture;
    private Surface mPrimarySurface;
    private final Lock mLock = new ReentrantLock();
    private final Condition mCreatePrimarySurfaceCondition = this.mLock.newCondition();
    private int mMirrorMode = 0;
    private volatile boolean mIsFirstFrameRendered;
    protected final RendererHandler mRendererHandler;

    public RendererHolder(int width, int height, @Nullable RendererHolderCallback callback) {
        this(width, height, null, 2, 3, callback);
    }

    public RendererHolder(int width, int height, EGLBase.IContext sharedContext, int flags, int maxClientVersion, @Nullable RendererHolderCallback callback) {
        super(sharedContext, flags, maxClientVersion);
        this.mCallback = callback;
        this.mVideoWidth = width > 0 ? width : 640;
        this.mVideoHeight = height > 0 ? height : 480;
        this.mRendererHandler = new RendererHandler(this.getLooper());
        this.mRendererHandler.sendEmptyMessage(1);
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public void release() {
        this.mRendererHandler.sendEmptyMessage(99);
    }

    @Override
    public Surface getPrimarySurface() {
        this.checkPrimarySurface();
        return this.mPrimarySurface;
    }

    @Override
    public SurfaceTexture getPrimarySurfaceTexture() {
        this.checkPrimarySurface();
        return this.mPrimaryTexture;
    }

    @Override
    public void checkPrimarySurface() {
        if (this.mPrimarySurface == null || !this.mPrimarySurface.isValid()) {
            Log.d((String)TAG, (String)"checkPrimarySurface:invalid primary surface");
            this.mLock.lock();
            try {
                this.mRendererHandler.sendEmptyMessage(6);
                try {
                    this.mCreatePrimarySurfaceCondition.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePrimarySize(int width, int height) throws IllegalStateException {
        if (width > 0 && height > 0 && (this.mVideoWidth != width || this.mVideoHeight != height)) {
            this.mLock.lock();
            try {
                this.mRendererHandler.sendMessage(this.mRendererHandler.obtainMessage(3, width, height));
                this.mRendererHandler.sendEmptyMessage(6);
                try {
                    this.mCreatePrimarySurfaceCondition.await();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                this.mLock.unlock();
            }
        }
    }

    @Override
    public void addSlaveSurface(int id, Object surface, boolean isRecordable) throws IllegalStateException, IllegalArgumentException {
        this.addSlaveSurface(id, surface, isRecordable, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSlaveSurface(int id, Object surface, boolean isRecordable, int maxFps) throws IllegalStateException, IllegalArgumentException {
        if (!(surface instanceof SurfaceTexture || surface instanceof Surface || surface instanceof SurfaceHolder)) {
            throw new IllegalArgumentException("Surface should be one of Surface, SurfaceTexture or SurfaceHolder");
        }
        SparseArray<RendererSurface> sparseArray = this.mSlaveSurfaces;
        synchronized (sparseArray) {
            if (this.mSlaveSurfaces.get(id) == null) {
                this.mRendererHandler.sendMessage(this.mRendererHandler.obtainMessage(4, id, maxFps, surface));
                try {
                    this.mSlaveSurfaces.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSlaveSurface(int id) {
        SparseArray<RendererSurface> sparseArray = this.mSlaveSurfaces;
        synchronized (sparseArray) {
            if (this.mSlaveSurfaces.get(id) != null) {
                this.mRendererHandler.sendMessage(this.mRendererHandler.obtainMessage(5, id, 0));
                try {
                    this.mSlaveSurfaces.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSlaveSurfaceAll() {
        SparseArray<RendererSurface> sparseArray = this.mSlaveSurfaces;
        synchronized (sparseArray) {
            this.mRendererHandler.sendEmptyMessage(13);
            try {
                this.mSlaveSurfaces.wait(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void clearSlaveSurface(int id, int color) {
        this.mRendererHandler.sendMessage(this.mRendererHandler.obtainMessage(11, id, color));
    }

    @Override
    public void clearSlaveSurfaceAll(int color) {
        this.mRendererHandler.sendMessage(this.mRendererHandler.obtainMessage(12, color));
    }

    private void updateMvpMatrix() {
        Matrix.multiplyMM((float[])this.mMvpMatrix, (int)0, (float[])this.mRotationMatrix, (int)0, (float[])this.mMirrorMatrix, (int)0);
    }

    @Override
    public void rotateTo(int angle) {
        Matrix.setRotateM((float[])this.mRotationMatrix, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)-1.0f);
        this.updateMvpMatrix();
    }

    @Override
    public void rotateBy(int angle) {
        Matrix.rotateM((float[])this.mRotationMatrix, (int)0, (float)angle, (float)0.0f, (float)0.0f, (float)-1.0f);
        this.updateMvpMatrix();
    }

    @Override
    public void setMirrorMode(int mode) {
        this.mMirrorMode = mode == 0 ? mode : (this.mMirrorMode ^= mode);
        RendererHolder.setMirrorMode(this.mMirrorMatrix, this.mMirrorMode);
        this.updateMvpMatrix();
    }

    @Override
    public int getMirrorMode() {
        return this.mMirrorMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSlaveSurfaceEnable(int id) {
        SparseArray<RendererSurface> sparseArray = this.mSlaveSurfaces;
        synchronized (sparseArray) {
            RendererSurface slaveSurface = (RendererSurface)this.mSlaveSurfaces.get(id);
            return slaveSurface != null && slaveSurface.isEnable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSlaveSurfaceEnable(int id, boolean enable) {
        SparseArray<RendererSurface> sparseArray = this.mSlaveSurfaces;
        synchronized (sparseArray) {
            RendererSurface slaveSurface = (RendererSurface)this.mSlaveSurfaces.get(id);
            if (slaveSurface != null) {
                slaveSurface.setEnable(enable);
            }
        }
    }

    @Override
    public void requestFrame() {
        this.mRendererHandler.removeMessages(2);
        this.mRendererHandler.sendEmptyMessage(2);
    }

    protected void onDrawSlaveSurface(@NonNull RendererSurface surface, int texId, float[] texMatrix, float[] mvpMatrix) {
        surface.draw(this.mDrawer, texId, texMatrix, mvpMatrix);
    }

    protected void onPrimarySurfaceCreate(Surface surface) {
        if (this.mCallback != null) {
            try {
                this.mCallback.onPrimarySurfaceCreate(surface);
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void onFrameAvailable() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onFrameAvailable();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected void onPrimarySurfaceDestroy() {
        if (this.mCallback != null) {
            try {
                this.mCallback.onPrimarySurfaceDestroy();
            }
            catch (Exception e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
    }

    protected static void setMirrorMode(float[] mvp, int mode) {
        switch (mode) {
            case 0: {
                mvp[0] = Math.abs(mvp[0]);
                mvp[5] = Math.abs(mvp[5]);
                break;
            }
            case 1: {
                mvp[0] = -Math.abs(mvp[0]);
                mvp[5] = Math.abs(mvp[5]);
                break;
            }
            case 2: {
                mvp[0] = Math.abs(mvp[0]);
                mvp[5] = -Math.abs(mvp[5]);
                break;
            }
            case 3: {
                mvp[0] = -Math.abs(mvp[0]);
                mvp[5] = -Math.abs(mvp[5]);
                break;
            }
        }
    }

    protected class RendererHandler
    extends Handler {
        protected final SurfaceTexture.OnFrameAvailableListener mOnFrameAvailableListener;

        public RendererHandler(Looper looper) {
            super(looper);
            this.mOnFrameAvailableListener = new SurfaceTexture.OnFrameAvailableListener(){

                public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                    RendererHandler.this.removeMessages(2);
                    if (!RendererHolder.this.mIsFirstFrameRendered) {
                        RendererHolder.this.makeCurrent();
                        RendererHolder.this.mIsFirstFrameRendered = true;
                    }
                    RendererHandler.this.sendEmptyMessage(2);
                }
            };
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    this.handleInit();
                    break;
                }
                case 2: {
                    this.handleDraw();
                    break;
                }
                case 3: {
                    this.handleUpdateSize(msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    this.handleAddSlaveSurface(msg.arg1, msg.obj, msg.arg2);
                    break;
                }
                case 5: {
                    this.handleRemoveSlaveSurface(msg.arg1);
                    break;
                }
                case 13: {
                    this.handleRemoveSlaveSurfaceAll();
                    break;
                }
                case 6: {
                    this.handleReCreatePrimarySurface();
                    break;
                }
                case 11: {
                    this.handleClearSlaveSurface(msg.arg1, msg.arg2);
                    break;
                }
                case 12: {
                    this.handleClearSlaveSurfaceAll(msg.arg1);
                    break;
                }
                case 14: {
                    this.handleReleasePrimarySurface();
                    break;
                }
                case 99: {
                    this.handleRelease();
                    break;
                }
            }
        }

        private void handleInit() {
            this.handleReCreatePrimarySurface();
            RendererHolder.this.mDrawer = new GLDrawer2D(true);
            Matrix.setIdentityM((float[])RendererHolder.this.mMvpMatrix, (int)0);
            Matrix.setIdentityM((float[])RendererHolder.this.mRotationMatrix, (int)0);
            Matrix.setIdentityM((float[])RendererHolder.this.mMirrorMatrix, (int)0);
        }

        private void handleRelease() {
            if (RendererHolder.this.mDrawer != null) {
                RendererHolder.this.mDrawer.release();
                RendererHolder.this.mDrawer = null;
            }
            this.handleReleasePrimarySurface();
            this.handleRemoveSlaveSurfaceAll();
            RendererHolder.this.quitSafely();
        }

        protected void handleDraw() {
            if (RendererHolder.this.mPrimarySurface == null || !RendererHolder.this.mPrimarySurface.isValid()) {
                Log.e((String)TAG, (String)"checkPrimarySurface:invalid primary surface");
                this.sendEmptyMessage(6);
                return;
            }
            if (RendererHolder.this.mIsFirstFrameRendered) {
                try {
                    RendererHolder.this.mPrimaryTexture.updateTexImage();
                    RendererHolder.this.mPrimaryTexture.getTransformMatrix(RendererHolder.this.mTexMatrix);
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("draw:thread id =" + Thread.currentThread().getId()), (Throwable)e);
                    this.sendEmptyMessage(6);
                    return;
                }
                this.handleDrawSlaveSurfaces();
                RendererHolder.this.onFrameAvailable();
            }
            GLES20.glClear((int)16384);
            GLES20.glFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleDrawSlaveSurfaces() {
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                int n = RendererHolder.this.mSlaveSurfaces.size();
                for (int i = n - 1; i >= 0; --i) {
                    RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.valueAt(i);
                    if (slaveSurface == null || !slaveSurface.canDraw()) continue;
                    try {
                        RendererHolder.this.onDrawSlaveSurface(slaveSurface, RendererHolder.this.mTexId, RendererHolder.this.mTexMatrix, RendererHolder.this.mMvpMatrix);
                        continue;
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)"onDrawSlaveSurface:", (Throwable)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleAddSlaveSurface(int id, Object surface, int maxFps) {
            this.checkSurface();
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.get(id);
                if (slaveSurface == null) {
                    try {
                        slaveSurface = RendererSurface.newInstance(RendererHolder.this.getEgl(), surface, maxFps);
                        RendererHolder.this.mSlaveSurfaces.append(id, (Object)slaveSurface);
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)("invalid surface: surface=" + surface), (Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)("surface is already added: id=" + id));
                }
                RendererHolder.this.mSlaveSurfaces.notifyAll();
            }
            RendererHolder.this.makeCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleRemoveSlaveSurface(int id) {
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.get(id);
                if (slaveSurface != null) {
                    RendererHolder.this.mSlaveSurfaces.remove(id);
                    if (slaveSurface.isValid()) {
                        slaveSurface.clear(0);
                    }
                    slaveSurface.release();
                }
                RendererHolder.this.mSlaveSurfaces.notifyAll();
            }
            this.checkSurface();
            RendererHolder.this.makeCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleRemoveSlaveSurfaceAll() {
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                int n = RendererHolder.this.mSlaveSurfaces.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.valueAt(i);
                    if (slaveSurface == null) continue;
                    if (slaveSurface.isValid()) {
                        slaveSurface.clear(0);
                    }
                    slaveSurface.release();
                }
                RendererHolder.this.mSlaveSurfaces.clear();
                RendererHolder.this.mSlaveSurfaces.notifyAll();
            }
            RendererHolder.this.makeCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkSurface() {
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                ArrayList<Integer> removeIndexList = new ArrayList<Integer>();
                int n = RendererHolder.this.mSlaveSurfaces.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.valueAt(i);
                    if (slaveSurface == null || slaveSurface.isValid()) continue;
                    removeIndexList.add(i);
                }
                Iterator iterator = removeIndexList.iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    ((RendererSurface)RendererHolder.this.mSlaveSurfaces.valueAt(index)).release();
                    RendererHolder.this.mSlaveSurfaces.removeAt(index);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClearSlaveSurface(int id, int color) {
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.get(id);
                if (slaveSurface != null && slaveSurface.isValid()) {
                    slaveSurface.clear(color);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleClearSlaveSurfaceAll(int color) {
            SparseArray sparseArray = RendererHolder.this.mSlaveSurfaces;
            synchronized (sparseArray) {
                int n = RendererHolder.this.mSlaveSurfaces.size();
                for (int i = 0; i < n; ++i) {
                    RendererSurface slaveSurface = (RendererSurface)RendererHolder.this.mSlaveSurfaces.valueAt(i);
                    if (slaveSurface == null || !slaveSurface.isValid()) continue;
                    slaveSurface.clear(color);
                }
            }
        }

        protected void handleReCreatePrimarySurface() {
            RendererHolder.this.mLock.lock();
            try {
                this.handleReleasePrimarySurface();
                RendererHolder.this.mTexId = GLHelper.initTex(36197, 9728);
                RendererHolder.this.mPrimaryTexture = new SurfaceTexture(RendererHolder.this.mTexId);
                RendererHolder.this.mPrimarySurface = new Surface(RendererHolder.this.mPrimaryTexture);
                if (Build.VERSION.SDK_INT >= 15) {
                    RendererHolder.this.mPrimaryTexture.setDefaultBufferSize(RendererHolder.this.mVideoWidth, RendererHolder.this.mVideoHeight);
                }
                RendererHolder.this.mIsFirstFrameRendered = false;
                RendererHolder.this.mPrimaryTexture.setOnFrameAvailableListener(this.mOnFrameAvailableListener);
                RendererHolder.this.makeCurrent();
                RendererHolder.this.mCreatePrimarySurfaceCondition.signalAll();
                RendererHolder.this.onPrimarySurfaceCreate(RendererHolder.this.mPrimarySurface);
            }
            finally {
                RendererHolder.this.mLock.unlock();
            }
        }

        protected void handleReleasePrimarySurface() {
            RendererHolder.this.makeCurrent();
            if (RendererHolder.this.mPrimarySurface != null) {
                try {
                    RendererHolder.this.mPrimarySurface.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                RendererHolder.this.mPrimarySurface = null;
                RendererHolder.this.onPrimarySurfaceDestroy();
            }
            if (RendererHolder.this.mPrimaryTexture != null) {
                try {
                    RendererHolder.this.mPrimaryTexture.release();
                }
                catch (Exception e) {
                    Log.w((String)TAG, (Throwable)e);
                }
                RendererHolder.this.mPrimaryTexture = null;
            }
            if (RendererHolder.this.mTexId != 0) {
                GLHelper.deleteTex(RendererHolder.this.mTexId);
                RendererHolder.this.mTexId = 0;
            }
            RendererHolder.this.makeCurrent();
        }

        protected void handleUpdateSize(int width, int height) {
            RendererHolder.this.mVideoWidth = width;
            RendererHolder.this.mVideoHeight = height;
            RendererHolder.this.makeCurrent();
        }
    }
}

