/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.SignatureRequest;
import com.hellosign.sdk.resource.support.CustomField;
import com.hellosign.sdk.resource.support.types.UnclaimedDraftType;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class UnclaimedDraft
extends AbstractRequest {
    public static final String UNCLAIMED_DRAFT_KEY = "unclaimed_draft";
    public static final String UNCLAIMED_DRAFT_CLAIM_URL = "claim_url";
    public static final String UNCLAIMED_DRAFT_TYPE = "type";
    public static final String UNCLAIMED_DRAFT_REQUESTER_EMAIL = "requester_email_address";
    public static final String UNCLAIMED_DRAFT_IS_FOR_EMBEDDED_SIGNING = "is_for_embedded_signing";
    public static final String UNCLAIMED_DRAFT_SIGNATURE_REQUEST_ID = "signature_request_id";
    public static final String UNCLAIMED_DRAFT_EXPIRES_AT = "expires_at";
    public static final String UNCLAIMED_DRAFT_TEST_MODE = "test_mode";
    private UnclaimedDraftType type;
    private boolean isForEmbeddedSigning = false;
    private AbstractRequest request;

    public UnclaimedDraft() {
        this(new SignatureRequest());
    }

    public UnclaimedDraft(AbstractRequest request) {
        this(request, null);
    }

    public UnclaimedDraft(AbstractRequest request, UnclaimedDraftType type) {
        this.setRequest(request);
        if (type == null) {
            type = UnclaimedDraftType.send_document;
        }
        this.setType(type);
    }

    public UnclaimedDraft(JSONObject json) throws HelloSignException {
        super(json, UNCLAIMED_DRAFT_KEY);
    }

    public String getTypeString() {
        return this.type.toString();
    }

    public UnclaimedDraftType getType() {
        return this.type;
    }

    public void setType(UnclaimedDraftType type) {
        this.type = type;
    }

    public AbstractRequest getRequest() {
        return this.request;
    }

    public void setRequest(AbstractRequest request) {
        this.request = request;
    }

    public String getClaimUrl() {
        return this.getString(UNCLAIMED_DRAFT_CLAIM_URL);
    }

    public boolean hasClaimUrl() {
        return this.has(UNCLAIMED_DRAFT_CLAIM_URL);
    }

    @Override
    public void addFile(File file) throws HelloSignException {
        if (!(this.request instanceof SignatureRequest)) {
            throw new HelloSignException("Cannot add files to this unclaimed draft");
        }
        this.request.addFile(file);
    }

    public void addFile(File file, int order) throws HelloSignException {
        if (!(this.request instanceof SignatureRequest)) {
            throw new HelloSignException("Cannot add files to this unclaimed draft");
        }
        this.request.addFile(file, order);
    }

    public void clearFiles() throws HelloSignException {
        if (!(this.request instanceof SignatureRequest)) {
            throw new HelloSignException("Cannot add files to this unclaimed draft");
        }
        this.request.clearDocuments();
    }

    public boolean isForEmbeddedSigning() {
        return this.isForEmbeddedSigning;
    }

    public void setIsForEmbeddedSigning(boolean b) {
        this.isForEmbeddedSigning = b;
    }

    public boolean hasSignatureRequestId() {
        return this.has(UNCLAIMED_DRAFT_SIGNATURE_REQUEST_ID);
    }

    public String getSignatureRequestId() {
        return this.getString(UNCLAIMED_DRAFT_SIGNATURE_REQUEST_ID);
    }

    @Override
    public Map<String, Serializable> getPostFields() throws HelloSignException {
        Map<String, Serializable> map = this.request.getPostFields();
        map.put(UNCLAIMED_DRAFT_TYPE, (Serializable)((Object)this.getTypeString()));
        if (this.isForEmbeddedSigning()) {
            map.put(UNCLAIMED_DRAFT_IS_FOR_EMBEDDED_SIGNING, (Serializable)((Object)"1"));
        }
        if (this.hasRequesterEmail()) {
            map.put(UNCLAIMED_DRAFT_REQUESTER_EMAIL, (Serializable)((Object)this.getRequesterEmail()));
        }
        if (this.hasUseTextTags()) {
            map.put("use_text_tags", this.isUsingTextTags());
        }
        if (this.hasHideTextTags()) {
            map.put("hide_text_tags", this.isHidingTextTags());
        }
        if (this.hasUsePreexistingFields()) {
            map.put("use_preexisting_fields", this.isUsingPreexistingFields());
        }
        return map;
    }

    public String getRequesterEmail() {
        return this.getString(UNCLAIMED_DRAFT_REQUESTER_EMAIL);
    }

    public void setRequesterEmail(String email) {
        this.set(UNCLAIMED_DRAFT_REQUESTER_EMAIL, email);
    }

    public boolean hasRequesterEmail() {
        return this.has(UNCLAIMED_DRAFT_REQUESTER_EMAIL);
    }

    @Override
    public String getTitle() {
        return this.request.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.request.setTitle(title);
    }

    @Override
    public boolean hasTitle() {
        return this.request.hasTitle();
    }

    @Override
    public String getSubject() {
        return this.request.getSubject();
    }

    @Override
    public void setSubject(String subject) {
        this.request.setSubject(subject);
    }

    @Override
    public boolean hasSubject() {
        return this.request.hasSubject();
    }

    @Override
    public String getMessage() {
        return this.request.getMessage();
    }

    @Override
    public void setMessage(String message) {
        this.request.setMessage(message);
    }

    @Override
    public boolean hasMessage() {
        return this.request.hasMessage();
    }

    @Override
    public boolean isTestMode() {
        if (this.request == null) {
            return this.getBoolean(UNCLAIMED_DRAFT_TEST_MODE);
        }
        return this.request.isTestMode();
    }

    @Override
    public void setTestMode(boolean testMode) {
        this.request.setTestMode(testMode);
    }

    @Override
    public String getRedirectUrl() {
        return this.request.getRedirectUrl();
    }

    @Override
    public void setRedirectUrl(String url) {
        this.request.setRedirectUrl(url);
    }

    @Override
    public boolean hasRedirectUrl() {
        return this.request.hasRedirectUrl();
    }

    @Override
    public String getId() {
        return this.request.getId();
    }

    @Override
    public void addCustomField(CustomField field) {
        this.request.addCustomField(field);
    }

    @Override
    public void setCustomFieldValue(String fieldNameOrApiId, String value) {
        this.request.setCustomFieldValue(fieldNameOrApiId, value);
    }

    @Override
    public List<CustomField> getCustomFields() {
        return this.request.getCustomFields();
    }

    @Override
    public void setCustomFields(Map<String, String> fields) {
        this.request.setCustomFields(fields);
    }

    @Override
    public Map<String, String> getCustomFieldsMap() {
        return this.request.getCustomFieldsMap();
    }

    @Override
    public void clearCustomFields() {
        this.request.clearCustomFields();
    }

    public Date getExpiresAt() {
        return this.getDate(UNCLAIMED_DRAFT_EXPIRES_AT);
    }
}

