/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.Account;
import com.hellosign.sdk.resource.support.CustomField;
import com.hellosign.sdk.resource.support.Document;
import com.hellosign.sdk.resource.support.TemplateRole;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class Template
extends AbstractResource {
    public static final String TEMPLATE_KEY = "template";
    public static final String TEMPLATE_ID = "template_id";
    public static final String TEMPLATE_TITLE = "title";
    public static final String TEMPLATE_MESSAGE = "message";
    public static final String TEMPLATE_DOCUMENTS = "documents";
    public static final String TEMPLATE_SIGNER_ROLES = "signer_roles";
    public static final String TEMPLATE_CC_ROLES = "cc_roles";
    public static final String TEMPLATE_ACCOUNTS = "accounts";
    public static final String TEMPLATE_CAN_EDIT = "can_edit";
    public static final String TEMPLATE_IS_CREATOR = "is_creator";
    public static final String TEMPLATE_CUSTOM_FIELDS = "custom_fields";
    public static final String TEMPLATE_IS_EMBEDDED = "is_embedded";

    public Template() {
    }

    public Template(JSONObject json) throws HelloSignException {
        super(json, TEMPLATE_KEY);
    }

    public String getId() {
        return this.getString(TEMPLATE_ID);
    }

    public boolean hasId() {
        return this.has(TEMPLATE_ID);
    }

    public String getTitle() {
        return this.getString(TEMPLATE_TITLE);
    }

    public boolean hasTitle() {
        return this.has(TEMPLATE_TITLE);
    }

    public String getMessage() {
        return this.getString(TEMPLATE_MESSAGE);
    }

    public boolean hasMessage() {
        return this.has(TEMPLATE_MESSAGE);
    }

    public List<Document> getDocuments() {
        return this.getList(Document.class, TEMPLATE_DOCUMENTS);
    }

    public List<TemplateRole> getSignerRoles() {
        List<TemplateRole> masterList = this.getList(TemplateRole.class, TEMPLATE_SIGNER_ROLES);
        if (masterList == null || masterList.isEmpty()) {
            return masterList;
        }
        if (masterList.get(0).getOrder() == null) {
            return masterList;
        }
        ArrayList<TemplateRole> sortedList = new ArrayList<TemplateRole>(masterList.size());
        for (TemplateRole r : masterList) {
            sortedList.add(r.getOrder(), r);
        }
        return sortedList;
    }

    public List<TemplateRole> getCCRoles() {
        return this.getList(TemplateRole.class, TEMPLATE_CC_ROLES);
    }

    public List<Account> getAccounts() {
        return this.getList(Account.class, TEMPLATE_ACCOUNTS);
    }

    public boolean canEdit() {
        return this.getBoolean(TEMPLATE_CAN_EDIT);
    }

    public boolean isCreator() {
        return this.getBoolean(TEMPLATE_IS_CREATOR);
    }

    public List<CustomField> getCustomFields() {
        return this.getList(CustomField.class, TEMPLATE_CUSTOM_FIELDS);
    }

    public boolean isEmbedded() {
        boolean isEmbedded = false;
        if (this.has(TEMPLATE_IS_EMBEDDED)) {
            isEmbedded = this.getBoolean(TEMPLATE_IS_EMBEDDED);
        }
        return isEmbedded;
    }
}

