/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceList<E>
extends AbstractResource
implements Iterable<E> {
    public static final String LIST_INFO = "list_info";
    public static final String PAGE = "page";
    public static final String NUM_PAGES = "num_pages";
    public static final String NUM_RESULTS = "num_results";
    public static final String PAGE_SIZE = "page_size";
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceList.class);
    private JSONObject listInfo;
    private String listKey;

    protected AbstractResourceList(JSONObject json, String listKey) throws HelloSignException {
        super(json, null);
        this.listKey = listKey;
        try {
            this.listInfo = this.dataObj.getJSONObject(LIST_INFO);
        }
        catch (JSONException e) {
            throw new HelloSignException((Exception)((Object)e));
        }
    }

    public Integer getPage() {
        return this.getListData(PAGE);
    }

    public Integer getNumPages() {
        return this.getListData(NUM_PAGES);
    }

    public Integer getNumResults() {
        return this.getListData(NUM_RESULTS);
    }

    public Integer getPageSize() {
        return this.getListData(PAGE_SIZE);
    }

    private Integer getListData(String key) {
        Integer val = null;
        try {
            val = this.listInfo.getInt(key);
        }
        catch (JSONException e) {
            logger.error("Unable to retrieve list data for key " + key + ": " + e.getMessage(), (Throwable)e);
        }
        return val;
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E> iter = null;
        try {
            iter = this.getCurrentPageList().iterator();
        }
        catch (HelloSignException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return iter;
    }

    public List<E> getCurrentPageList() throws HelloSignException {
        return this.filterCurrentPageBy(null, null);
    }

    public List<E> filterCurrentPageBy(String columnName, Serializable filterValue) {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)genericSuperclass.getActualTypeArguments()[0];
        return this.getList(clazz, this.listKey, filterValue, columnName);
    }
}

