/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource.support;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.support.types.ApiAppOauthScopeType;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class ApiAppOauth
extends AbstractResource {
    public static final String APIAPP_OAUTH_KEY = "oauth";
    public static final String APIAPP_OAUTH_CALLBACK_URL = "callback_url";
    public static final String APIAPP_OAUTH_SCOPES = "scopes";
    public static final String APIAPP_OAUTH_SECRET = "secret";
    private Set<ApiAppOauthScopeType> scopes = new HashSet<ApiAppOauthScopeType>();

    public ApiAppOauth() {
    }

    public ApiAppOauth(JSONObject json) throws HelloSignException {
        super(json, APIAPP_OAUTH_KEY);
        if (this.has(APIAPP_OAUTH_SCOPES)) {
            try {
                JSONArray scopeArray = (JSONArray)this.get(APIAPP_OAUTH_SCOPES);
                for (int i = 0; i < scopeArray.length(); ++i) {
                    String scope = scopeArray.getString(i);
                    this.scopes.add(ApiAppOauthScopeType.valueOf(scope));
                }
            }
            catch (Exception ex) {
                throw new HelloSignException(ex);
            }
        }
    }

    public String getCallbackUrl() {
        return this.getString(APIAPP_OAUTH_CALLBACK_URL);
    }

    public Boolean hasCallbackUrl() {
        return this.has(APIAPP_OAUTH_CALLBACK_URL);
    }

    public String getSecret() {
        return this.getString(APIAPP_OAUTH_SECRET);
    }

    public Set<ApiAppOauthScopeType> getScopes() {
        return this.scopes;
    }

    public void setCallbackUrl(String url) {
        this.set(APIAPP_OAUTH_CALLBACK_URL, url);
    }

    public void setScopes(Set<ApiAppOauthScopeType> scopes) {
        this.scopes = scopes;
    }

    public void addScope(ApiAppOauthScopeType scope) {
        this.scopes.add(scope);
    }

    public void clearScopes() {
        this.scopes = new HashSet<ApiAppOauthScopeType>();
    }

    public void removeScope(ApiAppOauthScopeType scope) {
        this.scopes.remove((Object)scope);
    }
}

