/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.support.CustomField;
import com.hellosign.sdk.resource.support.Document;
import com.hellosign.sdk.resource.support.Metadata;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractRequest
extends AbstractResource {
    public static final String REQUEST_TITLE = "title";
    public static final String REQUEST_SUBJECT = "subject";
    public static final String REQUEST_MESSAGE = "message";
    public static final String REQUEST_REDIRECT_URL = "signing_redirect_url";
    public static final String REQUEST_TEST_MODE = "test_mode";
    public static final String REQUEST_USE_TEXT_TAGS = "use_text_tags";
    public static final String REQUEST_USE_PREEXISTING_FIELDS = "use_preexisting_fields";
    public static final String REQUEST_HIDE_TEXT_TAGS = "hide_text_tags";
    public static final String REQUEST_METADATA = "metadata";
    public static final String REQUEST_UX_VERSION = "ux_version";
    public static final String REQUEST_CLIENT_ID = "client_id";
    public static final String REQUEST_ALLOW_DECLINE = "allow_decline";
    public static final String REQUEST_ALLOW_REASSIGN = "allow_reassign";
    public static final String REQUEST_CUSTOM_FIELDS = "custom_fields";
    public static final int UX_VERSION_1 = 1;
    public static final int UX_VERSION_2 = 2;
    private Metadata metadata;
    private List<CustomField> customFields = new ArrayList<CustomField>();
    private List<Document> documents = new ArrayList<Document>();
    private List<String> fileUrls = new ArrayList<String>();
    private boolean orderMatters = false;
    private int uxVersion = 1;
    private String clientId = null;
    private Boolean isDeclinable = null;

    public AbstractRequest() {
        this.metadata = new Metadata();
    }

    public AbstractRequest(JSONObject json, String optionalKey) throws HelloSignException {
        super(json, optionalKey);
        this.metadata = new Metadata(this.dataObj);
    }

    public Map<String, Serializable> getPostFields() throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        try {
            Metadata metadata = this.getMetadata();
            if (metadata != null) {
                JSONObject mj = metadata.getJSONObject();
                Iterator keys = mj.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    fields.put("metadata[" + key + "]", (Serializable)((Object)mj.getString(key)));
                }
            }
        }
        catch (Exception ex) {
            throw new HelloSignException("Could not extract metadata fields.", ex);
        }
        if (this.getUxVersion() == 2) {
            fields.put(REQUEST_UX_VERSION, Integer.valueOf(2));
        }
        if (this.clientId != null && !"".equals(this.clientId)) {
            fields.put(REQUEST_CLIENT_ID, (Serializable)((Object)this.clientId));
        }
        if (this.isDeclinable != null) {
            fields.put(REQUEST_ALLOW_DECLINE, (Serializable)((Object)(this.isDeclinable != false ? "1" : "0")));
        }
        if (this.hasAllowReassign()) {
            fields.put(REQUEST_ALLOW_REASSIGN, Boolean.valueOf(this.isAllowReassign()));
        }
        if (this.customFields.size() > 0) {
            JSONArray array = new JSONArray();
            for (CustomField f : this.customFields) {
                array.put((Object)f.getJSONObject());
            }
            fields.put(REQUEST_CUSTOM_FIELDS, (Serializable)((Object)array.toString()));
        }
        return fields;
    }

    public abstract String getId();

    public String getTitle() {
        return this.getString(REQUEST_TITLE);
    }

    public void setTitle(String title) {
        this.set(REQUEST_TITLE, title);
    }

    public boolean hasTitle() {
        return this.has(REQUEST_TITLE);
    }

    public String getSubject() {
        return this.getString(REQUEST_SUBJECT);
    }

    public void setSubject(String subject) {
        this.set(REQUEST_SUBJECT, subject);
    }

    public boolean hasSubject() {
        return this.has(REQUEST_SUBJECT);
    }

    public String getMessage() {
        return this.getString(REQUEST_MESSAGE);
    }

    public void setMessage(String message) {
        this.set(REQUEST_MESSAGE, message);
    }

    public boolean hasMessage() {
        return this.has(REQUEST_MESSAGE);
    }

    public void setTestMode(boolean testMode) {
        this.set(REQUEST_TEST_MODE, testMode);
    }

    public boolean isTestMode() {
        if (this.has(REQUEST_TEST_MODE)) {
            return this.getBoolean(REQUEST_TEST_MODE);
        }
        return false;
    }

    public String getRedirectUrl() {
        return this.getString(REQUEST_REDIRECT_URL);
    }

    public void setRedirectUrl(String url) {
        this.set(REQUEST_REDIRECT_URL, url);
    }

    public boolean hasRedirectUrl() {
        return this.has(REQUEST_REDIRECT_URL);
    }

    public boolean hasUseTextTags() {
        return this.has(REQUEST_USE_TEXT_TAGS);
    }

    public Boolean isUsingTextTags() {
        return this.getBoolean(REQUEST_USE_TEXT_TAGS);
    }

    public void setUseTextTags(boolean useTextTags) {
        this.set(REQUEST_USE_TEXT_TAGS, useTextTags);
    }

    public boolean hasHideTextTags() {
        return this.has(REQUEST_HIDE_TEXT_TAGS);
    }

    public Boolean isHidingTextTags() {
        return this.getBoolean(REQUEST_HIDE_TEXT_TAGS);
    }

    public void setHideTextTags(boolean hideTextTags) {
        this.set(REQUEST_HIDE_TEXT_TAGS, hideTextTags);
    }

    public boolean hasUsePreexistingFields() {
        return this.has(REQUEST_USE_PREEXISTING_FIELDS);
    }

    public Boolean isUsingPreexistingFields() {
        return this.getBoolean(REQUEST_USE_PREEXISTING_FIELDS);
    }

    public void setUsePreexistingFields(boolean usePreexistingFields) {
        this.set(REQUEST_USE_PREEXISTING_FIELDS, usePreexistingFields);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void addMetadata(String key, String value) {
        this.metadata.set(key, value);
    }

    public String getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void addFile(File file) throws HelloSignException {
        this.addFile(file, null);
    }

    public void addFile(File file, Integer order) throws HelloSignException {
        Document doc = new Document();
        doc.setFile(file);
        if (order == null) {
            this.addDocument(doc);
        } else {
            this.addDocument(doc, order);
        }
    }

    public void addDocument(Document doc) throws HelloSignException {
        if (doc == null) {
            throw new HelloSignException("Document cannot be null");
        }
        this.documents.add(doc);
    }

    public void addDocument(Document doc, int order) throws HelloSignException {
        if (doc == null) {
            throw new HelloSignException("Document cannot be null");
        }
        try {
            this.documents.add(order, doc);
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> docs) {
        this.documents = docs;
    }

    public void clearDocuments() {
        this.documents = new ArrayList<Document>();
    }

    public void setOrderMatters(boolean b) {
        this.orderMatters = b;
    }

    public boolean getOrderMatters() {
        return this.orderMatters;
    }

    public void addFileUrl(String url) {
        this.fileUrls.add(url);
    }

    public List<String> getFileUrls() {
        return this.fileUrls;
    }

    public void setFileUrls(List<String> fileUrls) {
        this.fileUrls = fileUrls;
    }

    public void setUxVersion(int uxVersion) {
        this.uxVersion = uxVersion;
    }

    public int getUxVersion() {
        return this.uxVersion;
    }

    public void setClientId(String clientId) throws HelloSignException {
        if (clientId == null) {
            throw new HelloSignException("Client ID cannot be null");
        }
        this.clientId = clientId.trim();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setIsDeclinable(Boolean isDeclinable) {
        this.isDeclinable = isDeclinable;
    }

    public Boolean getIsDeclinable() {
        return this.isDeclinable;
    }

    public boolean hasAllowReassign() {
        return this.has(REQUEST_ALLOW_REASSIGN);
    }

    public boolean isAllowReassign() {
        if (this.has(REQUEST_ALLOW_REASSIGN)) {
            return this.getBoolean(REQUEST_ALLOW_REASSIGN);
        }
        return false;
    }

    public void setAllowReassign(boolean b) {
        this.set(REQUEST_ALLOW_REASSIGN, b);
    }

    public void addCustomField(CustomField field) {
        this.customFields.add(field);
    }

    public void setCustomFieldValue(String fieldNameOrApiId, String value) {
        CustomField f = new CustomField();
        f.setName(fieldNameOrApiId);
        f.setValue(value);
        this.customFields.add(f);
    }

    public Map<String, String> getCustomFieldsMap() {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (CustomField f : this.customFields) {
            fields.put(f.getName(), f.getValue());
        }
        return fields;
    }

    public List<CustomField> getCustomFields() {
        return this.customFields;
    }

    public List<CustomField> getCustomFieldsList() {
        return this.getCustomFields();
    }

    public void setCustomFields(Map<String, String> fields) {
        this.clearCustomFields();
        for (String key : fields.keySet()) {
            CustomField f = new CustomField();
            f.setName(key);
            f.setValue(fields.get(key));
            this.customFields.add(f);
        }
    }

    public void clearCustomFields() {
        this.customFields = new ArrayList<CustomField>();
    }
}

