/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource.support;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.support.CustomField;
import com.hellosign.sdk.resource.support.FormField;
import java.io.File;
import java.util.List;
import org.json.JSONObject;

public class Document
extends AbstractResource {
    private static final String DOCUMENT_FORM_FIELDS = "form_fields";
    private static final String DOCUMENT_CUSTOM_FIELDS = "custom_fields";
    private static final String DOCUMENT_NAME = "name";
    private static final String DOCUMENT_INDEX = "index";
    private File file;

    public Document() {
    }

    public Document(JSONObject json) throws HelloSignException {
        super(json, null);
    }

    public List<FormField> getFormFields() {
        return this.getList(FormField.class, DOCUMENT_FORM_FIELDS);
    }

    public void setFormFields(List<FormField> formFields) throws HelloSignException {
        this.clearList(DOCUMENT_FORM_FIELDS);
        for (FormField formField : formFields) {
            this.addFormField(formField);
        }
    }

    public void addFormField(FormField formField) throws HelloSignException {
        if (!this.has(DOCUMENT_FORM_FIELDS)) {
            this.clearList(DOCUMENT_FORM_FIELDS);
        }
        this.addToList(DOCUMENT_FORM_FIELDS, formField);
    }

    public List<CustomField> getCustomFields() {
        return this.getList(CustomField.class, DOCUMENT_CUSTOM_FIELDS);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.getString(DOCUMENT_NAME);
    }

    public void setName(String name) {
        this.set(DOCUMENT_NAME, name);
    }

    public boolean hasName() {
        return this.has(DOCUMENT_NAME);
    }

    public Integer getIndex() {
        return this.getInteger(DOCUMENT_INDEX);
    }

    public void setIndex(Integer index) {
        this.set(DOCUMENT_INDEX, index);
    }
}

