/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractResource;
import com.hellosign.sdk.resource.Account;
import com.hellosign.sdk.resource.support.ApiAppOauth;
import com.hellosign.sdk.resource.support.WhiteLabelingOptions;
import com.hellosign.sdk.resource.support.types.ApiAppOauthScopeType;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiApp
extends AbstractResource {
    public static final String APIAPP_KEY = "api_app";
    public static final String APIAPP_CALLBACK_URL = "callback_url";
    public static final String APIAPP_CLIENT_ID = "client_id";
    public static final String APIAPP_CREATED_AT = "created_at";
    public static final String APIAPP_DOMAIN = "domain";
    public static final String APIAPP_IS_APPROVED = "is_approved";
    public static final String APIAPP_NAME = "name";
    public static final String APIAPP_OWNER_ACCOUNT = "owner_account";
    public static final String APIAPP_CUSTOM_LOGO = "custom_logo_file";
    private ApiAppOauth oauth = null;
    private Account owner_account = null;
    private File custom_logo = null;
    private WhiteLabelingOptions white_labeling_options = null;

    public ApiApp() {
    }

    public ApiApp(JSONObject json) throws HelloSignException {
        super(json, APIAPP_KEY);
        this.owner_account = new Account(this.dataObj, APIAPP_OWNER_ACCOUNT);
        if (this.dataObj.has("oauth") && !this.dataObj.isNull("oauth")) {
            this.oauth = new ApiAppOauth(this.dataObj);
        }
        if (this.dataObj.has("white_labeling_options") && !this.dataObj.isNull("white_labeling_options")) {
            this.white_labeling_options = new WhiteLabelingOptions(this.dataObj);
            try {
                this.dataObj.put("white_labeling_options", (Object)this.white_labeling_options.dataObj);
            }
            catch (JSONException e) {
                throw new HelloSignException("Unable to process white labeling options");
            }
        }
    }

    public String getCallbackUrl() {
        return this.getString(APIAPP_CALLBACK_URL);
    }

    public Boolean hasCallbackUrl() {
        return this.has(APIAPP_CALLBACK_URL);
    }

    public void setCallbackUrl(String url) {
        this.set(APIAPP_CALLBACK_URL, url);
    }

    public String getClientId() {
        return this.getString(APIAPP_CLIENT_ID);
    }

    public boolean hasClientId() {
        return this.has(APIAPP_CLIENT_ID);
    }

    public Date getCreatedAt() {
        return this.getDate(APIAPP_CREATED_AT);
    }

    public String getDomain() {
        return this.getString(APIAPP_DOMAIN);
    }

    public Boolean hasDomain() {
        return this.has(APIAPP_DOMAIN);
    }

    public void setDomain(String domain) {
        this.set(APIAPP_DOMAIN, domain);
    }

    public Boolean isApproved() {
        return this.getBoolean(APIAPP_IS_APPROVED);
    }

    public String getName() {
        return this.getString(APIAPP_NAME);
    }

    public Boolean hasName() {
        return this.has(APIAPP_NAME);
    }

    public void setName(String name) {
        this.set(APIAPP_NAME, name);
    }

    public ApiAppOauth getOauthInfo() {
        return this.oauth;
    }

    public void setOAuthCallbackUrl(String url) {
        if (this.oauth == null) {
            this.oauth = new ApiAppOauth();
        }
        this.oauth.setCallbackUrl(url);
    }

    public void setScopes(Set<ApiAppOauthScopeType> scopes) {
        if (this.oauth == null) {
            this.oauth = new ApiAppOauth();
        }
        this.oauth.setScopes(scopes);
    }

    public void addScope(ApiAppOauthScopeType scope) {
        if (this.oauth == null) {
            this.oauth = new ApiAppOauth();
        }
        this.oauth.addScope(scope);
    }

    public void clearScopes() {
        if (this.oauth == null) {
            return;
        }
        this.oauth.clearScopes();
    }

    public void removeScope(ApiAppOauthScopeType scope) {
        if (this.oauth == null) {
            return;
        }
        this.oauth.removeScope(scope);
    }

    public Account getOwnerAccount() {
        return this.owner_account;
    }

    public void setCustomLogo(File f) {
        this.custom_logo = f;
    }

    public Map<String, Serializable> getPostFields() throws HelloSignException {
        HashMap<String, Serializable> fields = new HashMap<String, Serializable>();
        try {
            ApiAppOauth oauth;
            if (this.hasName().booleanValue()) {
                fields.put(APIAPP_NAME, (Serializable)((Object)this.getName()));
            }
            if (this.hasDomain().booleanValue()) {
                fields.put(APIAPP_DOMAIN, (Serializable)((Object)this.getDomain()));
            }
            if (this.hasCallbackUrl().booleanValue()) {
                fields.put(APIAPP_CALLBACK_URL, (Serializable)((Object)this.getCallbackUrl()));
            }
            if (this.custom_logo != null && this.custom_logo.exists()) {
                fields.put(APIAPP_CUSTOM_LOGO, this.custom_logo);
            }
            if ((oauth = this.getOauthInfo()) != null) {
                Set<ApiAppOauthScopeType> scopes;
                if (oauth.hasCallbackUrl().booleanValue()) {
                    fields.put("oauth[callback_url]", (Serializable)((Object)oauth.getCallbackUrl()));
                }
                if ((scopes = oauth.getScopes()).size() > 0) {
                    String scopeStr = "";
                    for (ApiAppOauthScopeType type : scopes) {
                        scopeStr = scopeStr + type.toString() + ",";
                    }
                    scopeStr = scopeStr.substring(0, scopeStr.length() - 1);
                    fields.put("oauth[scopes]", (Serializable)((Object)scopeStr));
                }
            }
            if (this.white_labeling_options != null) {
                fields.put("white_labeling_options", (Serializable)((Object)this.white_labeling_options.toString(0)));
            }
        }
        catch (Exception e) {
            throw new HelloSignException(e);
        }
        return fields;
    }

    public void setWhiteLabelingOptions(WhiteLabelingOptions options) {
        this.white_labeling_options = options;
    }

    public WhiteLabelingOptions getWhiteLabelingOptions() {
        return this.white_labeling_options;
    }

    public String getPageBackgroundColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getPageBackgroundColor();
    }

    public void setPageBackgroundColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setPageBackgroundColor(color);
    }

    public String getHeaderBackgroundColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getHeaderBackgroundColor();
    }

    public void setHeaderBackgroundColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setHeaderBackgroundColor(color);
    }

    public String getTextColor1() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getTextColor1();
    }

    public void setTextColor1(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setTextColor1(color);
    }

    public String getTextColor2() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getTextColor2();
    }

    public void setTextColor2(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setTextColor2(color);
    }

    public String getLinkColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getLinkColor();
    }

    public void setLinkColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setLinkColor(color);
    }

    public String getPrimaryButtonColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getPrimaryButtonColor();
    }

    public void setPrimaryButtonColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setPrimaryButtonColor(color);
    }

    public String getPrimaryButtonTextColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getPrimaryButtonTextColor();
    }

    public void setPrimaryButtonTextColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setPrimaryButtonTextColor(color);
    }

    public String getPrimaryButtonHoverColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getPrimaryButtonHoverColor();
    }

    public void setPrimaryButtonHoverColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setPrimaryButtonHoverColor(color);
    }

    public String getPrimaryButtonTextHoverColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getPrimaryButtonTextHoverColor();
    }

    public void setPrimaryButtonTextHoverColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setPrimaryButtonTextHoverColor(color);
    }

    public String getSecondaryButtonColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getSecondaryButtonColor();
    }

    public void setSecondaryButtonColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setSecondaryButtonColor(color);
    }

    public String getSecondaryButtonTextColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getSecondaryButtonTextColor();
    }

    public void setSecondaryButtonTextColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setSecondaryButtonTextColor(color);
    }

    public String getSecondaryButtonHoverColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getSecondaryButtonHoverColor();
    }

    public void setSecondaryButtonHoverColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setSecondaryButtonHoverColor(color);
    }

    public String getSecondaryButtonTextHoverColor() {
        if (this.white_labeling_options == null) {
            return null;
        }
        return this.white_labeling_options.getSecondaryButtonTextHoverColor();
    }

    public void setSecondaryButtonTextHoverColor(String color) throws HelloSignException {
        if (this.white_labeling_options == null) {
            this.white_labeling_options = new WhiteLabelingOptions();
        }
        this.white_labeling_options.setSecondaryButtonTextHoverColor(color);
    }
}

