/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.http;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.AbstractHttpRequest;
import com.hellosign.sdk.http.Authentication;
import java.net.HttpURLConnection;

public class HttpDeleteRequest
extends AbstractHttpRequest {
    public HttpDeleteRequest(String url) throws HelloSignException {
        this(url, null);
    }

    public HttpDeleteRequest(String url, Authentication auth) throws HelloSignException {
        if (url == null || url.isEmpty()) {
            throw new HelloSignException("URL cannot be null or empty");
        }
        this.url = url;
        if (auth != null) {
            this.auth = new Authentication(auth);
        }
    }

    @Override
    protected HttpURLConnection getConnection() throws HelloSignException {
        HttpURLConnection connection;
        try {
            connection = HttpDeleteRequest.getProxiedConnection(this.url);
            connection.setRequestProperty("Accept-Charset", "UTF-8");
            connection.setRequestProperty("user-agent", USER_AGENT);
            if (this.auth != null) {
                this.auth.authenticate(connection, this.url);
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestMethod("DELETE");
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
        return connection;
    }
}

