/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.http.Authentication;
import com.hellosign.sdk.http.HttpClient;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.Account;
import com.hellosign.sdk.resource.ApiApp;
import com.hellosign.sdk.resource.EmbeddedRequest;
import com.hellosign.sdk.resource.EmbeddedResponse;
import com.hellosign.sdk.resource.FileUrlResponse;
import com.hellosign.sdk.resource.SignatureRequest;
import com.hellosign.sdk.resource.Team;
import com.hellosign.sdk.resource.Template;
import com.hellosign.sdk.resource.TemplateDraft;
import com.hellosign.sdk.resource.TemplateSignatureRequest;
import com.hellosign.sdk.resource.UnclaimedDraft;
import com.hellosign.sdk.resource.support.ApiAppList;
import com.hellosign.sdk.resource.support.OauthData;
import com.hellosign.sdk.resource.support.SignatureRequestList;
import com.hellosign.sdk.resource.support.TemplateList;
import com.hellosign.sdk.resource.support.types.FieldType;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class HelloSignClient {
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final String DEFAULT_BASE_API_URL = "https://api.hellosign.com/v3";
    public static final String DEFAULT_OAUTH_TOKEN_URL = "https://app.hellosign.com/oauth/token";
    public static final String ACCOUNT_URI = "/account";
    public static final String VALIDATE_ACCOUNT_URI = "/account/validate";
    public static final String ACCOUNT_CREATE_URI = "/account/create";
    public static final String TEAM_URI = "/team";
    public static final String TEAM_CREATE_URI = "/team/create";
    public static final String TEAM_DESTROY_URI = "/team/destroy";
    public static final String TEAM_ADD_MEMBER_URI = "/team/add_member";
    public static final String TEAM_REMOVE_MEMBER_URI = "/team/remove_member";
    public static final String SIGNATURE_REQUEST_URI = "/signature_request";
    public static final String SIGNATURE_REQUEST_LIST_URI = "/signature_request/list";
    public static final String SIGNATURE_REQUEST_SEND_URI = "/signature_request/send";
    public static final String TEMPLATE_URI = "/template";
    public static final String TEMPLATE_FILE_URI = "/template/files";
    public static final String TEMPLATE_LIST_URI = "/template/list";
    public static final String TEMPLATE_ADD_USER_URI = "/template/add_user";
    public static final String TEMPLATE_REMOVE_USER_URI = "/template/remove_user";
    public static final String TEMPLATE_DELETE_URI = "/template/delete";
    public static final String TEMPLATE_UPDATE_FILES_URI = "/template/update_files";
    public static final String TEMPLATE_CREATE_EMBEDDED_DRAFT_URI = "/template/create_embedded_draft";
    public static final String TEMPLATE_SIGNATURE_REQUEST_URI = "/signature_request/send_with_template";
    public static final String SIGNATURE_REQUEST_CANCEL_URI = "/signature_request/cancel";
    public static final String SIGNATURE_REQUEST_REMIND_URI = "/signature_request/remind";
    public static final String SIGNATURE_REQUEST_FINAL_COPY_URI = "/signature_request/final_copy";
    public static final String SIGNATURE_REQUEST_FILES_URI = "/signature_request/files";
    public static final String SIGNATURE_REQUEST_UPDATE_URI = "/signature_request/update";
    public static final String SIGNATURE_REQUEST_EMBEDDED_URI = "/signature_request/create_embedded";
    public static final String SIGNATURE_REQUEST_EMBEDDED_TEMPLATE_URI = "/signature_request/create_embedded_with_template";
    public static final String EMBEDDED_SIGN_URL_URI = "/embedded/sign_url";
    public static final String EMBEDDED_EDIT_URL_URI = "/embedded/edit_url";
    public static final String UNCLAIMED_DRAFT_CREATE_URI = "/unclaimed_draft/create";
    public static final String UNCLAIMED_DRAFT_CREATE_EMBEDDED_URI = "/unclaimed_draft/create_embedded";
    public static final String UNCLAIMED_DRAFT_CREATE_EMBEDDED_WITH_TEMPLATE_URI = "/unclaimed_draft/create_embedded_with_template";
    public static final String API_APP_URI = "/api_app";
    public static final String API_APP_LIST_URI = "/api_app/list";
    public static final String PARAM_FILE_TYPE_URI = "file_type";
    public static final String PARAM_GET_URL = "get_url";
    public static final String FINAL_COPY_FILE_NAME = "final-copy";
    public static final String FINAL_COPY_FILE_EXT = "pdf";
    public static final String FILES_FILE_NAME = "files";
    public static final String FILES_FILE_EXT = "pdf";
    public static final String TEMPLATE_FILE_NAME = "template";
    public static final String TEMPLATE_FILE_EXT = "pdf";
    public static final String OAUTH_CODE = "code";
    public static final String OAUTH_STATE = "state";
    public static final String OAUTH_GRANT_TYPE = "grant_type";
    public static final String OAUTH_REFRESH_TOKEN = "refresh_token";
    public static final String OAUTH_GRANT_TYPE_AUTHORIZE_CODE = "authorization_code";
    public static final String OAUTH_GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CLIENT_ID = "client_id";
    public static final String EMBEDDED_TEMPLATE_SKIP_SIGNER_ROLES = "skip_signer_roles";
    public static final String EMBEDDED_TEMPLATE_SKIP_SUBJECT_MESSAGE = "skip_subject_message";
    public static final String EMBEDDED_TEMPLATE_MERGE_FIELDS = "merge_fields";
    public static final String EMBEDDED_TEMPLATE_CC_ROLES = "cc_roles";
    private Authentication auth;
    private HttpClient httpClient;
    private String BASE_URI;
    private String OAUTH_TOKEN_URL;

    protected HelloSignClient(HttpClient client, Authentication auth) {
        this.httpClient = client;
        this.auth = auth;
        this.BASE_URI = DEFAULT_BASE_API_URL;
        String baseUrl = System.getProperty("hellosign.base.url");
        if (baseUrl != null && !baseUrl.isEmpty()) {
            this.BASE_URI = baseUrl;
        }
        this.OAUTH_TOKEN_URL = DEFAULT_OAUTH_TOKEN_URL;
        String customOauthToken = System.getProperty("hellosign.oauth.base.url");
        if (customOauthToken != null && !customOauthToken.isEmpty()) {
            this.OAUTH_TOKEN_URL = customOauthToken;
        }
    }

    public HelloSignClient(String apiKey) throws HelloSignException {
        this(new HttpClient(), new Authentication(apiKey));
        this.auth.setApiKey(apiKey);
    }

    public HelloSignClient(Authentication auth) throws HelloSignException {
        this(new HttpClient(), auth);
    }

    public void setAuthentication(Authentication auth) {
        this.auth = auth;
    }

    protected Authentication getAuth() {
        return this.auth;
    }

    public Account getAccount() throws HelloSignException {
        return new Account(this.httpClient.withAuth(this.auth).get(this.BASE_URI + ACCOUNT_URI).asJson());
    }

    public boolean isAccountValid(String email) throws HelloSignException {
        if (email == null || email.isEmpty()) {
            return false;
        }
        Account account = new Account(this.httpClient.withAuth(this.auth).withPostField("email_address", (Serializable)((Object)email)).post(this.BASE_URI + VALIDATE_ACCOUNT_URI).asJson());
        return account.hasEmail() && email.equalsIgnoreCase(account.getEmail());
    }

    public Account setCallback(String callback) throws HelloSignException {
        return new Account(this.httpClient.withAuth(this.auth).withPostField("callback_url", (Serializable)((Object)callback)).post(this.BASE_URI + ACCOUNT_URI).asJson());
    }

    public Account createAccount(String email) throws HelloSignException {
        return this.createAccount(email, null, null);
    }

    public Account createAccount(String email, String clientId, String clientSecret) throws HelloSignException {
        JSONObject copy;
        HttpClient client = this.httpClient.withAuth(this.auth).withPostField("email_address", (Serializable)((Object)email));
        if (clientId != null && clientSecret != null) {
            client = client.withPostField(CLIENT_ID, (Serializable)((Object)clientId)).withPostField(CLIENT_SECRET, (Serializable)((Object)clientSecret));
        }
        JSONObject response = client.post(this.BASE_URI + ACCOUNT_CREATE_URI).asJson();
        try {
            copy = new JSONObject(response.toString());
        }
        catch (JSONException e) {
            throw new HelloSignException((Exception)((Object)e));
        }
        OauthData data = new OauthData(copy);
        Account account = new Account(response);
        account.setOauthData(data);
        return account;
    }

    public OauthData getOauthData(String code, String clientId, String secret, String state, boolean autoSetRequestToken) throws HelloSignException {
        OauthData data = new OauthData(this.httpClient.withAuth(this.auth).withPostField(OAUTH_STATE, (Serializable)((Object)state)).withPostField(OAUTH_CODE, (Serializable)((Object)code)).withPostField(CLIENT_ID, (Serializable)((Object)clientId)).withPostField(OAUTH_GRANT_TYPE, (Serializable)((Object)OAUTH_GRANT_TYPE_AUTHORIZE_CODE)).withPostField(CLIENT_SECRET, (Serializable)((Object)secret)).post(this.OAUTH_TOKEN_URL).asJson());
        if (data != null && autoSetRequestToken) {
            this.setAccessToken(data.getAccessToken(), data.getTokenType());
        }
        return data;
    }

    public OauthData refreshOauthData(String refreshToken) throws HelloSignException {
        OauthData data = new OauthData(this.httpClient.withAuth(this.auth).withPostField(OAUTH_GRANT_TYPE, (Serializable)((Object)"refresh_token")).withPostField("refresh_token", (Serializable)((Object)refreshToken)).post(this.OAUTH_TOKEN_URL).asJson());
        if (data != null) {
            this.setAccessToken(data.getAccessToken(), data.getTokenType());
        }
        return data;
    }

    public Team getTeam() throws HelloSignException {
        return new Team(this.httpClient.withAuth(this.auth).get(this.BASE_URI + TEAM_URI).asJson());
    }

    public Team createTeam(String teamName) throws HelloSignException {
        return new Team(this.httpClient.withAuth(this.auth).withPostField("name", (Serializable)((Object)teamName)).post(this.BASE_URI + TEAM_URI).asJson());
    }

    public boolean destroyTeam() throws HelloSignException {
        return 200 == this.httpClient.withAuth(this.auth).post(this.BASE_URI + TEAM_DESTROY_URI).asHttpCode();
    }

    public Team updateTeamName(String teamName) throws HelloSignException {
        return new Team(this.httpClient.withAuth(this.auth).withPostField("name", (Serializable)((Object)teamName)).post(this.BASE_URI + TEAM_URI).asJson());
    }

    public Team inviteTeamMember(String idOrEmail) throws HelloSignException {
        String key = idOrEmail != null && idOrEmail.contains("@") ? "email_address" : "account_id";
        return new Team(this.httpClient.withAuth(this.auth).withPostField(key, (Serializable)((Object)idOrEmail)).post(this.BASE_URI + TEAM_ADD_MEMBER_URI).asJson());
    }

    public Team removeTeamMember(String idOrEmail) throws HelloSignException {
        String key = idOrEmail != null && idOrEmail.contains("@") ? "email_address" : "account_id";
        return new Team(this.httpClient.withAuth(this.auth).withPostField(key, (Serializable)((Object)idOrEmail)).post(this.BASE_URI + TEAM_REMOVE_MEMBER_URI).asJson());
    }

    public SignatureRequest getSignatureRequest(String id) throws HelloSignException {
        String url = this.BASE_URI + SIGNATURE_REQUEST_URI + "/" + id;
        return new SignatureRequest(this.httpClient.withAuth(this.auth).get(url).asJson());
    }

    public SignatureRequestList getSignatureRequests() throws HelloSignException {
        return new SignatureRequestList(this.httpClient.withAuth(this.auth).get(this.BASE_URI + SIGNATURE_REQUEST_LIST_URI).asJson());
    }

    public SignatureRequestList getSignatureRequests(int page) throws HelloSignException {
        return new SignatureRequestList(this.httpClient.withAuth(this.auth).withGetParam("page", Integer.toString(page)).get(this.BASE_URI + SIGNATURE_REQUEST_LIST_URI).asJson());
    }

    public SignatureRequestList getSignatureRequests(int page, int pageSize) throws HelloSignException {
        return new SignatureRequestList(this.httpClient.withAuth(this.auth).withGetParam("page", Integer.toString(page)).withGetParam("page_size", Integer.toString(pageSize)).get(this.BASE_URI + SIGNATURE_REQUEST_LIST_URI).asJson());
    }

    public SignatureRequest sendSignatureRequest(SignatureRequest req) throws HelloSignException {
        if (req.hasId()) {
            throw new HelloSignException("Sending an existing signature request is not supported");
        }
        return new SignatureRequest(this.httpClient.withAuth(this.auth).withPostFields(req.getPostFields()).post(this.BASE_URI + SIGNATURE_REQUEST_SEND_URI).asJson());
    }

    public SignatureRequest updateSignatureRequest(String signatureRequestId, String signatureId, String newEmailAddress) throws HelloSignException {
        String url = this.BASE_URI + SIGNATURE_REQUEST_UPDATE_URI + "/" + signatureRequestId;
        return new SignatureRequest(this.httpClient.withAuth(this.auth).withPostField("signature_id", (Serializable)((Object)signatureId)).withPostField("email_address", (Serializable)((Object)newEmailAddress)).post(url).asJson());
    }

    public TemplateList getTemplates() throws HelloSignException {
        return new TemplateList(this.httpClient.withAuth(this.auth).get(this.BASE_URI + TEMPLATE_LIST_URI).asJson());
    }

    public TemplateList getTemplates(int page) throws HelloSignException {
        return new TemplateList(this.httpClient.withAuth(this.auth).withGetParam("page", Integer.toString(page)).get(this.BASE_URI + TEMPLATE_LIST_URI).asJson());
    }

    public TemplateList getTemplates(int page, int pageSize) throws HelloSignException {
        return new TemplateList(this.httpClient.withAuth(this.auth).withGetParam("page", Integer.toString(page)).withGetParam("page_size", Integer.toString(pageSize)).get(this.BASE_URI + TEMPLATE_LIST_URI).asJson());
    }

    public File getTemplateFile(String templateId) throws HelloSignException {
        String url = this.BASE_URI + TEMPLATE_FILE_URI + "/" + templateId;
        String fileName = "template.pdf";
        return this.httpClient.withAuth(this.auth).get(url).asFile(fileName);
    }

    public String getTemplateFileUrl(String templateId) throws HelloSignException {
        String fileUrl = null;
        String url = this.BASE_URI + TEMPLATE_FILE_URI + "/" + templateId;
        JSONObject response = this.httpClient.withAuth(this.auth).withGetParam(PARAM_GET_URL, "1").get(url).asJson();
        if (response.has("file_url")) {
            try {
                fileUrl = response.getString("file_url");
            }
            catch (JSONException ex) {
                throw new HelloSignException((Exception)((Object)ex));
            }
        }
        return fileUrl;
    }

    public Template getTemplate(String templateId) throws HelloSignException {
        String url = this.BASE_URI + TEMPLATE_URI + "/" + templateId;
        return new Template(this.httpClient.withAuth(this.auth).get(url).asJson());
    }

    public Template addTemplateUser(String templateId, String idOrEmail) throws HelloSignException {
        String url = this.BASE_URI + TEMPLATE_ADD_USER_URI + "/" + templateId;
        String key = idOrEmail != null && idOrEmail.contains("@") ? "email_address" : "account_id";
        return new Template(this.httpClient.withAuth(this.auth).withPostField(key, (Serializable)((Object)idOrEmail)).post(url).asJson());
    }

    public boolean deleteTemplate(String templateId) throws HelloSignException {
        String url = this.BASE_URI + TEMPLATE_DELETE_URI + "/" + templateId;
        return 200 == this.httpClient.withAuth(this.auth).post(url).asHttpCode();
    }

    public String updateTemplateFiles(String existingTemplateId, TemplateDraft newTemplate, String clientId) throws HelloSignException {
        String url = this.BASE_URI + TEMPLATE_UPDATE_FILES_URI + "/" + existingTemplateId;
        HttpClient client = this.httpClient.withAuth(this.auth).withPostFields(newTemplate.getPostFields());
        if (clientId != null) {
            client = client.withPostField(CLIENT_ID, (Serializable)((Object)clientId));
        }
        Template t = new Template(client.post(url).asJson());
        return t.getId();
    }

    public Template removeTemplateUser(String templateId, String idOrEmail) throws HelloSignException {
        String url = this.BASE_URI + TEMPLATE_REMOVE_USER_URI + "/" + templateId;
        String key = idOrEmail != null && idOrEmail.contains("@") ? "email_address" : "account_id";
        return new Template(this.httpClient.withAuth(this.auth).withPostField(key, (Serializable)((Object)idOrEmail)).post(url).asJson());
    }

    public SignatureRequest sendTemplateSignatureRequest(TemplateSignatureRequest req) throws HelloSignException {
        return new SignatureRequest(this.httpClient.withAuth(this.auth).withPostFields(req.getPostFields()).post(this.BASE_URI + TEMPLATE_SIGNATURE_REQUEST_URI).asJson());
    }

    public boolean cancelSignatureRequest(String id) throws HelloSignException {
        String url = this.BASE_URI + SIGNATURE_REQUEST_CANCEL_URI + "/" + id;
        return 200 == this.httpClient.withAuth(this.auth).post(url).asHttpCode();
    }

    public SignatureRequest requestEmailReminder(String requestId, String email) throws HelloSignException {
        String url = this.BASE_URI + SIGNATURE_REQUEST_REMIND_URI + "/" + requestId;
        return new SignatureRequest(this.httpClient.withAuth(this.auth).withPostField("email_address", (Serializable)((Object)email)).post(url).asJson());
    }

    public File getFinalCopy(String requestId) throws HelloSignException {
        String url = this.BASE_URI + SIGNATURE_REQUEST_FINAL_COPY_URI + "/" + requestId;
        String filename = "final-copy.pdf";
        return this.httpClient.withAuth(this.auth).get(url).asFile(filename);
    }

    public File getFiles(String requestId) throws HelloSignException {
        return this.getFiles(requestId, "pdf");
    }

    public File getFiles(String requestId, String format) throws HelloSignException {
        if (format == null || format.isEmpty()) {
            format = "pdf";
        }
        String url = this.BASE_URI + SIGNATURE_REQUEST_FILES_URI + "/" + requestId;
        String fileName = "files." + format;
        return this.httpClient.withAuth(this.auth).withGetParam(PARAM_FILE_TYPE_URI, format).get(url).asFile(fileName);
    }

    public FileUrlResponse getFilesUrl(String requestId) throws HelloSignException {
        String url = this.BASE_URI + SIGNATURE_REQUEST_FILES_URI + "/" + requestId;
        HttpClient httpClient = this.httpClient.withAuth(this.auth).withGetParam(PARAM_GET_URL, "1").get(url);
        if (httpClient.getLastResponseCode() == 404) {
            throw new HelloSignException(String.format("Could not find request with id=%s", requestId));
        }
        return new FileUrlResponse(httpClient.asJson());
    }

    public AbstractRequest createEmbeddedRequest(EmbeddedRequest embeddedReq) throws HelloSignException {
        String url = this.BASE_URI;
        Class returnType = SignatureRequest.class;
        AbstractRequest req = embeddedReq.getRequest();
        if (req instanceof TemplateSignatureRequest) {
            url = url + SIGNATURE_REQUEST_EMBEDDED_TEMPLATE_URI;
        } else if (req instanceof UnclaimedDraft) {
            url = ((UnclaimedDraft)req).getRequest() instanceof TemplateSignatureRequest ? url + UNCLAIMED_DRAFT_CREATE_EMBEDDED_WITH_TEMPLATE_URI : url + UNCLAIMED_DRAFT_CREATE_EMBEDDED_URI;
            returnType = UnclaimedDraft.class;
        } else {
            url = url + SIGNATURE_REQUEST_EMBEDDED_URI;
        }
        try {
            Constructor constructor = returnType.getConstructor(JSONObject.class);
            return (AbstractRequest)constructor.newInstance(this.httpClient.withAuth(this.auth).withPostFields(embeddedReq.getPostFields()).post(url).asJson());
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public EmbeddedResponse getEmbeddedSignUrl(String signatureId) throws HelloSignException {
        String url = this.BASE_URI + EMBEDDED_SIGN_URL_URI + "/" + signatureId;
        return new EmbeddedResponse(this.httpClient.withAuth(this.auth).post(url).asJson());
    }

    public EmbeddedResponse getEmbeddedTemplateEditUrl(String templateId) throws HelloSignException {
        return this.getEmbeddedTemplateEditUrl(templateId, false, false, false);
    }

    public EmbeddedResponse getEmbeddedTemplateEditUrl(String templateId, boolean skipSignerRoles, boolean skipSubjectMessage) throws HelloSignException {
        return this.getEmbeddedTemplateEditUrl(templateId, skipSignerRoles, skipSubjectMessage, false);
    }

    public EmbeddedResponse getEmbeddedTemplateEditUrl(String templateId, boolean skipSignerRoles, boolean skipSubjectMessage, boolean testMode) throws HelloSignException {
        return this.getEmbeddedTemplateEditUrl(templateId, skipSignerRoles, skipSubjectMessage, false, null, null);
    }

    public EmbeddedResponse getEmbeddedTemplateEditUrl(String templateId, boolean skipSignerRoles, boolean skipSubjectMessage, boolean testMode, Map<String, FieldType> mergeFields, List<String> ccRoles) throws HelloSignException {
        String url = this.BASE_URI + EMBEDDED_EDIT_URL_URI + "/" + templateId;
        HttpClient client = this.httpClient.withAuth(this.auth).withPostField(EMBEDDED_TEMPLATE_SKIP_SIGNER_ROLES, Boolean.valueOf(skipSignerRoles)).withPostField(EMBEDDED_TEMPLATE_SKIP_SUBJECT_MESSAGE, Boolean.valueOf(skipSubjectMessage)).withPostField("test_mode", Boolean.valueOf(testMode));
        String mergeFieldsStr = TemplateDraft.serializeMergeFields(mergeFields);
        if (mergeFieldsStr != null) {
            client = client.withPostField(EMBEDDED_TEMPLATE_MERGE_FIELDS, (Serializable)((Object)mergeFieldsStr));
        }
        if (ccRoles == null || ccRoles.isEmpty()) {
            client = client.withPostField("cc_roles[0]", (Serializable)((Object)""));
        } else {
            for (int i = 0; i < ccRoles.size(); ++i) {
                String cc = ccRoles.get(i);
                client = client.withPostField("cc_roles[" + i + "]", (Serializable)((Object)cc));
            }
        }
        return new EmbeddedResponse(client.post(url).asJson());
    }

    public UnclaimedDraft createUnclaimedDraft(UnclaimedDraft draft) throws HelloSignException {
        String url = this.BASE_URI;
        url = draft.isForEmbeddedSigning() ? url + UNCLAIMED_DRAFT_CREATE_EMBEDDED_URI : url + UNCLAIMED_DRAFT_CREATE_URI;
        return new UnclaimedDraft(this.httpClient.withAuth(this.auth).withPostFields(draft.getPostFields()).post(url).asJson());
    }

    public TemplateDraft createEmbeddedTemplateDraft(EmbeddedRequest req) throws HelloSignException {
        return new TemplateDraft(this.httpClient.withAuth(this.auth).withPostFields(req.getPostFields()).post(this.BASE_URI + TEMPLATE_CREATE_EMBEDDED_DRAFT_URI).asJson());
    }

    public ApiApp getApiApp(String clientId) throws HelloSignException {
        String url = this.BASE_URI + API_APP_URI + "/" + clientId;
        return new ApiApp(this.httpClient.withAuth(this.auth).get(url).asJson());
    }

    public ApiAppList getApiApps() throws HelloSignException {
        return new ApiAppList(this.httpClient.withAuth(this.auth).get(this.BASE_URI + API_APP_LIST_URI).asJson());
    }

    public ApiApp createApiApp(ApiApp app) throws HelloSignException {
        return new ApiApp(this.httpClient.withAuth(this.auth).withPostFields(app.getPostFields()).post(this.BASE_URI + API_APP_URI).asJson());
    }

    public boolean deleteApiApp(String clientId) throws HelloSignException {
        String url = this.BASE_URI + API_APP_URI + "/" + clientId;
        return 204 == this.httpClient.withAuth(this.auth).delete(url).asHttpCode();
    }

    public ApiApp updateApiApp(ApiApp app) throws HelloSignException {
        if (!app.hasClientId()) {
            throw new HelloSignException("Cannot update an ApiApp without a client ID. Create one first!");
        }
        String url = this.BASE_URI + API_APP_URI + "/" + app.getClientId();
        return new ApiApp(this.httpClient.withAuth(this.auth).withPostFields(app.getPostFields()).post(url).asJson());
    }

    public boolean isOnline() throws HelloSignException {
        return true;
    }

    public void setAccessToken(String accessToken, String tokenType) throws HelloSignException {
        this.auth.setAccessToken(accessToken, tokenType);
    }
}

