/*
 * Decompiled with CFR 0.152.
 */
package com.hellosign.sdk.resource;

import com.hellosign.sdk.HelloSignException;
import com.hellosign.sdk.resource.AbstractRequest;
import com.hellosign.sdk.resource.support.Document;
import com.hellosign.sdk.resource.support.types.FieldType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TemplateDraft
extends AbstractRequest {
    public static final String TEMPLATE_DRAFT_KEY = "template";
    public static final String TEMPLATE_DRAFT_ID = "template_id";
    public static final String TEMPLATE_EDIT_URL = "edit_url";
    public static final String TEMPLATE_EXPIRES_AT = "expires_at";
    private List<String> ccRoles = new ArrayList<String>();
    private List<String> signerRoles = new ArrayList<String>();
    private Map<String, FieldType> mergeFields = new HashMap<String, FieldType>();

    public TemplateDraft() {
    }

    public TemplateDraft(JSONObject json) throws HelloSignException {
        super(json, TEMPLATE_DRAFT_KEY);
    }

    @Override
    public String getId() {
        return this.getString(TEMPLATE_DRAFT_ID);
    }

    public boolean hasId() {
        return this.has(TEMPLATE_DRAFT_ID);
    }

    public List<String> getCCRoles() {
        return this.ccRoles;
    }

    public void addCCRole(String ccRole) {
        this.ccRoles.add(ccRole);
    }

    public void addSignerRole(String signerRole) {
        this.signerRoles.add(signerRole);
    }

    public List<String> getSignerRoles() {
        return this.signerRoles;
    }

    public void addSignerRole(String role, int order) throws HelloSignException {
        try {
            this.signerRoles.add(order - 1, role);
        }
        catch (Exception ex) {
            throw new HelloSignException(ex);
        }
    }

    public void setSignerRoles(List<String> signerRoles) {
        this.signerRoles = signerRoles;
    }

    public boolean removeSignerRole(String signerRole) throws HelloSignException {
        return this.signerRoles.remove(signerRole);
    }

    public void addMergeField(String name, FieldType type) throws HelloSignException {
        if (!FieldType.checkbox.equals((Object)type) && !FieldType.text.equals((Object)type)) {
            throw new HelloSignException("Only 'text' or 'checkbox' types allowed for merge fields.");
        }
        this.mergeFields.put(name, type);
    }

    public Map<String, FieldType> getMergeFields() {
        return this.mergeFields;
    }

    public void clearMergeFields() {
        this.mergeFields = new HashMap<String, FieldType>();
    }

    public boolean hasEditUrl() {
        return this.has(TEMPLATE_EDIT_URL);
    }

    public String getEditUrl() {
        return this.getString(TEMPLATE_EDIT_URL);
    }

    public boolean hasExpiresAt() {
        return this.has(TEMPLATE_EXPIRES_AT);
    }

    public String getExpiresAt() {
        return this.getString(TEMPLATE_EXPIRES_AT);
    }

    public static String serializeMergeFields(Map<String, FieldType> mergeFields) throws HelloSignException {
        if (mergeFields == null || mergeFields.isEmpty()) {
            return null;
        }
        JSONArray mergeFieldArray = new JSONArray();
        for (String key : mergeFields.keySet()) {
            FieldType type = mergeFields.get(key);
            JSONObject mergeFieldObj = new JSONObject();
            try {
                mergeFieldObj.put("name", (Object)key);
                mergeFieldObj.put("type", (Object)type.toString());
            }
            catch (JSONException e) {
                throw new HelloSignException((Exception)((Object)e));
            }
            mergeFieldArray.put((Object)mergeFieldObj);
        }
        return mergeFieldArray.toString();
    }

    @Override
    public Map<String, Serializable> getPostFields() throws HelloSignException {
        Map<String, Serializable> fields = super.getPostFields();
        try {
            if (this.hasTitle()) {
                fields.put("title", (Serializable)((Object)this.getTitle()));
            }
            if (this.hasSubject()) {
                fields.put("subject", (Serializable)((Object)this.getSubject()));
            }
            if (this.hasMessage()) {
                fields.put("message", (Serializable)((Object)this.getMessage()));
            }
            List<String> signerRoles = this.getSignerRoles();
            for (int i = 0; i < signerRoles.size(); ++i) {
                String s = signerRoles.get(i);
                fields.put("signer_roles[" + i + "][name]", (Serializable)((Object)s));
                if (!this.getOrderMatters()) continue;
                fields.put("signer_roles[" + i + "][order]", Integer.valueOf(i));
            }
            List<String> ccRoles = this.getCCRoles();
            for (int i = 0; i < ccRoles.size(); ++i) {
                String cc = ccRoles.get(i);
                fields.put("cc_roles[" + i + "]", (Serializable)((Object)cc));
            }
            List<Document> docs = this.getDocuments();
            for (int i = 0; i < docs.size(); ++i) {
                Document d = docs.get(i);
                fields.put("file[" + i + "]", d.getFile());
            }
            List<String> fileUrls = this.getFileUrls();
            for (int i = 0; i < fileUrls.size(); ++i) {
                fields.put("file_url[" + i + "]", (Serializable)((Object)fileUrls.get(i)));
            }
            String mergeFieldStr = TemplateDraft.serializeMergeFields(this.getMergeFields());
            if (mergeFieldStr != null) {
                fields.put("merge_fields", (Serializable)((Object)mergeFieldStr));
            }
            if (this.hasUsePreexistingFields()) {
                fields.put("use_preexisting_fields", Boolean.valueOf(true));
            }
            if (this.isTestMode()) {
                fields.put("test_mode", Boolean.valueOf(true));
            }
        }
        catch (Exception ex) {
            throw new HelloSignException("Could not extract form fields from TemplateDraft.", ex);
        }
        return fields;
    }
}

